/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.util;

import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.util.HashSet;
import com.wm.util.QName;
import com.wm.xsd.util.BuiltInSimpleTypes;
import com.wm.xsd.util.URTypes;

public class SimpleTypeHelper {
    static final String SCHEMA_REC_NS_STR = "http://www.w3.org/2001/XMLSchema";
    static final String SCHEMA_CR_NS_STR = "http://www.w3.org/2000/10/XMLSchema";
    private static final URTypes UR_TYPES = new URTypes();

    public static final QName map(QName builtin) {
        return BuiltInSimpleTypes.map(builtin);
    }

    public static final QName getBaseTypeQName(SimpleType type, SimpleType baseType) {
        HashSet typeHeirarchy = baseType.getTypeHeirarchy();
        if (typeHeirarchy == null) {
            return SimpleTypeHelper.getBaseTypeQName(type);
        }
        return SimpleTypeHelper.getBaseTypeQName(baseType);
    }

    public static final QName getBaseTypeQName(SimpleType st) {
        HashSet typeHeirarchy = st.getTypeHeirarchy();
        if (typeHeirarchy == null) {
            String version = st.getVersion();
            if (version.equals("dtVersion2")) {
                return QName.create(SCHEMA_REC_NS_STR, st.getName());
            }
            return QName.create(SCHEMA_CR_NS_STR, st.getName());
        }
        Object[] heirarchy = typeHeirarchy.toArray();
        for (int i = heirarchy.length - 1; i > -1; --i) {
            QName baseTypeQName = (QName)heirarchy[i];
            if (UR_TYPES.contains(baseTypeQName) || !BuiltInSimpleTypes.isBuiltIn(baseTypeQName)) continue;
            return BuiltInSimpleTypes.map(baseTypeQName);
        }
        return QName.create(SCHEMA_REC_NS_STR, st.getSourceName());
    }

    public static final String mapFacets(String facetType) {
        String[][] simpleKeys = new String[][]{{"precision", "totalDigits"}, {"scale", "fractionDigits"}, {"encoding", null}, {"duration", null}, {"period", null}};
        for (int i = 0; i < simpleKeys.length; ++i) {
            if (!simpleKeys[i][0].equals(facetType)) continue;
            return simpleKeys[i][1];
        }
        return facetType;
    }

    public static String[] getFacetKeys(SimpleType st) {
        NSRecord record = st.getFacetsMetadata();
        NSField[] fields = record.getFields();
        String[] facetKeys = new String[fields.length];
        for (int i = 0; i < facetKeys.length; ++i) {
            facetKeys[i] = fields[i].getName();
        }
        return facetKeys;
    }
}

