/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.WSDException;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.util.TypeName;
import com.wm.xsd.coder.IXSDCoder;
import com.wm.xsd.coder.XSDCoderException;
import com.wm.xsd.coder.XSDCoderFactory;
import com.wm.xsd.component.Namespaces;
import com.wm.xsd.component.XSComplexContent;
import com.wm.xsd.component.XSComplexType;
import com.wm.xsd.component.XSContentType;
import com.wm.xsd.component.XSElement;
import com.wm.xsd.component.XSElementParticle;
import com.wm.xsd.component.XSElementReference;
import com.wm.xsd.component.XSParticle;
import com.wm.xsd.component.XSSchema;
import com.wm.xsd.component.XSSequence;
import com.wm.xsd.mapper.IResult;
import com.wm.xsd.mapper.IXSDMapper;
import com.wm.xsd.mapper.IXSDMapperFactory;
import com.wm.xsd.mapper.XSDMapperException;
import com.wm.xsd.mapper.resources.MapperExceptionBundle;
import com.wm.xsd.util.CreateXSDConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public class CreateXSD
implements CreateXSDConstants {
    public static boolean getUseGeneratedURIForCreateXSD() {
        return new Boolean(System.getProperty("watt.core.xsd.useGeneratedURIForCreateXSD", String.valueOf(false)));
    }

    public static boolean getUseGeneratedURIForNonRPC() {
        return new Boolean(System.getProperty("watt.core.xsd.useGeneratedURIForNonRPC", String.valueOf(true)));
    }

    static OutputStream[] createXSD(NSRecord[] docTypes, Name aURI, int initialPadding, boolean useRpcStyle, boolean useGlobalDeclForToplevlField, boolean useSchemaLocation, boolean separateXSD) throws IOException, XSDMapperException {
        ByteArrayOutputStream[] streams = null;
        IXSDMapper mapper = IXSDMapperFactory.create(1);
        mapper.setUseGlobalDeclForTopLevelField(useGlobalDeclForToplevlField);
        mapper.setUseSchemaLocation(useSchemaLocation);
        mapper.setUseSoapRPCStyle(useRpcStyle);
        IResult result = mapper.map(docTypes, aURI);
        IData[] warnings = result.getWarnings();
        if (warnings != null) {
            for (int index = 0; index < warnings.length; ++index) {
                System.out.println(warnings[index].toString());
            }
        }
        if (result.successful()) {
            XSSchema[] schemata = result.getSchemata();
            Namespaces ns = result.getNamespaces();
            IXSDCoder coder = XSDCoderFactory.create(XSDCoderFactory.VERSION_1_0);
            coder.setMakeItPretty(true);
            coder.setInitialPadding(initialPadding);
            try {
                if (separateXSD) {
                    streams = new ByteArrayOutputStream[schemata.length];
                    for (int i = 0; i < streams.length; ++i) {
                        coder.encode((OutputStream)streams[i], schemata[i], ns);
                    }
                } else {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    streams = new ByteArrayOutputStream[]{stream};
                    coder.encode((OutputStream)stream, schemata, ns);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return streams;
    }

    static IData generateXSD(NSRecord[] docTypes, Name aURI) throws IOException, XSDMapperException, XSDCoderException {
        IData result = IDataFactory.create();
        IDataCursor idc = result.getCursor();
        Object streams = null;
        IXSDMapper mapper = IXSDMapperFactory.create(1);
        mapper.setUseGlobalDeclForTopLevelField(true);
        mapper.setUseSchemaLocation(true);
        mapper.setUseSoapRPCStyle(false);
        IResult mapresult = mapper.map(docTypes, aURI);
        IDataUtil.put(idc, "warnings", mapresult.getWarnings());
        IDataUtil.put(idc, "errors", mapresult.getErrors());
        IDataUtil.put(idc, "DUPLICATES_RESOLVED", mapresult.getDuplicatesResolved());
        if (mapresult.successful()) {
            XSSchema[] schemata = mapresult.getSchemata();
            Namespaces ns = mapresult.getNamespaces();
            Hashtable schemaURLs = mapresult.getSchemaURLs();
            IXSDCoder coder = XSDCoderFactory.create(XSDCoderFactory.VERSION_1_0);
            coder.setMakeItPretty(true);
            coder.setInitialPadding(0);
            coder.setUseXMLDeclaration(true);
            IData[] xsds = new IData[schemata.length];
            for (int i = 0; i < schemata.length; ++i) {
                String tns = schemata[i].getTargetNamespace();
                Object targetNS = tns == null ? IResult.NULL : tns;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                coder.encode((OutputStream)stream, schemata[i], ns);
                IData tempData = IDataFactory.create();
                IDataCursor tempCursor = tempData.getCursor();
                IDataUtil.put(tempCursor, "url", schemaURLs.get(targetNS));
                IDataUtil.put(tempCursor, "source", stream.toString("UTF8"));
                tempCursor.destroy();
                xsds[i] = tempData;
            }
            IDataUtil.put(idc, "xsd", xsds);
            IDataUtil.put(idc, "isSuccessful", "true");
        } else {
            IDataUtil.put(idc, "isSuccessful", "false");
        }
        idc.destroy();
        return result;
    }

    public static IData generateXSD(Message[] msgs, Name aURI, int initialPadding, NSWSDescriptor wsd) throws IOException, XSDMapperException, XSDCoderException {
        NSRecord[] records = new NSRecord[msgs.length];
        boolean useSoapRPCStyle = false;
        boolean useSoapLiteralStyle = false;
        boolean isProprietary = false;
        for (int i = 0; i < msgs.length; ++i) {
            records[i] = msgs[i].getNSRecord();
            if (msgs[i].useSoapRpc()) {
                useSoapRPCStyle = true;
            } else if (msgs[i].useHttpGetPost()) {
                isProprietary = true;
            }
            if (!msgs[i].useSoapLiteral()) continue;
            useSoapLiteralStyle = true;
        }
        if (!useSoapRPCStyle && !CreateXSD.getUseGeneratedURIForNonRPC()) {
            aURI = null;
        }
        IXSDMapper mapper = IXSDMapperFactory.create(1);
        mapper.setUseGlobalDeclForTopLevelField(isProprietary);
        mapper.setUseSchemaLocation(false);
        mapper.setUseSoapRPCStyle(useSoapRPCStyle);
        mapper.setUseSoapLiteralStyle(useSoapLiteralStyle);
        mapper.setReportRecursionWarning(false);
        boolean isGenerateTypeNameWithPrefix = false;
        if (wsd == null) {
            isGenerateTypeNameWithPrefix = true;
        }
        mapper.setGenerateTypeNameWithPrefix(isGenerateTypeNameWithPrefix);
        IResult mapresult = mapper.map(records, !isProprietary ? aURI : null);
        IData result = IDataFactory.create();
        IDataCursor idc = result.getCursor();
        IDataUtil.put(idc, "warnings", mapresult.getWarnings());
        IDataUtil.put(idc, "errors", mapresult.getErrors());
        IDataUtil.put(idc, "DUPLICATES_RESOLVED", mapresult.getDuplicatesResolved());
        if (mapresult.successful()) {
            XSSchema[] schemata = mapresult.getSchemata();
            Namespaces ns = mapresult.getNamespaces();
            CreateXSD.getPartsInfo(msgs, mapresult.getTypeNamesForInputDocumentTypes(), schemata, result);
            IXSDCoder coder = XSDCoderFactory.create(XSDCoderFactory.VERSION_1_0);
            coder.setMakeItPretty(true);
            coder.setInitialPadding(initialPadding);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            coder.encode((OutputStream)stream, schemata, ns);
            IDataUtil.put(idc, "xsd", stream.toString("UTF8"));
            IDataUtil.put(idc, "isSuccessful", "true");
        } else {
            IDataUtil.put(idc, "isSuccessful", "false");
        }
        idc.destroy();
        return result;
    }

    public static IData generateXSD(NSNode nsNode, IData pipeline) throws IOException, XSDMapperException, XSDCoderException, WSDException {
        int type;
        if (nsNode == null) {
            throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.NODE_IS_NULL, "");
        }
        IData result = null;
        Name aURI = null;
        if (CreateXSD.getUseGeneratedURIForCreateXSD()) {
            String path = nsNode.getNSName().getInterfaceName().toString();
            String nodename = nsNode.getNSName().getNodeName().toString();
            String aURIstr = TypeName.createURI(path, nodename);
            aURI = Name.create(aURIstr);
        }
        if ((type = nsNode.getNodeType()) == 4) {
            result = CreateXSD.generateXSD((NSRecord)nsNode, aURI);
        } else if (type == 2) {
            result = CreateXSD.generateXSD((NSService)nsNode, aURI);
        }
        if (result == null) {
            throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.INVALID_GENERATEXSD_PARAM, "");
        }
        IDataCursor idc = pipeline.getCursor();
        IDataCursor rc = result.getCursor();
        IDataUtil.put(idc, "isSuccessful", String.valueOf(IDataUtil.getBoolean(rc, "isSuccessful")));
        IDataUtil.put(idc, "xsd", CreateXSD.format((IData[])IDataUtil.get(rc, "xsd")));
        Object o = IDataUtil.get(rc, "errors");
        if (o != null) {
            IDataUtil.put(idc, "errors", o);
        }
        if ((o = IDataUtil.get(rc, "warnings")) != null) {
            IDataUtil.put(idc, "warnings", o);
        }
        idc.destroy();
        rc.destroy();
        return pipeline;
    }

    static IData generateXSD(NSService svc, Name aURI) throws IOException, XSDMapperException, XSDCoderException, WSDException {
        if (svc != null) {
            NSSignature sig = svc.getSignature();
            if (sig == null) {
                throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.INVALID_SERVICE_SIGNATURE, "");
            }
            String temp = null;
            NSRecord[] records = new NSRecord[2];
            records[0] = sig.getInput();
            if (records[0] != null && records[0].getName() == null && records[0].getNSName() == null) {
                temp = Strings.cat(svc.getNSName().getNodeName().toString(), "Input");
                records[0].setName(temp);
            }
            records[1] = sig.getOutput();
            if (records[1] != null && records[1].getName() == null && records[1].getNSName() == null) {
                records[1].setName(svc.getNSName().getNodeName().toString() + "Output");
            }
            return CreateXSD.generateXSD(records, aURI);
        }
        return null;
    }

    static IData generateXSD(NSSignature sig, Name aURI) throws IOException, XSDMapperException, XSDCoderException {
        if (sig == null) {
            return null;
        }
        NSRecord[] records = new NSRecord[]{sig.getInput(), sig.getOutput()};
        if (records[0].getName() == null && records[0].getNSName() == null) {
            records[0].setName(aURI.toString() + "Input");
        }
        if (records[1].getName() == null && records[1].getNSName() == null) {
            records[1].setName(aURI.toString() + "Output");
        }
        return CreateXSD.generateXSD(records, aURI);
    }

    static IData generateXSD(NSRecord record, Name aURI) throws IOException, XSDMapperException, XSDCoderException {
        NSRecord[] records = new NSRecord[]{record};
        return CreateXSD.generateXSD(records, aURI);
    }

    private static void getPartsInfo(Message[] msgs, QName[] typeNames, XSSchema[] schemata, IData result) throws XSDMapperException {
        XSSchema rootSchema = null;
        IDataCursor idc = result.getCursor();
        XSComplexType complexType = null;
        for (int i = 0; i < typeNames.length; ++i) {
            QName typeName = typeNames[i];
            if (typeNames[i] == null) continue;
            String namespaceName = typeName.getNamespace();
            for (int j = 0; j < schemata.length; ++j) {
                String tns = schemata[j].getTargetNamespace();
                if (tns != null) {
                    if (!tns.equals(namespaceName)) continue;
                    rootSchema = schemata[j];
                    break;
                }
                if (namespaceName != null) continue;
                rootSchema = schemata[j];
                break;
            }
            if (rootSchema == null || (complexType = (XSComplexType)rootSchema.getTypeDefinition(typeName)) == null) continue;
            ArrayList list = CreateXSD.getPartQNames(complexType, msgs[i].useSoapRpc());
            msgs[i].setPartInfoFromRecord(list);
        }
        IDataUtil.put(idc, "msgs", msgs);
        idc.destroy();
    }

    private static ArrayList getPartQNames(XSComplexType type, boolean useRPC) throws XSDMapperException {
        ArrayList<QName[]> list = new ArrayList<QName[]>(5);
        XSContentType ctype = type.getContentType();
        if (ctype.isComplexContent()) {
            XSSequence xsq = (XSSequence)((XSComplexContent)ctype).getContentModel();
            XSParticle[] parts = xsq.getParticles();
            for (int i = 0; i < parts.length; ++i) {
                XSElement element = ((XSElementParticle)parts[i]).getElementDeclaration();
                QName[] partQNames = new QName[2];
                partQNames[0] = element.getQName();
                QName qName = useRPC ? (element instanceof XSElementReference ? element.getQName() : element.getTypeDefinition().getQName()) : (partQNames[1] = null);
                if (partQNames[0] == null) continue;
                list.add(partQNames);
            }
        } else {
            throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.MUST_BE_COMPLEXCONTENT, null);
        }
        return list;
    }

    private static IData format(IData[] xsds) {
        if (xsds == null) {
            return null;
        }
        ArrayList<IData> list = new ArrayList<IData>(xsds.length);
        IData schema = null;
        IDataCursor schemaCursor = null;
        String url = null;
        IData top = null;
        for (int i = 0; i < xsds.length; ++i) {
            schema = xsds[i];
            schemaCursor = schema.getCursor();
            url = IDataUtil.getString(schemaCursor, "url");
            if (url.equals("no-tns.xsd")) {
                top = schema;
                continue;
            }
            list.add(schema);
        }
        IData result = IDataFactory.create();
        IDataCursor resultCursor = result.getCursor();
        if (top != null) {
            IDataUtil.copy(top, result);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            resultCursor.insertAfter("import-xsd", list.get(i));
        }
        return result;
    }
}

