/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.mapper;

import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.lang.schema.datatypev2.DatatypeRef;
import com.wm.lang.schema.datatypev2.WmString;
import com.wm.lang.schema.datatypev2.WmUnion;
import com.wm.util.LocalizedException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.QNameComposer;
import com.wm.util.Strings;
import com.wm.util.TypeName;
import com.wm.xsd.component.XSAny;
import com.wm.xsd.component.XSAnyAttribute;
import com.wm.xsd.component.XSAttribute;
import com.wm.xsd.component.XSAttributeReference;
import com.wm.xsd.component.XSComplexContent;
import com.wm.xsd.component.XSComplexType;
import com.wm.xsd.component.XSComponentFactory;
import com.wm.xsd.component.XSContentType;
import com.wm.xsd.component.XSElement;
import com.wm.xsd.component.XSElementParticle;
import com.wm.xsd.component.XSElementReference;
import com.wm.xsd.component.XSImport;
import com.wm.xsd.component.XSSchema;
import com.wm.xsd.component.XSSequence;
import com.wm.xsd.component.XSSimpleContent;
import com.wm.xsd.component.XSSimpleType;
import com.wm.xsd.component.XSTag;
import com.wm.xsd.component.XSTypeDefinition;
import com.wm.xsd.component.XSTypeReference;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import com.wm.xsd.mapper.Field_QName_Tag;
import com.wm.xsd.mapper.IResult;
import com.wm.xsd.mapper.IXSDMapper;
import com.wm.xsd.mapper.MapResult;
import com.wm.xsd.mapper.MapperConstants;
import com.wm.xsd.mapper.MapperContext;
import com.wm.xsd.mapper.XSDMapperException;
import com.wm.xsd.mapper.resources.MapperExceptionBundle;
import com.wm.xsd.util.BuiltInSimpleTypes;
import java.util.HashSet;

class XSDMapper
implements IXSDMapper,
MapperConstants {
    private String _attrPrefix = "@";
    private boolean _useSoapRPCStyle = false;
    private boolean _useSoapLiteralStyle = false;
    private boolean _useGlobalDeclForToplevlField = false;
    private boolean _useSchemaLocation = false;
    private boolean _useWrapperComplexTypesForInputDocumentTypes = true;
    private boolean _reportRecursionWarning = true;
    private MapperContext _context;
    private String _aURIString = null;
    private boolean _isGenerateTypeNameWithPrefix = true;
    private static final String[] objecttypes = new String[]{"anyType", "boolean", "byte", "string", "double", "float", "int", "long", "short", "dateTime", "byte", "decimal", "integer"};

    XSDMapper() {
    }

    public void setAttributePrefix(String attrPrefix) {
        this._attrPrefix = attrPrefix;
    }

    public void setUseSoapRPCStyle(boolean use) {
        this._useSoapRPCStyle = use;
    }

    public void setUseSoapLiteralStyle(boolean use) {
        this._useSoapLiteralStyle = use;
    }

    public void setUseSchemaLocation(boolean use) {
        this._useSchemaLocation = use;
    }

    public void setUseGlobalDeclForTopLevelField(boolean use) {
        this._useGlobalDeclForToplevlField = use;
    }

    public void setUseWrapperComplexTypesForInputDocumentTypes(boolean use) {
        this._useWrapperComplexTypesForInputDocumentTypes = use;
    }

    public void setReportRecursionWarning(boolean use) {
        this._reportRecursionWarning = use;
    }

    public void setGenerateTypeNameWithPrefix(boolean isGenerateTypeNameWithPrefix) {
        this._isGenerateTypeNameWithPrefix = isGenerateTypeNameWithPrefix;
    }

    public IResult map(NSRecord[] documentTypes, Name aURI) throws XSDMapperException {
        this._context = MapperContext.create();
        this._aURIString = aURI != null ? aURI.toString() : null;
        XSComplexType cType = null;
        XSContentType contType = null;
        QName typeName = null;
        NSName nsName = null;
        String nodeName = null;
        boolean isClosed = false;
        String tns = null;
        int type = 0;
        for (int i = 0; i < documentTypes.length; ++i) {
            if (documentTypes[i] != null) {
                if (this._reportRecursionWarning && documentTypes[i].isRecursive()) {
                    this._context.addWarning(new LocalizedMessage(MapperExceptionBundle.class, MapperExceptionBundle.WARNING_RECURSIVE_DOC, null));
                }
                isClosed = documentTypes[i].isClosed();
                type = documentTypes[i].getType();
                switch (type) {
                    case 4: {
                        nsName = ((NSRecordRef)documentTypes[i]).getTargetName();
                        break;
                    }
                    default: {
                        nsName = documentTypes[i].getNSName();
                    }
                }
                if (nsName != null) {
                    typeName = this._context.getComplexTypeQName(nsName, 0);
                    if (this._context.getComplexTypeQName(nsName, 0) != null) {
                        this._context.addTypeNameForInputDocumentType(typeName);
                        continue;
                    }
                    nodeName = nsName.getNodeName().toString();
                } else {
                    nodeName = documentTypes[i].getName();
                }
                typeName = this._useSoapRPCStyle ? (this._isGenerateTypeNameWithPrefix ? TypeName.create(this._aURIString, nodeName, this._context._typeNames, this._context._duplicatesResolved) : TypeName.create2(this._aURIString, nodeName, this._context._typeNames, this._context._duplicatesResolved)) : TypeName.create2(this._aURIString, nodeName, this._context._typeNames, this._context._duplicatesResolved);
                this._context.addTypeNameForInputDocumentType(typeName);
                cType = XSComponentFactory.createComplexType(typeName);
                this._context.addNamespace(typeName.getNamespaceName(), "tns", null);
                this._context.addGlobleTypesToSchema(typeName, cType);
                if (nsName != null) {
                    this._context.addComplexTypeQName(nsName, typeName, 0);
                }
                tns = typeName.getNamespace();
                this._context._currentSchema.push(this._context.getSchema(tns));
                contType = this.mapFields(documentTypes[i].getFields(), nodeName, typeName, isClosed, true, 0);
                this._context._currentSchema.pop();
                cType.setContentType(contType);
                continue;
            }
            this._context.addTypeNameForInputDocumentType(null);
        }
        this._context.removeBogusSchemata();
        if (!this._useWrapperComplexTypesForInputDocumentTypes) {
            this._context.removeWrapperComplexTypesForInputDocumentTypes();
        }
        return new MapResult(this._context);
    }

    private XSContentType mapFields(NSField[] fields, String recName, QName parentTypeName, boolean isClosed, boolean isTopLevel, int parentDim) throws XSDMapperException {
        XSContentType cType = null;
        QName tagQName = null;
        QName typeQName = null;
        XSElementParticle ep = null;
        ContentType fType = null;
        XSSequence xsq = null;
        Name uri = null;
        String fieldName = null;
        String prefix = null;
        NSName nsName = null;
        NSRecord tempRec = null;
        NSRecordRef tempRecRef = null;
        XSSimpleType st = null;
        int colonIndex = -1;
        boolean recIsClosed = false;
        boolean isFormQualified = false;
        boolean isGlobal = false;
        HashSet<String> attrNames = new HashSet<String>(2);
        boolean A = false;
        boolean B = false;
        boolean C = false;
        boolean D = false;
        if (this._useSoapRPCStyle && !this._useSoapLiteralStyle) {
            C = true;
        } else {
            for (int i = 0; i < fields.length; ++i) {
                fieldName = fields[i].getName();
                if (fieldName.equals("*body")) {
                    SimpleType contType;
                    QName contTypeQName;
                    if (A) {
                        throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.DUP_STAR_BODY, null, recName);
                    }
                    A = true;
                    if (fields[i].getContentType() == null || (contTypeQName = (contType = (SimpleType)fields[i].getContentType()).getQName()) != null && (contTypeQName == null || contTypeQName == URSIMPLETYPE)) continue;
                    B = true;
                    if (!(contType instanceof DatatypeRef) && !(contType instanceof com.wm.lang.schema.datatype.DatatypeRef)) {
                        contType = (SimpleType)contType.deepClone();
                    }
                    st = XSComponentFactory.createSimpleType(contType);
                    continue;
                }
                if (fieldName.startsWith(this._attrPrefix)) {
                    if (fields[i].getDimensions() > 0) {
                        throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.TWO_DIM_ATTR, null, fieldName);
                    }
                    if (attrNames.contains(fieldName)) {
                        throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.DUP_ATTR, null, recName);
                    }
                    attrNames.add(fieldName);
                    D = true;
                    continue;
                }
                C = true;
            }
        }
        if (B && C) {
            throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.INVALID_CONTENT_MODEL, null, recName);
        }
        if (B && !C) {
            st.setFromSimpleContent(true);
            cType = XSComponentFactory.createSimpleContent(st);
            ((XSSimpleContent)cType).setWillHaveAttributes(D);
        }
        if (!A || A && !B) {
            xsq = XSComponentFactory.createSequence();
            cType = XSComponentFactory.createComplexContent(xsq);
        }
        for (int j = 0; j < fields.length; ++j) {
            fieldName = fields[j].getName();
            uri = fields[j].getXmlNamespace();
            colonIndex = fieldName.indexOf(58);
            if (colonIndex != -1 && colonIndex != 0) {
                prefix = fieldName.substring(0, colonIndex);
            }
            if (uri == null && prefix != null && !this._useSoapRPCStyle) {
                throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.PREFIX_WO_NAMESPACE, null, fieldName);
            }
            if (uri != null && prefix != null) {
                this._context.addNamespace(uri, prefix, fieldName);
                prefix = null;
            }
            boolean isNillable = fields[j].isNillable();
            boolean isOptional = fields[j].isOptional();
            int dim = fields[j].getDimensions();
            int nodeType = fields[j].getType();
            isFormQualified = fields[j].isFormQualified();
            isGlobal = fields[j].isGlobal();
            if (this._useSoapRPCStyle) {
                try {
                    tagQName = QNameComposer.compose(fields[j].getName(), uri != null ? uri.toString() : null, this._useSoapRPCStyle);
                }
                catch (LocalizedException e) {
                    throw new XSDMapperException(e);
                }
            }
            QName encodingTypeName = null;
            switch (nodeType) {
                case 2: {
                    tempRec = (NSRecord)fields[j];
                    nsName = tempRec.getNSName();
                    recIsClosed = tempRec.isClosed();
                    if (this._useSoapRPCStyle) {
                        encodingTypeName = fields[j].getSchemaTypeName();
                        typeQName = encodingTypeName != null && encodingTypeName.getNamespace() != null ? encodingTypeName : (this._isGenerateTypeNameWithPrefix ? TypeName.create(uri != null ? uri.toString() : this._aURIString, tagQName.getNCName(), this._context._typeNames, this._context._duplicatesResolved) : TypeName.create2(uri != null ? uri.toString() : this._aURIString, tagQName.getNCName(), this._context._typeNames, this._context._duplicatesResolved));
                    }
                    ep = this.mapDocType(tempRec, fieldName, typeQName, nsName, uri, dim, parentTypeName, recIsClosed, false, isTopLevel, isFormQualified, isGlobal);
                    break;
                }
                case 4: {
                    tempRecRef = (NSRecordRef)fields[j];
                    recIsClosed = tempRecRef.isClosed();
                    NSRecord target = ((NSRecordRef)fields[j]).getNSRecord();
                    if (!tempRecRef.targetExists()) {
                        String targetname = ((NSRecordRef)fields[j]).getTargetName().toString();
                        throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.CANNOT_GET_RECORD, null, targetname);
                    }
                    nsName = target.getNSName();
                    typeQName = this._context.getComplexTypeQName(nsName, 0);
                    if (typeQName == null) {
                        String targetName = nsName.getNodeName().toString();
                        typeQName = this._useSoapRPCStyle ? ((encodingTypeName = fields[j].getSchemaTypeName()) != null && encodingTypeName.getNamespace() != null ? encodingTypeName : (this._isGenerateTypeNameWithPrefix ? TypeName.create(uri != null ? uri.toString() : this._aURIString, targetName, this._context._typeNames, this._context._duplicatesResolved) : TypeName.create2(uri != null ? uri.toString() : this._aURIString, targetName, this._context._typeNames, this._context._duplicatesResolved))) : TypeName.create2(uri != null ? uri.toString() : this._aURIString, targetName, this._context._typeNames, this._context._duplicatesResolved);
                    }
                    ep = this.mapDocType(tempRecRef, fieldName, typeQName, nsName, uri, dim, parentTypeName, recIsClosed, true, isTopLevel, isFormQualified, isGlobal);
                    break;
                }
                case 1: {
                    fType = fields[j].getContentType();
                    encodingTypeName = fields[j].getSchemaTypeName();
                    if (this._useSoapRPCStyle || this._aURIString != null) {
                        if (encodingTypeName != null) {
                            if (encodingTypeName.getNamespace() != null) {
                                typeQName = encodingTypeName;
                            } else if (encodingTypeName.getNamespace() == null && (typeQName = this._context.getSimpleTypeQName(encodingTypeName)) == null) {
                                typeQName = TypeName.create2(uri != null ? uri.toString() : this._aURIString, encodingTypeName.getNCName(), this._context._typeNames, this._context._duplicatesResolved);
                            }
                        } else if (this._useSoapRPCStyle) {
                            typeQName = this._isGenerateTypeNameWithPrefix ? TypeName.create(uri != null ? uri.toString() : this._aURIString, tagQName.getNCName(), this._context._typeNames, this._context._duplicatesResolved) : TypeName.create2(uri != null ? uri.toString() : this._aURIString, tagQName.getNCName(), this._context._typeNames, this._context._duplicatesResolved);
                        }
                    }
                    ep = this.mapField(cType, fieldName, typeQName, fType, uri, parentTypeName, false, isTopLevel, dim, isFormQualified, isGlobal, isOptional);
                    break;
                }
                case 3: {
                    fType = fields[j].getContentType();
                    if (this._useSoapRPCStyle || this._aURIString != null) {
                        if (encodingTypeName != null) {
                            if (encodingTypeName.getNamespace() == null && (typeQName = this._context.getSimpleTypeQName(encodingTypeName)) == null) {
                                typeQName = TypeName.create2(uri != null ? uri.toString() : this._aURIString, encodingTypeName.getNCName(), this._context._typeNames, this._context._duplicatesResolved);
                            }
                        } else if (this._useSoapRPCStyle) {
                            typeQName = this._isGenerateTypeNameWithPrefix ? TypeName.create(uri != null ? uri.toString() : this._aURIString, tagQName.getNCName(), this._context._typeNames, this._context._duplicatesResolved) : TypeName.create2(uri != null ? uri.toString() : this._aURIString, tagQName.getNCName(), this._context._typeNames, this._context._duplicatesResolved);
                        }
                    }
                    if (fType == null && this._useSoapRPCStyle) {
                        String wrappertype = objecttypes[fields[j].getJavaWrapperType()];
                        if (fields[j].getJavaWrapperType() == 10) {
                            ++dim;
                        }
                        if (fields[j].getJavaWrapperType() == 3) {
                            try {
                                fType = Datatype.create(wrappertype);
                                Constraint[] constraints = new Constraint[]{Constraint.create(1, new String[]{"1"}, true), Constraint.create(2, new String[]{"1"}, true)};
                                ((WmString)fType).setConstraints(constraints);
                            }
                            catch (NSException nse) {
                                nse.printStackTrace();
                            }
                        } else if (!wrappertype.equals("anyType")) {
                            fType = DatatypeFactory.createReference(fields[j].getNamespace(), QName.create("http://www.w3.org/2001/XMLSchema", wrappertype), fields[j].getNSName());
                        }
                    }
                    ep = this.mapField(cType, fieldName, typeQName, fType, uri, parentTypeName, true, isTopLevel, dim, isFormQualified, isGlobal, isOptional);
                    break;
                }
            }
            if (ep == null) continue;
            XSElement e = ep.getElementDeclaration();
            e.setNillable(isNillable);
            if (isOptional) {
                ep.setMinOccurs(0);
            }
            if (xsq == null) continue;
            xsq.addParticle(ep);
        }
        if (!isClosed) {
            if (this._useSoapRPCStyle) {
                if (!isTopLevel) {
                    this._context.addWarning(new LocalizedMessage(MapperExceptionBundle.class, MapperExceptionBundle.RPC_RECORD_NO_OPEN, null, recName));
                }
            } else {
                if (xsq != null) {
                    XSAny anyelement = XSComponentFactory.createAny(XSComponentFactory.createWildcard());
                    XSElementParticle anyEp = XSComponentFactory.createElementParticle(anyelement);
                    xsq.addParticle(anyEp);
                }
                XSAnyAttribute anyAttr = XSComponentFactory.createAnyAttribute(XSComponentFactory.createWildcard());
                cType.addAttributeDeclaration(anyAttr);
            }
        }
        return cType;
    }

    private XSElementParticle mapDocType(NSRecord docType, String fieldName, QName typeName, NSName nsName, Name uri, int dim, QName parentTypeName, boolean isClosed, boolean isRef, boolean isTopLevel, boolean isFormQualified, boolean isGlobal) throws XSDMapperException {
        QName tagQName = null;
        QName arrayQName = null;
        int maxOccur = 1;
        XSTypeDefinition typeDef = null;
        XSComplexType complexType = null;
        XSContentType contType = null;
        XSTag element = null;
        XSElementParticle ep = null;
        try {
            String uriStr = uri != null ? uri.toString() : null;
            tagQName = QNameComposer.compose(fieldName, uriStr, this._useSoapRPCStyle);
        }
        catch (LocalizedException e) {
            throw new XSDMapperException(e.getLocalizedMessage());
        }
        if (isRef) {
            QName gTypeQName = this._context.getComplexTypeQName(nsName, 0);
            if (gTypeQName == null) {
                complexType = XSComponentFactory.createComplexType(typeName);
                this._context.addGlobleTypesToSchema(typeName, complexType);
                this._context.addComplexTypeQName(nsName, typeName, 0);
                typeDef = XSComponentFactory.createTypeREF(typeName);
                this.addImportToTargetSchema(parentTypeName, typeName);
            } else {
                typeDef = XSComponentFactory.createTypeREF(gTypeQName);
                this.addImportToTargetSchema(parentTypeName, gTypeQName);
                typeName = gTypeQName;
            }
        } else if (this._useSoapRPCStyle) {
            QName gTypeName = this._context.getComplexTypeQName(typeName, 0);
            if (gTypeName == null) {
                complexType = XSComponentFactory.createComplexType(typeName);
                this._context.addGlobleTypesToSchema(typeName, complexType);
                this._context.addComplexTypeQName(typeName, typeName, 0);
            }
            typeDef = XSComponentFactory.createTypeREF(typeName);
            this.addImportToTargetSchema(parentTypeName, typeName);
        } else {
            complexType = XSComponentFactory.createComplexType(null);
            typeDef = complexType;
        }
        if (complexType != null) {
            String tns = isRef ? typeName.getNamespace() : tagQName.getNamespace();
            this._context._currentSchema.push(this._context.getSchema(tns));
            QName computedParent = parentTypeName;
            if (typeName != null) {
                computedParent = typeName;
            } else if (tagQName.getNamespaceName() != null) {
                computedParent = tagQName;
            }
            contType = this.mapFields(docType.getFields(), fieldName, computedParent, isClosed, false, dim);
            complexType.setContentType(contType);
            this._context._currentSchema.pop();
        }
        if (dim == 1 && !this._useSoapRPCStyle) {
            maxOccur = -1;
        }
        if (dim > 1 && !this._useSoapRPCStyle) {
            throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.CANNOT_CONVERT_TABLE_TO_XSD, null, fieldName);
        }
        if (dim >= 1 && this._useSoapRPCStyle) {
            QName soapTypeQName = null;
            if (nsName != null) {
                soapTypeQName = this._context.getComplexTypeQName(nsName, dim);
            }
            if (soapTypeQName == null) {
                soapTypeQName = this._context.getComplexTypeQName(typeName, dim);
            }
            if (soapTypeQName != null) {
                typeDef = XSComponentFactory.createTypeREF(soapTypeQName);
                this.addImportToTargetSchema(parentTypeName, soapTypeQName);
            } else {
                typeDef = this.getSoapArrayComplexType(dim, typeName, false);
                arrayQName = typeDef.getQName();
                this._context.addComplexTypeQName(typeName, arrayQName, dim);
                this.addImportToTargetSchema(parentTypeName, arrayQName);
            }
        }
        if (this._useGlobalDeclForToplevlField && isTopLevel && (this._useSoapRPCStyle || tagQName.getNamespaceName() == null)) {
            XSElement elem = XSComponentFactory.createElementDECl(1, tagQName);
            elem.setTypeDefinition(typeDef);
            this._context.addGlobleElementToSchema(tagQName, elem);
        }
        element = this.handleQNameTag(typeDef, tagQName, parentTypeName, false, isFormQualified, isGlobal);
        ep = XSComponentFactory.createElementParticle((XSElement)element);
        ep.setMaxOccurs(maxOccur);
        return ep;
    }

    private XSElementParticle mapField(XSContentType cType, String fieldName, QName typeName, ContentType fType, Name uri, QName parentTypeName, boolean isObject, boolean isTopLevel, int dim, boolean isFormQualified, boolean isGlobal, boolean isOptional) throws XSDMapperException {
        QName qNameTag;
        XSTypeDefinition type = null;
        XSElementParticle ep = null;
        QName arrayQName = null;
        XSTag component = null;
        int maxOccur = 1;
        String uriStr = uri != null ? uri.toString() : null;
        Field_QName_Tag fqt = new Field_QName_Tag(this._useSoapRPCStyle, fieldName, uriStr);
        if (dim == 1 && !this._useSoapRPCStyle) {
            maxOccur = -1;
        }
        type = this.findSimpleType(fType, fqt, typeName, parentTypeName, isObject, cType);
        if (fqt.isStarBody()) {
            if (cType.isComplexContent()) {
                ((XSComplexContent)cType).setMixed(true);
            }
            return null;
        }
        if (dim >= 1 && this._useSoapRPCStyle) {
            QName stQName = type.getQName();
            arrayQName = this._context.getSimpleTypeArrayQName(stQName, dim);
            if (arrayQName == null) {
                type = this.getSoapArrayComplexType(dim, stQName, true);
                arrayQName = type.getQName();
            } else {
                type = XSComponentFactory.createTypeREF(arrayQName);
            }
            this.addImportToTargetSchema(parentTypeName, arrayQName);
        }
        if (dim > 1 && !this._useSoapRPCStyle) {
            throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.CANNOT_CONVERT_TABLE_TO_XSD, null, fieldName);
        }
        if (this._useGlobalDeclForToplevlField && isTopLevel && (qNameTag = fqt.getQNameTag()).getNamespaceName() == null && fqt.isElement()) {
            XSElement elem = XSComponentFactory.createElementDECl(1, qNameTag);
            elem.setTypeDefinition(type);
            this._context.addGlobleElementToSchema(qNameTag, elem);
        }
        component = this.handleQNameTag(type, fqt.getQNameTag(), parentTypeName, fqt.isAttrubute(), isFormQualified, isGlobal);
        if (fqt.isElement()) {
            ep = XSComponentFactory.createElementParticle((XSElement)component);
            ep.setMaxOccurs(maxOccur);
        }
        if (fqt.isAttrubute()) {
            if (!isOptional) {
                ((XSAttribute)component).setRequired(true);
            }
            cType.addAttributeDeclaration((XSAttribute)component);
        }
        return ep;
    }

    private XSTypeDefinition findSimpleType(ContentType fType, Field_QName_Tag fqt, QName nominatedTypeName, QName parentTypeName, boolean isObject, XSContentType pType) throws XSDMapperException {
        XSTypeDefinition typeDef = null;
        QName stQName = null;
        SimpleType st = null;
        XSSimpleType globalType = null;
        if (fType == null) {
            if (isObject) {
                if (fqt.isAttrubute()) {
                    typeDef = XSComponentFactory.createTypeREF(REC_ANY_SIMPLETYPE);
                } else if (fqt.isElement()) {
                    typeDef = XSComponentFactory.createTypeREF(REC_ANY_TYPE);
                }
            } else {
                typeDef = XSComponentFactory.createTypeREF(REC_STRING);
            }
        } else {
            st = (SimpleType)fType;
            stQName = st.getQName();
            if (stQName != null && BuiltInSimpleTypes.isBuiltIn(stQName)) {
                stQName = BuiltInSimpleTypes.map(stQName);
                typeDef = XSComponentFactory.createTypeREF(stQName);
            } else {
                if (!st.isProxy()) {
                    if (this._useSoapRPCStyle) {
                        if (fqt.isStarBody() && pType instanceof XSSimpleContent && ((XSSimpleContent)pType).willHaveAttributes()) {
                            st = ((XSSimpleContent)pType).getSimpleType().getSimpleType();
                            String baseName = st.getName();
                            SimpleType stc = (SimpleType)st.deepClone();
                            st.setName(nominatedTypeName.getNCName());
                            ((XSSimpleContent)pType).getSimpleType().setName(nominatedTypeName);
                            try {
                                st.setConstraints(new Constraint[0]);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            globalType = XSComponentFactory.createSimpleType(nominatedTypeName, stc);
                        } else {
                            globalType = XSComponentFactory.createSimpleType(nominatedTypeName, st);
                        }
                        this._context.addGlobleTypesToSchema(nominatedTypeName, globalType);
                        typeDef = XSComponentFactory.createTypeREF(nominatedTypeName);
                        this.addImportToTargetSchema(parentTypeName, nominatedTypeName);
                    } else if (pType instanceof XSSimpleContent && ((XSSimpleContent)pType).willHaveAttributes()) {
                        String newBaseName;
                        st = ((XSSimpleContent)pType).getSimpleType().getSimpleType();
                        String baseName = st.getName();
                        if (!baseName.equals(newBaseName = this._context.getUniqueName(baseName))) {
                            st.setName(newBaseName);
                            if (fqt.isStarBody()) {
                                ((XSSimpleContent)pType).getSimpleType().setName(QName.create(null, newBaseName));
                            }
                        }
                        nominatedTypeName = QName.create(null, newBaseName);
                        SimpleType stc = (SimpleType)st.deepClone();
                        try {
                            st.setConstraints(new Constraint[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        globalType = XSComponentFactory.createSimpleType(nominatedTypeName, stc);
                        this._context.addGlobleTypesToSchema(nominatedTypeName, globalType);
                        typeDef = XSComponentFactory.createTypeREF(nominatedTypeName);
                        this.addImportToTargetSchema(parentTypeName, nominatedTypeName);
                    } else {
                        typeDef = XSComponentFactory.createSimpleType(null, st);
                    }
                } else {
                    String version = st.getVersion();
                    if ((st = version.equals("dtVersion2") ? ((DatatypeRef)st).getTargetType() : ((com.wm.lang.schema.datatype.DatatypeRef)st).getTargetType()) == null) {
                        throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.TARGET_TYPE_NOT_FOUND, null, stQName.toDisplayString());
                    }
                    if (stQName.getNamespaceName() == null && nominatedTypeName != null) {
                        this._context.putSimpleTypeQName(stQName, nominatedTypeName);
                        stQName = nominatedTypeName;
                    }
                    globalType = XSComponentFactory.createSimpleType(stQName, st);
                    this._context.addGlobleTypesToSchema(stQName, globalType);
                    typeDef = XSComponentFactory.createTypeREF(stQName);
                    this.addImportToTargetSchema(parentTypeName, stQName);
                }
                if (st.isUnionType()) {
                    this.mapDependencies(st, parentTypeName);
                }
            }
        }
        return typeDef;
    }

    private void mapDependencies(SimpleType st, QName parentTypeName) throws XSDMapperException {
        XSNonTerminal node = (XSNonTerminal)((Object)st);
        if (!(node instanceof WmUnion)) {
            XSNode[] edges = node.edges();
            for (int i = 0; i < edges.length; ++i) {
                if (!(edges[i] instanceof SimpleType)) continue;
                if (edges[i].isTerminal()) {
                    this.mapDependency((SimpleType)((Object)edges[i]), parentTypeName);
                    continue;
                }
                this.mapDependencies((SimpleType)((Object)edges[i]), parentTypeName);
            }
        } else {
            Datatype[] mt = ((WmUnion)node).getMemberTypes();
            for (int nom = 0; nom < mt.length; ++nom) {
                this.mapDependency(mt[nom], st.getQName());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapDependency(SimpleType st, QName parentTypeName) throws XSDMapperException {
        SimpleType target;
        String version = st.getVersion();
        QName targetQName = st.getQName();
        if (BuiltInSimpleTypes.isBuiltIn(targetQName)) {
            return;
        }
        if (version.equals("dtVersion2")) {
            if (!(st instanceof DatatypeRef)) return;
            target = ((DatatypeRef)st).getTargetType();
        } else {
            if (!(st instanceof com.wm.lang.schema.datatype.DatatypeRef)) return;
            target = ((com.wm.lang.schema.datatype.DatatypeRef)st).getTargetType();
        }
        if (target.isUnionType()) {
            this.mapDependencies(target, parentTypeName);
        }
        if (target == null) {
            throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.TARGET_TYPE_NOT_FOUND, null, targetQName.toDisplayString());
        }
        XSSimpleType globalSimpleType = XSComponentFactory.createSimpleType(targetQName, target);
        this._context.addGlobleTypesToSchema(targetQName, globalSimpleType);
        this.addImportToTargetSchema(parentTypeName, targetQName);
    }

    private XSTypeReference getSoapArrayComplexType(int dim, QName typeName, boolean isSimple) {
        String localName = Strings.cat(dim > 1 ? "TableOf" : "ArrayOf", typeName.getNCName());
        Name nsName = typeName.getNamespaceName();
        String ns = this._aURIString;
        if (!this._context.isFromW3CSchemaNS(nsName)) {
            ns = typeName.getNamespace();
        }
        QName soapTypeName = TypeName.create2(ns, localName, this._context._typeNames, this._context._duplicatesResolved);
        if (isSimple) {
            this._context.setSimpleTypeArrayQName(typeName, soapTypeName, dim);
        } else {
            this._context.addComplexTypeQName(typeName, soapTypeName, dim);
        }
        XSSchema schema = this._context.getSchema(ns);
        XSTypeReference typeRef = null;
        typeRef = XSComponentFactory.createTypeREF(soapTypeName);
        if (schema.containsTypeDefinition(soapTypeName)) {
            return typeRef;
        }
        XSComplexType cType = XSComponentFactory.createComplexType(soapTypeName);
        this._context.addGlobleTypesToSchema(soapTypeName, cType);
        cType.setBaseTypeName(SOAP_ARRAY);
        cType.setIsSoapArrayType(true);
        XSSequence xsq = XSComponentFactory.createSequence();
        XSComplexContent contentType = XSComponentFactory.createComplexContent(xsq);
        cType.setContentType(contentType);
        XSAttributeReference attr = XSComponentFactory.createAttributeREF(SOAP_ARRAY_TYPE);
        QName arryTypeValue = this.getSoapAttrDefaultValue(dim, typeName);
        attr.setArrayTypeValue(arryTypeValue);
        XSImport importc = XSComponentFactory.createImport(Name.create("http://schemas.xmlsoap.org/soap/encoding/"));
        schema.addImport(importc);
        contentType.addAttributeDeclaration(attr);
        return typeRef;
    }

    private QName getSoapAttrDefaultValue(int dim, QName typeName) {
        String ns = typeName.getNamespace();
        String localName = typeName.getNCName();
        int len = dim + 1;
        char[] src = new char[len];
        src[0] = 91;
        for (int i = 1; i < src.length - 1; ++i) {
            src[i] = 44;
        }
        src[src.length - 1] = 93;
        String bracket = new String(src);
        localName = Strings.cat(localName, bracket);
        return QName.create(ns, localName);
    }

    private XSTag handleQNameTag(XSTypeDefinition type, QName qNameTag, QName parentTypeName, boolean isAttr, boolean isFormQualified, boolean isGlobal) {
        if (qNameTag.getNamespaceName() == null) {
            if (isAttr) {
                XSAttribute attr = XSComponentFactory.createAttributeDECL(1, qNameTag);
                attr.setTypeDefinition(type);
                return attr;
            }
            if (isFormQualified && !isGlobal) {
                XSElement elem = XSComponentFactory.createElementDECl(1, qNameTag);
                elem.setTypeDefinition(type);
                elem.setFormQualified(isFormQualified);
                return elem;
            }
            if (!isFormQualified && isGlobal) {
                XSElement globalElem = XSComponentFactory.createElementDECl(0, qNameTag);
                globalElem.setTypeDefinition(type);
                this._context.addGlobleElementToSchema(qNameTag, globalElem);
                this.addImportToTargetSchema(qNameTag, type.getQName());
                XSElementReference globalElemRef = XSComponentFactory.createElementREF(qNameTag);
                this.addImportToTargetSchema(parentTypeName, qNameTag);
                return globalElemRef;
            }
            XSElement elem = XSComponentFactory.createElementDECl(1, qNameTag);
            elem.setTypeDefinition(type);
            return elem;
        }
        Name namespace = qNameTag.getNamespaceName();
        this.addImport(namespace);
        if (isAttr) {
            XSAttribute globalAttr = XSComponentFactory.createAttributeDECL(0, qNameTag);
            globalAttr.setTypeDefinition(type);
            this._context.addGlobleAttrToSchema(qNameTag, globalAttr);
            this.addImportToTargetSchema(qNameTag, type.getQName());
            XSAttributeReference attrRef = XSComponentFactory.createAttributeREF(qNameTag);
            this.addImportToTargetSchema(parentTypeName, qNameTag);
            return attrRef;
        }
        if (isFormQualified && !isGlobal) {
            XSElement elem = XSComponentFactory.createElementDECl(1, qNameTag);
            elem.setTypeDefinition(type);
            elem.setFormQualified(isFormQualified);
            return elem;
        }
        XSElement globalElem = XSComponentFactory.createElementDECl(0, qNameTag);
        globalElem.setTypeDefinition(type);
        this._context.addGlobleElementToSchema(qNameTag, globalElem);
        this.addImportToTargetSchema(qNameTag, type.getQName());
        XSElementReference globalElemRef = XSComponentFactory.createElementREF(qNameTag);
        this.addImportToTargetSchema(parentTypeName, qNameTag);
        return globalElemRef;
    }

    private IResult addError(XSDMapperException e) {
        this._context.addError(e);
        return new MapResult(this._context);
    }

    private void addImport(Name namespace) {
        if (this._context.getCurrentSchemaNS() != namespace) {
            XSImport impor = XSComponentFactory.createImport(namespace);
            if (this._useSchemaLocation) {
                String fileName = "no-tns.xsd";
                if (namespace != null) {
                    if (!this._context._namespaces.contains(namespace)) {
                        this._context._namespaces.put(namespace, MapperContext.DEFAULT_PREFIX);
                    }
                    Name prefix = this._context._namespaces.getPrefix(namespace);
                    fileName = Strings.cat(prefix.toString(), ".xsd");
                }
                impor.setSchemaLocation(fileName);
            }
            this._context.addImportToCurrentSchema(impor);
        }
    }

    private void addImportToTargetSchema(QName qNameTag, QName typeQName) {
        if (typeQName == null || qNameTag == null) {
            return;
        }
        Name namespace = typeQName.getNamespaceName();
        if (this._context.isFromW3CSchemaNS(namespace)) {
            return;
        }
        if (namespace != qNameTag.getNamespaceName()) {
            XSSchema schema = this._context.getSchema(qNameTag.getNamespace());
            XSImport impor = XSComponentFactory.createImport(namespace);
            if (this._useSchemaLocation) {
                String fileName = "no-tns.xsd";
                if (namespace != null) {
                    if (!this._context._namespaces.contains(namespace)) {
                        this._context._namespaces.put(namespace, MapperContext.DEFAULT_PREFIX);
                    }
                    Name prefix = this._context._namespaces.getPrefix(namespace);
                    fileName = Strings.cat(prefix.toString(), ".xsd");
                }
                impor.setSchemaLocation(fileName);
            }
            schema.addImport(impor);
        }
    }
}

