/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.mapper;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.util.LocalizedMessage;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.xsd.component.Namespaces;
import com.wm.xsd.component.XSAttribute;
import com.wm.xsd.component.XSComponentFactory;
import com.wm.xsd.component.XSElement;
import com.wm.xsd.component.XSImport;
import com.wm.xsd.component.XSSchema;
import com.wm.xsd.component.XSTypeDefinition;
import com.wm.xsd.mapper.IResult;
import com.wm.xsd.mapper.MapperConstants;
import com.wm.xsd.mapper.XSDMapperException;
import com.wm.xsd.mapper.resources.MapperExceptionBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

class MapperContext
implements MapperConstants {
    static final Name DEFAULT_PREFIX = Name.create("dx");
    private HashMap _xsSchemas = new HashMap(4);
    private Hashtable _nsRecordQName = new Hashtable(5);
    private Hashtable _simpleTypeArrayQNames = new Hashtable(5);
    private Hashtable _simpleTypeQNames;
    private static final HashSet _W3CSchemaNS = new HashSet(4);
    private Hashtable _schemaURLs;
    Stack _currentSchema = new Stack();
    HashSet _typeNames = new HashSet(6);
    Vector _errors = null;
    Vector _warnings = null;
    Namespaces _namespaces;
    List _typeNamesForInputDocumentTypes;
    HashMap<String, Integer> _customizedNames = null;
    HashMap<QName, QName> _duplicatesResolved;
    public static final String WARNING_MSG = "warningMessage";
    public static final String ERROR_MSG = "errorMessage";

    MapperContext() {
        this._schemaURLs = new Hashtable(5);
        this._namespaces = XSComponentFactory.createNamespaces();
        _W3CSchemaNS.add(SCHEMA_REC_10_NAME);
        _W3CSchemaNS.add(SCHEMA_10_2000_NAME);
        _W3CSchemaNS.add(SCHEMA_08_2000_NAME);
        _W3CSchemaNS.add(SCHEMA_1999_NAME);
        this._typeNamesForInputDocumentTypes = new ArrayList();
        this._simpleTypeQNames = new Hashtable(11);
        this._duplicatesResolved = new HashMap();
    }

    static MapperContext create() {
        return new MapperContext();
    }

    XSSchema getSchema(String targetNS) {
        XSSchema schema = (XSSchema)this._xsSchemas.get(targetNS);
        if (schema == null) {
            String fileName = "no-tns.xsd";
            Name namespace = null;
            if (targetNS != null) {
                namespace = Name.create(targetNS);
                if (!this._namespaces.contains(namespace)) {
                    this._namespaces.put(namespace, DEFAULT_PREFIX);
                }
                Name prefix = this._namespaces.getPrefix(namespace);
                fileName = Strings.cat(prefix.toString(), ".xsd");
            }
            schema = XSComponentFactory.createSchema(targetNS);
            this.addSchemaURL(targetNS, fileName);
            this._xsSchemas.put(targetNS, schema);
        }
        return schema;
    }

    void addGlobleElementToSchema(QName qName, XSElement element) {
        XSSchema schema = this.getSchema(qName.getNamespace());
        schema.addElementDeclaration(element);
    }

    void addGlobleAttrToSchema(QName qName, XSAttribute attr) {
        XSSchema schema = this.getSchema(qName.getNamespace());
        schema.addAttributeDeclaration(attr);
    }

    void addGlobleTypesToSchema(QName typeName, XSTypeDefinition type) {
        XSSchema schema = this.getSchema(typeName.getNamespace());
        schema.addTypeDefinition(type);
    }

    QName getComplexTypeQName(Object id, int dim) {
        if (this._nsRecordQName.containsKey(id)) {
            QName[] qNameArray = (QName[])this._nsRecordQName.get(id);
            return qNameArray[dim];
        }
        return null;
    }

    void addComplexTypeQName(Object id, QName typeName, int dim) {
        QName[] qNameArray = null;
        if (dim >= 2) {
            return;
        }
        if (!this._nsRecordQName.containsKey(id)) {
            qNameArray = new QName[2];
            qNameArray[dim] = typeName;
            this._nsRecordQName.put(id, qNameArray);
        } else {
            qNameArray = (QName[])this._nsRecordQName.get(id);
            if (qNameArray[dim] == null) {
                qNameArray[dim] = typeName;
            }
        }
    }

    QName getSimpleTypeArrayQName(QName stQName, int dim) {
        QName[] qArray = null;
        if (dim > 2 || dim < 1) {
            return null;
        }
        if (this._simpleTypeArrayQNames.containsKey(stQName) && (qArray = (QName[])this._simpleTypeArrayQNames.get(stQName)) != null) {
            return qArray[dim - 1];
        }
        return null;
    }

    void setSimpleTypeArrayQName(QName stQName, QName arrayQName, int dim) {
        QName[] qArray = null;
        if (dim > 2 || dim < 1) {
            return;
        }
        qArray = this._simpleTypeArrayQNames.containsKey(stQName) ? (QName[])this._simpleTypeArrayQNames.get(stQName) : new QName[2];
        if (qArray[dim - 1] == null) {
            qArray[dim - 1] = arrayQName;
        }
        this._simpleTypeArrayQNames.put(stQName, qArray);
    }

    IData createWarning(LocalizedMessage msg) {
        IData warning = IDataFactory.create();
        IDataCursor idc = warning.getCursor();
        IDataUtil.put(idc, WARNING_MSG, msg.getLocalizedMessage(Locale.getDefault()));
        idc.destroy();
        return warning;
    }

    IData createError(LocalizedMessage msg) {
        IData error = IDataFactory.create();
        IDataCursor idc = error.getCursor();
        IDataUtil.put(idc, ERROR_MSG, msg.getLocalizedMessage(Locale.getDefault()));
        idc.destroy();
        return error;
    }

    void addError(XSDMapperException e) {
        if (this._errors == null) {
            this._errors = new Vector();
        }
        this._errors.addElement(e);
    }

    void addWarning(LocalizedMessage msg) {
        if (this._warnings == null) {
            this._warnings = new Vector();
        }
        this._warnings.add(this.createWarning(msg));
    }

    void addNamespace(Name uri, String prefix, String fieldName) throws XSDMapperException {
        if (this._namespaces.contains(uri)) {
            return;
        }
        if (prefix.startsWith("@")) {
            prefix = prefix.substring(1);
        }
        if (!NCName.validate(prefix)) {
            throw new XSDMapperException(MapperExceptionBundle.class, MapperExceptionBundle.INVALID_NC_NAME_PRFX, null, new String[]{prefix, fieldName});
        }
        this._namespaces.put(uri, Name.create(prefix));
    }

    void addImportToCurrentSchema(XSImport impor) {
        XSSchema cs;
        if (impor == null) {
            return;
        }
        if (!this._currentSchema.isEmpty() && !(cs = (XSSchema)this._currentSchema.peek()).containsImport(impor.getNamespace())) {
            cs.addImport(impor);
        }
    }

    XSSchema getCurrentSchema() {
        if (!this._currentSchema.isEmpty()) {
            return (XSSchema)this._currentSchema.peek();
        }
        return null;
    }

    Name getCurrentSchemaNS() {
        XSSchema schema = this.getCurrentSchema();
        if (schema != null) {
            String tns = schema.getTargetNamespace();
            if (tns == null) {
                return null;
            }
            return Name.create(tns);
        }
        return null;
    }

    XSSchema[] getSchemata() {
        Iterator enumvar = this._xsSchemas.values().iterator();
        XSSchema[] oa = new XSSchema[this._xsSchemas.size()];
        int i = 0;
        while (enumvar.hasNext()) {
            oa[i] = (XSSchema)enumvar.next();
            ++i;
        }
        return oa;
    }

    Namespaces getNamespaces() {
        return this._namespaces;
    }

    boolean isFromW3CSchemaNS(Name namespace) {
        return _W3CSchemaNS.contains(namespace);
    }

    Hashtable getSchemaURLs() {
        return this._schemaURLs;
    }

    void addSchemaURL(String tns, String url) {
        Object targetNS = tns == null ? IResult.NULL : tns;
        if (!this._schemaURLs.containsKey(targetNS)) {
            this._schemaURLs.put(targetNS, url);
        }
    }

    void addTypeNameForInputDocumentType(QName name) {
        this._typeNamesForInputDocumentTypes.add(name);
    }

    QName[] getTypeNamesForInputDocumentTypes() {
        QName[] typeNames = new QName[this._typeNamesForInputDocumentTypes.size()];
        this._typeNamesForInputDocumentTypes.toArray(typeNames);
        return typeNames;
    }

    QName getSimpleTypeQName(QName name) {
        return (QName)this._simpleTypeQNames.get(name);
    }

    void putSimpleTypeQName(QName name, QName generatedName) {
        this._simpleTypeQNames.put(name, generatedName);
    }

    void removeBogusSchemata() {
        XSSchema[] schemata = this.getSchemata();
        for (int i = 0; i < schemata.length; ++i) {
            if (!schemata[i].isEmpty()) continue;
            this._xsSchemas.remove(schemata[i].getTargetNamespace());
        }
    }

    void removeWrapperComplexTypesForInputDocumentTypes() {
        QName[] typeNames = this.getTypeNamesForInputDocumentTypes();
        for (int i = 0; i < typeNames.length; ++i) {
            XSSchema schema = (XSSchema)this._xsSchemas.get(typeNames[i].getNamespace());
            if (schema == null) continue;
            schema.removeTypeDefinition(typeNames[i]);
        }
        this._typeNamesForInputDocumentTypes.clear();
    }

    String getUniqueName(String base) {
        Integer curCount;
        String newName = base;
        int cur = 0;
        if (this._customizedNames == null) {
            this._customizedNames = new HashMap();
        }
        if ((curCount = this._customizedNames.get(base)) != null) {
            cur = curCount + 1;
            newName = newName + "_" + cur;
        }
        this._customizedNames.put(base, new Integer(cur));
        return newName;
    }
}

