/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.encoding;

import com.wm.util.QName;
import com.wm.xsd.coder.BaseComponentCoder;
import com.wm.xsd.coder.IComponentCoder;
import com.wm.xsd.coder.IContext;
import com.wm.xsd.coder.ITags;
import com.wm.xsd.component.XSElement;
import com.wm.xsd.component.XSElementParticle;
import com.wm.xsd.component.XSTypeDefinition;

public class ElementCoder
extends BaseComponentCoder
implements IComponentCoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITags createStartTags(Object component, IContext context) {
        StringBuffer buf;
        ITags tags = this.getTags(context);
        XSElement elem = (XSElement)component;
        Object preComp = context.previousComponent();
        boolean nillable = elem.isNillable();
        XSTypeDefinition type = elem.getTypeDefinition();
        QName typeQName = type != null ? type.getQName() : null;
        boolean isFormQualified = elem.isFormQualified();
        StringBuffer stringBuffer = buf = new StringBuffer();
        synchronized (stringBuffer) {
            buf.append('<');
            buf.append("xsd:element");
            QName elemQName = elem.getQName();
            String elemName = elem.getScope() == 0 || isFormQualified ? elemQName.getNCName() : this.composeQName(elemQName, context);
            buf.append(this.composeAttribute("name", elemName));
            if (nillable) {
                buf.append(this.composeAttribute("nillable", "true"));
            }
            if (isFormQualified) {
                buf.append(this.composeAttribute("form", "qualified"));
            }
            if (typeQName != null) {
                buf.append(this.composeAttribute("type", this.composeQName(typeQName, context)));
            }
            if (preComp.getClass() == XSElementParticle.class) {
                String maxOccurStr = "unbounded";
                int minOccurs = ((XSElementParticle)preComp).getMinOccurs();
                int maxOccurs = ((XSElementParticle)preComp).getMaxOccurs();
                if (maxOccurs != -1) {
                    maxOccurStr = String.valueOf(maxOccurs);
                }
                if (minOccurs != 1) {
                    buf.append(this.composeAttribute("minOccurs", String.valueOf(minOccurs)));
                }
                if (maxOccurs != 1) {
                    buf.append(this.composeAttribute("maxOccurs", maxOccurStr));
                }
            }
            if (typeQName != null) {
                buf.append("/>");
            } else {
                buf.append('>');
            }
        }
        tags.add(buf.toString());
        if (typeQName != null) {
            tags.setEmptyTag(true);
        }
        return tags;
    }

    public ITags createEndTags(Object component, IContext context) {
        ITags tags = this.getTags(context);
        tags.add(this.composeEndTag("xsd:element"));
        return tags;
    }
}

