/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.encoding;

import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.xsd.coder.BaseComponentCoder;
import com.wm.xsd.coder.IComponentCoder;
import com.wm.xsd.coder.IContext;
import com.wm.xsd.coder.ITags;
import com.wm.xsd.component.XSAttribute;
import com.wm.xsd.component.XSComplexContent;
import com.wm.xsd.component.XSComplexType;
import com.wm.xsd.component.XSContentType;
import com.wm.xsd.component.XSSimpleContent;
import com.wm.xsd.component.XSSimpleType;
import com.wm.xsd.util.SimpleTypeHelper;
import java.util.Stack;

public class ComplexTypeCoder
extends BaseComponentCoder
implements IComponentCoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITags createStartTags(Object component, IContext context) {
        StringBuffer buf;
        ITags tags = this.getTags(context);
        XSComplexType cType = (XSComplexType)component;
        XSContentType content = cType.getContentType();
        QName baseTypeName = cType.getBaseTypeName();
        boolean hasComplexContent = content.isComplexContent();
        StringBuffer stringBuffer = buf = new StringBuffer();
        synchronized (stringBuffer) {
            XSComplexContent complexCont;
            buf.append('<');
            buf.append("xsd:complexType");
            QName typeQName = cType.getQName();
            if (typeQName != null) {
                buf.append(this.composeAttribute("name", typeQName.getNCName()));
            }
            if (hasComplexContent && (complexCont = (XSComplexContent)content).isMixed()) {
                buf.append(this.composeAttribute("mixed", "true"));
            }
            buf.append('>');
        }
        tags.add(buf.toString());
        if (hasComplexContent && cType.isSoapArrayType()) {
            tags.add("<xsd:complexContent>");
            String rst = Strings.cat("<xsd:restriction", this.composeAttribute("base", this.composeQName(baseTypeName, context)), ">");
            tags.add(rst);
        }
        if (!hasComplexContent) {
            tags.add("<xsd:simpleContent>");
            XSSimpleContent simpleCont = (XSSimpleContent)content;
            XSAttribute[] attrs = simpleCont.getAttributeDeclarations();
            XSSimpleType xstype = simpleCont.getSimpleType();
            QName baseTypeQName = xstype.getQName();
            if (baseTypeQName == null) {
                baseTypeQName = SimpleTypeHelper.getBaseTypeQName(xstype.getSimpleType());
            }
            String baseName = this.composeQName(baseTypeQName, context);
            if (attrs.length > 0) {
                String ext = Strings.cat("<xsd:extension", this.composeAttribute("base", baseName), ">");
                tags.add(ext);
                context.getIsExtensionFlags().push(new Boolean(true));
            } else {
                String rst = Strings.cat("<xsd:restriction", this.composeAttribute("base", baseName), ">");
                tags.add(rst);
                context.getIsExtensionFlags().push(new Boolean(false));
            }
        }
        return tags;
    }

    public ITags createEndTags(Object component, IContext context) {
        ITags tags = this.getTags(context);
        XSComplexType cType = (XSComplexType)component;
        XSContentType content = cType.getContentType();
        if (!content.isComplexContent()) {
            if (content.getAttributeDeclarations().length > 0) {
                tags.add(this.composeEndTag("xsd:extension"));
            } else {
                tags.add(this.composeEndTag("xsd:restriction"));
            }
            tags.add(this.composeEndTag("xsd:simpleContent"));
            Stack flags = context.getIsExtensionFlags();
            if (!flags.isEmpty()) {
                flags.pop();
            }
        } else if (cType.isSoapArrayType()) {
            tags.add(this.composeEndTag("xsd:restriction"));
            tags.add("</xsd:complexContent>");
        }
        tags.add(this.composeEndTag("xsd:complexType"));
        return tags;
    }
}

