/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.component;

import com.wm.util.Name;
import com.wm.xsd.component.XSComponentFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespaces
implements Cloneable {
    private List _prefixes = new ArrayList();
    private Map _uriPrefixPairs = new HashMap();
    private static final Name DEFAULT_PREFIX = Name.create("ns");
    private static final Name XML = Name.create("xml");
    private static final Name XSD = Name.create("xsd");
    private static final Name XML_NAMESPACE = Name.create("http://www.w3.org/XML/1998/namespace");
    private static final Name XML_SCHEMA_NAMESPACE = Name.create("http://www.w3.org/2001/XMLSchema");

    Namespaces() {
        this.put(XML_NAMESPACE, XML);
        this.put(XML_SCHEMA_NAMESPACE, XSD);
    }

    public boolean contains(Name uri) {
        return this._uriPrefixPairs.containsKey(uri);
    }

    public Name put(Name uri, Name prefix) {
        if (uri == null) {
            return null;
        }
        if (this._uriPrefixPairs.containsKey(uri)) {
            return (Name)this._uriPrefixPairs.get(uri);
        }
        Name candidatePrefix = prefix;
        if (candidatePrefix == null) {
            candidatePrefix = DEFAULT_PREFIX;
        }
        Name givenPrefix = candidatePrefix;
        if (this._prefixes.contains(candidatePrefix)) {
            int suffix = 2;
            candidatePrefix = Name.create(givenPrefix.toString() + suffix);
            while (this._prefixes.contains(candidatePrefix)) {
                candidatePrefix = Name.create(givenPrefix.toString() + ++suffix);
            }
        }
        this._prefixes.add(candidatePrefix);
        return this._uriPrefixPairs.put(uri, candidatePrefix);
    }

    public Name getPrefix(Name uri) {
        if (uri == null) {
            return null;
        }
        return (Name)this._uriPrefixPairs.get(uri);
    }

    public Name remove(Name uri) {
        if (uri == null) {
            return null;
        }
        Name prefix = this.getPrefix(uri);
        this._prefixes.remove(prefix);
        return (Name)this._uriPrefixPairs.remove(uri);
    }

    public String toString() {
        return this._uriPrefixPairs.toString();
    }

    public Object clone() {
        Namespaces c = null;
        try {
            c = (Namespaces)super.clone();
            c._prefixes = (List)((ArrayList)this._prefixes).clone();
            c._uriPrefixPairs = (Map)((HashMap)this._uriPrefixPairs).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    public static void main(String[] args) {
        Namespaces ns = XSComponentFactory.createNamespaces();
        Namespaces ns2 = (Namespaces)ns.clone();
        System.out.println(ns2);
    }
}

