/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.coder;

import com.wm.util.EncUtil;
import com.wm.util.EncodingNames;
import com.wm.util.Name;
import com.wm.util.Strings;
import com.wm.xsd.coder.CoderConstants;
import com.wm.xsd.coder.Context;
import com.wm.xsd.coder.EncodingRegistry;
import com.wm.xsd.coder.IComponentCoder;
import com.wm.xsd.coder.ITags;
import com.wm.xsd.coder.IXSDCoder;
import com.wm.xsd.coder.Padder;
import com.wm.xsd.coder.XSDCoderException;
import com.wm.xsd.coder.XSDCoderFactory;
import com.wm.xsd.component.Namespaces;
import com.wm.xsd.component.XSComponentFactory;
import com.wm.xsd.component.XSImport;
import com.wm.xsd.component.XSSchema;
import com.wm.xsd.graph.XSNode;
import com.wm.xsd.graph.XSNonTerminal;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

class XSDCoder
implements IXSDCoder,
CoderConstants {
    private boolean _useXMLDeclaration = false;
    private boolean _useUTF8 = true;
    private boolean _makeItPretty = true;
    private int _initialPadding = 4;
    private String _fileEncoding = EncUtil.getFileEncoding();
    private EncodingRegistry _encodingRegistry;
    private Padder _padder = new Padder(this._makeItPretty);
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    private static final String XML_DECLARATION_OPEN_TAG = "<?xml version=\"1.0\" encoding=\"";
    private static final String XML_DECLARATION_CLOSE_TAG = "\" ?>\n";
    private static final char NEW_LINE = '\n';

    XSDCoder() {
    }

    void setEncodingRegistry(EncodingRegistry registry) {
        this._encodingRegistry = registry;
    }

    public void setUseXMLDeclaration(boolean use) {
        this._useXMLDeclaration = use;
    }

    public void setUseUTF8(boolean use) {
        this._useUTF8 = use;
    }

    public void setMakeItPretty(boolean makeItPretty) {
        if (this._makeItPretty != makeItPretty) {
            this._makeItPretty = makeItPretty;
            this._padder = new Padder(makeItPretty);
        }
    }

    public void setInitialPadding(int initialPadding) {
        this._initialPadding = initialPadding;
    }

    public void encode(OutputStream os, XSSchema[] schemata, Namespaces ns) throws IOException, XSDCoderException {
        Context context = new Context(ns, this._initialPadding);
        Writer writer = this.createWriter(os);
        this.writeXMLDeclaration(writer);
        for (int i = 0; i < schemata.length; ++i) {
            this.encode(writer, (XSNode)schemata[i], context);
            writer.write(10);
        }
        writer.flush();
    }

    public void encode(OutputStream os, XSSchema schema, Namespaces ns) throws IOException, XSDCoderException {
        Context context = new Context(ns, this._initialPadding);
        this.encode(os, schema, context);
    }

    private void encode(OutputStream os, XSSchema schema, Context context) throws IOException, XSDCoderException {
        Writer writer = this.createWriter(os);
        this.writeXMLDeclaration(writer);
        this.encode(writer, (XSNode)schema, context);
        writer.flush();
    }

    private void encode(Writer writer, XSNode node, Context context) throws IOException, XSDCoderException {
        context.pushComponent(node);
        IComponentCoder coder = this._encodingRegistry.getComponentCoder(node.getClass());
        if (coder != null) {
            ITags tags = coder.createStartTags(node, context);
            boolean emptyTag = tags.isEmptyTag();
            if (tags != null) {
                this.writeStartTags(writer, tags, context);
            }
            if (!node.isTerminal()) {
                XSNode[] edges = ((XSNonTerminal)node).edges();
                for (int i = 0; i < edges.length; ++i) {
                    this.encode(writer, edges[i], context);
                }
            }
            if (!emptyTag && (tags = coder.createEndTags(node, context)) != null) {
                this.writeEndTags(writer, tags, context);
            }
        }
        context.popComponent();
    }

    private Writer createWriter(OutputStream os) throws IOException {
        BufferedWriter writer = this._useUTF8 ? new BufferedWriter(new OutputStreamWriter(os, "UTF8")) : new BufferedWriter(new OutputStreamWriter(os, this._fileEncoding));
        return writer;
    }

    private void writeXMLDeclaration(Writer writer) throws IOException {
        if (this._useXMLDeclaration) {
            if (this._useUTF8) {
                writer.write(XML_DECLARATION);
            } else {
                writer.write(Strings.cat(XML_DECLARATION_OPEN_TAG, EncodingNames.getIANAName(this._fileEncoding), XML_DECLARATION_CLOSE_TAG));
            }
        }
    }

    private void writeStartTags(Writer writer, ITags tags, Context context) throws IOException {
        int size = tags.size();
        for (int i = 0; i < size; ++i) {
            writer.write(Strings.cat(this._padder.open(context, tags.isEmptyTag()), tags.get(i)));
        }
    }

    private void writeEndTags(Writer writer, ITags tags, Context context) throws IOException {
        int size = tags.size();
        for (int i = 0; i < size; ++i) {
            writer.write(Strings.cat(this._padder.close(context), tags.get(i)));
        }
    }

    private static void test() {
        XSSchema schema = XSComponentFactory.createSchema("http://www.webmethods.com/");
        XSImport importc = XSComponentFactory.createImport(Name.create("http://www.wallstreet.org/"));
        schema.addImport(importc);
        importc = XSComponentFactory.createImport(Name.create("http://www.oag.org/"));
        schema.addImport(importc);
        XSSchema schema2 = XSComponentFactory.createSchema("http://www.activesw.com/");
        XSImport importc2 = XSComponentFactory.createImport(Name.create("http://www.wallstreet.org/"));
        schema2.addImport(importc2);
        importc2 = XSComponentFactory.createImport(Name.create("http://www.oag.org/"));
        schema2.addImport(importc2);
        Namespaces ns = XSComponentFactory.createNamespaces();
        ns.put(Name.create("http://www.wallstreet.org/"), Name.create("ws"));
        ns.put(Name.create("http://www.oag.org/"), Name.create("oag"));
        XSSchema[] schemata = new XSSchema[]{schema, schema2};
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            IXSDCoder coder = XSDCoderFactory.create(XSDCoderFactory.VERSION_1_0);
            coder.encode((OutputStream)stream, schema, ns);
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            coder.encode((OutputStream)stream2, schemata, ns);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        XSDCoder.test();
    }

    public Namespaces encode2(OutputStream os, XSSchema schema, Namespaces ns) throws IOException, XSDCoderException {
        Context context = new Context(ns, this._initialPadding);
        this.encode(os, schema, context);
        return context.getCachedURIPrefixPairs();
    }
}

