/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.coder;

import com.wm.util.Name;
import com.wm.xsd.coder.CoderConstants;
import com.wm.xsd.coder.ComponentInformation;
import com.wm.xsd.coder.IContext;
import com.wm.xsd.coder.ITags;
import com.wm.xsd.coder.Tags;
import com.wm.xsd.component.Namespaces;
import com.wm.xsd.component.XSComponentFactory;
import java.util.EmptyStackException;
import java.util.Stack;

class Context
implements IContext,
CoderConstants {
    private int _padding;
    private Namespaces _cachedURIPrefixPairs;
    private Namespaces _inScope;
    private Stack _components;
    private Stack _isExtensionFlags;
    private Tags _tags;

    Context(Namespaces givenURIPrefixPairs, int initialPadding) {
        this._padding = initialPadding;
        this._cachedURIPrefixPairs = (Namespaces)givenURIPrefixPairs.clone();
        this._inScope = XSComponentFactory.createNamespaces();
        this._tags = new Tags();
        this._components = new Stack();
        this._isExtensionFlags = new Stack();
    }

    public Stack getIsExtensionFlags() {
        return this._isExtensionFlags;
    }

    int getPadding() {
        return this._padding;
    }

    void incrementPadding() {
        this._padding += 2;
    }

    void decrementPadding() {
        this._padding -= 2;
    }

    void pushComponent(Object component) {
        ComponentInformation componentInfo = new ComponentInformation(component);
        this._components.push(componentInfo);
    }

    Object popComponent() {
        ComponentInformation componentInfo = (ComponentInformation)this._components.pop();
        Name[] uris = componentInfo.getDeclaredNamespaces();
        if (uris != null) {
            for (int i = 0; i < uris.length; ++i) {
                this._inScope.remove(uris[i]);
            }
        }
        return componentInfo.getComponent();
    }

    public Object previousComponent() {
        int size = this._components.size();
        if (size > 1) {
            ComponentInformation ci = (ComponentInformation)this._components.elementAt(size - 2);
            return ci.getComponent();
        }
        return null;
    }

    public Name createXMLPrefix(Name namespace) {
        if (this._cachedURIPrefixPairs.contains(namespace)) {
            return this._cachedURIPrefixPairs.getPrefix(namespace);
        }
        this._cachedURIPrefixPairs.put(namespace, PREFIX_FOR_GENERATED_NAMESPACE_PREFIX);
        return this._cachedURIPrefixPairs.getPrefix(namespace);
    }

    public void addNamespaceDeclToInScope(Name namespace, Name prefix) {
        this._inScope.put(namespace, prefix);
        try {
            ComponentInformation componentInfo = (ComponentInformation)this._components.peek();
            componentInfo.addDeclaredNamespaces(namespace);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void removeNamespaceDeclFromInScope(Name namespace) {
        this._inScope.remove(namespace);
        try {
            ComponentInformation componentInfo = (ComponentInformation)this._components.peek();
            componentInfo.removeDeclaredNamespaces(namespace);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public Name getXMLPrefixFromInScope(Name namespace) {
        return this._inScope.getPrefix(namespace);
    }

    public boolean isNamespaceDeclInScope(Name namespace) {
        return this._inScope.contains(namespace);
    }

    public ITags getTags() {
        return this._tags;
    }

    Namespaces getCachedURIPrefixPairs() {
        return this._cachedURIPrefixPairs;
    }
}

