/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xsd.coder;

import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.xsd.coder.IContext;
import com.wm.xsd.coder.ITags;
import com.wm.xsd.coder.XSDKeys;

public abstract class BaseComponentCoder
implements XSDKeys {
    protected static final char LESS_THAN_CHAR = '<';
    protected static final char GREATER_THAN_CHAR = '>';
    protected static final char SPACE_CHAR = ' ';
    protected static final String LESS_THAN = "<";
    protected static final String CLOSE_LESS_THAN = "</";
    protected static final String GREATER_THAN = ">";
    protected static final String CLOSE_GREATER_THAN = "/>";
    protected static final String SPACE = " ";
    protected static final String EQUALS = "=\"";
    protected static final String QUOTE = "\"";
    protected static final String COLON = ":";
    protected static final String OPEN_NAMESPACE_DECL_COLON = " xmlns:";
    protected static final String NAME = "name";
    protected static final String MIXED = "mixed";
    protected static final String TRUE = "true";
    protected static final String USE = "use";
    protected static final String REQUIRED = "required";
    protected static final String REF = "ref";
    protected static final String TYPE = "type";
    protected static final String MIN_OCCURS = "minOccurs";
    protected static final String MAX_OCCURS = "maxOccurs";
    protected static final String NILLABLE = "nillable";
    protected static final String PROCESS_CONTENTS = "processContents";
    protected static final String LAX = "lax";
    protected static final String BASE = "base";
    protected static final String XSD_PREFIX_OPEN = "<xsd:";
    protected static final String VALUE = "value";
    protected static final String FIXED = "fixed";
    protected static final String ITEM_TYPE = "itemType";
    protected static final String MEMBER_TYPES = "memberTypes";
    protected static final String UNBOUNDED = "unbounded";
    protected static final String WSDL_ARRAY_TYPE = "wsdl:arrayType";
    protected static final String PRESERVE = "preserve";
    protected static final String REPLACE = "replace";
    protected static final String COLLAPSE = "collapse";
    protected static final String FORM = "form";
    protected static final String QUALIFIED = "qualified";
    protected static final String SOAP_ENC = "http://schemas.xmlsoap.org/soap/encoding/";
    protected static final Name SOAP_ENC_NAME = Name.create("http://schemas.xmlsoap.org/soap/encoding/");
    protected static final Name SOAP_ENC_PREFIX = Name.create("SOAP_ENC");
    protected static final String WSDL_11 = "http://schemas.xmlsoap.org/wsdl/";
    protected static final Name WSDL_11_NAME = Name.create("http://schemas.xmlsoap.org/wsdl/");
    protected static final Name WSDL_PREFIX = Name.create("wsdl");

    protected BaseComponentCoder() {
    }

    protected ITags getTags(IContext context) {
        ITags tags = context.getTags();
        tags.clear();
        return tags;
    }

    protected String composeNSDeclaration(Name namespace, IContext context) {
        if (namespace != null) {
            Name prefix = context.getXMLPrefixFromInScope(namespace);
            if (prefix == null) {
                prefix = namespace == SOAP_ENC_NAME ? SOAP_ENC_PREFIX : (namespace == WSDL_11_NAME ? WSDL_PREFIX : context.createXMLPrefix(namespace));
                context.addNamespaceDeclToInScope(namespace, prefix);
            }
            return Strings.cat(OPEN_NAMESPACE_DECL_COLON, prefix.toString(), EQUALS, namespace.toString(), QUOTE);
        }
        return "";
    }

    protected String composeAttribute(String name, String value) {
        return Strings.cat(SPACE, name, EQUALS, value, QUOTE);
    }

    protected String composeEndTag(String tag) {
        return Strings.cat(CLOSE_LESS_THAN, tag, GREATER_THAN);
    }

    protected String composeQName(QName name, IContext context) {
        Name namespace = name.getNamespaceName();
        if (namespace == null) {
            return name.getNCName();
        }
        Name prefix = context.getXMLPrefixFromInScope(namespace);
        if (prefix == null) {
            prefix = context.createXMLPrefix(namespace);
            context.addNamespaceDeclToInScope(namespace, prefix);
        }
        return Strings.cat(prefix.toString(), COLON, name.getNCName());
    }
}

