/*
 * Decompiled with CFR 0.152.
 */
package com.wm.xml;

import com.wm.util.Name;
import java.util.Hashtable;

public final class CharDefs {
    Hashtable lookup = new Hashtable(50);
    public static final int COPY = 0;
    public static final int REG = 1;
    public static final int AMP = 2;
    public static final int GT = 3;
    public static final int LT = 4;
    public static final int QUOT = 5;
    public static final int NBSP = 6;
    public static final int APOS = 7;
    private static String[] entities = new String[]{"copy", "reg", "amp", "gt", "lt", "quot", "nbsp", "middot", "sp", "apos"};
    private static int[] entValues = new int[]{169, 174, 38, 62, 60, 34, 160, 183, 32, 39};

    public void add(Name name, String val) {
        if (name == null || val == null) {
            return;
        }
        this.lookup.put(name, val);
    }

    public String lookup(String name) {
        String s = (String)this.lookup.get(Name.create(name));
        if (s != null) {
            return s;
        }
        return CharDefs.translate(name);
    }

    public static int iso8859val(String ent) {
        int i;
        block9: {
            int len = ent.length();
            if (len < 1) {
                return -1;
            }
            if (ent.charAt(0) == '#') {
                try {
                    if (len < 2) {
                        return -1;
                    }
                    if (ent.charAt(1) == 'x') {
                        if (len < 3) {
                            return -1;
                        }
                        i = Integer.parseInt(ent.substring(2), 16);
                        break block9;
                    }
                    i = Integer.parseInt(ent.substring(1));
                }
                catch (NumberFormatException e) {
                    i = -1;
                }
            } else {
                for (i = 0; i < entities.length && !ent.equals(entities[i]); ++i) {
                }
                i = i == entities.length ? -1 : entValues[i];
            }
        }
        return i;
    }

    public static String translate(String ent) {
        int val = CharDefs.iso8859val(ent);
        if (val != -1) {
            return new Character((char)val).toString();
        }
        return ent;
    }

    public static String translateString(String s) {
        int next;
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean found = false;
        int index = 0;
        while ((next = s.indexOf(38, index)) >= 0) {
            int spos = s.indexOf(59, next);
            if (spos <= 0 || spos - next > 7) {
                sb.append(s.substring(index + 1, next));
                index = next + 1;
                continue;
            }
            sb.append(s.substring(index + 1, next));
            sb.append(CharDefs.translate(s.substring(next, spos + 1)));
            index = spos + 1;
        }
        sb.append(s.substring(index, s.length()));
        return sb.toString();
    }

    public static String getXmlAttribute(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int from = 0;
        int length = s.length();
        while (from < length) {
            String escape = null;
            int to = from;
            while (to < length && escape == null) {
                char ch = s.charAt(to);
                if (ch == '&') {
                    escape = "&amp;";
                    continue;
                }
                if (ch == '<') {
                    escape = "&lt;";
                    continue;
                }
                if (ch == '\'') {
                    escape = "&apos;";
                    continue;
                }
                if (ch == '\"') {
                    escape = "&quot;";
                    continue;
                }
                ++to;
            }
            if (to == from) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(escape);
            } else if (escape != null) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(s.substring(from, to));
                sb.append(escape);
            } else {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(s.substring(from, to));
            }
            from = to + 1;
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static String getXmlContent(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int from = 0;
        int length = s.length();
        while (from < length) {
            String escape = null;
            int to = from;
            while (to < length && escape == null) {
                char ch = s.charAt(to);
                if (ch == '&') {
                    escape = "&amp;";
                    continue;
                }
                if (ch == '<') {
                    escape = "&lt;";
                    continue;
                }
                ++to;
            }
            if (to == from) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(escape);
            } else if (escape != null) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(s.substring(from, to));
                sb.append(escape);
            } else {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(s.substring(from, to));
            }
            from = to + 1;
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }
}

