/*
 * Decompiled with CFR 0.152.
 */
package com.wm.validator;

import com.wm.validator.AbstractValidator;
import com.wm.validator.BooleanValidator;
import com.wm.validator.ByteValidator;
import com.wm.validator.CharacterValidator;
import com.wm.validator.DateValidator;
import com.wm.validator.DoubleValidator;
import com.wm.validator.FloatValidator;
import com.wm.validator.IntegerValidator;
import com.wm.validator.LongValidator;
import com.wm.validator.ShortValidator;
import com.wm.validator.StringValidator;
import com.wm.validator.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ValidatorFactory {
    public static final Integer VALIDATOR_TYPE_UNKNOWN = new Integer(-1);
    public static final Integer VALIDATOR_TYPE_NOT_VALIDATED = new Integer(0);
    public static final Integer VALIDATOR_TYPE_BYTE = new Integer(101);
    public static final Integer VALIDATOR_TYPE_CHARACTER = new Integer(102);
    public static final Integer VALIDATOR_TYPE_DOUBLE = new Integer(103);
    public static final Integer VALIDATOR_TYPE_FLOAT = new Integer(104);
    public static final Integer VALIDATOR_TYPE_INTEGER = new Integer(105);
    public static final Integer VALIDATOR_TYPE_LONG = new Integer(106);
    public static final Integer VALIDATOR_TYPE_SHORT = new Integer(107);
    public static final Integer VALIDATOR_TYPE_DATE = new Integer(108);
    public static final Integer VALIDATOR_TYPE_STRING = new Integer(109);
    public static final Integer VALIDATOR_TYPE_TIME = new Integer(110);
    public static final Integer VALIDATOR_TYPE_DATETIME = new Integer(111);
    public static final Integer VALIDATOR_TYPE_BOOLEAN = new Integer(112);
    public static final int TYPE_BYTE = 101;
    public static final int TYPE_CHARACTER = 102;
    public static final int TYPE_DOUBLE = 103;
    public static final int TYPE_FLOAT = 104;
    public static final int TYPE_INTEGER = 105;
    public static final int TYPE_LONG = 106;
    public static final int TYPE_SHORT = 107;
    public static final int TYPE_DATE = 108;
    public static final int TYPE_STRING = 109;
    public static final int TYPE_TIME = 110;
    public static final int TYPE_DATETIME = 111;
    public static final int TYPE_BOOLEAN = 112;
    private static HashMap validatorMap = new HashMap();
    private static ValidatorFactory _validatorFactory;

    private ValidatorFactory() {
    }

    public static ValidatorFactory getInstance() {
        return _validatorFactory;
    }

    public static Validator getValidatorInstance(Integer validatorType) throws Exception {
        return ValidatorFactory.getValidatorInstance(validatorType, Locale.getDefault());
    }

    public static Validator getValidatorInstance(Integer validatorType, Locale l) throws Exception {
        try {
            AbstractValidator v;
            switch (validatorType) {
                case 101: {
                    v = new ByteValidator();
                    break;
                }
                case 107: {
                    v = new ShortValidator();
                    break;
                }
                case 105: {
                    v = new IntegerValidator();
                    break;
                }
                case 106: {
                    v = new LongValidator();
                    break;
                }
                case 104: {
                    v = new FloatValidator();
                    break;
                }
                case 103: {
                    v = new DoubleValidator();
                    break;
                }
                case 102: {
                    v = new CharacterValidator();
                    break;
                }
                case 109: {
                    v = new StringValidator();
                    break;
                }
                case 108: 
                case 110: 
                case 111: {
                    v = new DateValidator();
                    break;
                }
                case 112: {
                    v = new BooleanValidator();
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
            return v;
        }
        catch (Exception e) {
            throw new Exception();
        }
    }

    public boolean checkIfValidatorInstanceIsNumeric(Integer validatorType, Locale aLocale) throws Exception {
        if (!validatorMap.containsKey(validatorType)) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("com.wm.validator.resources.ValidatorMessages", aLocale);
                String validatorNotFoundMsg = bundle.getString("ValidatorNotFound");
                throw new Exception(validatorNotFoundMsg);
            }
            catch (MissingResourceException mre) {
                mre.printStackTrace();
            }
        }
        return ((Validator)validatorMap.get(validatorType)).isNumeric();
    }

    static {
        BooleanValidator the_Boolean_Validator = new BooleanValidator();
        validatorMap.put(VALIDATOR_TYPE_BOOLEAN, the_Boolean_Validator);
        ByteValidator the_Byte_Validator = new ByteValidator();
        validatorMap.put(VALIDATOR_TYPE_BYTE, the_Byte_Validator);
        CharacterValidator the_Character_Validator = new CharacterValidator();
        validatorMap.put(VALIDATOR_TYPE_CHARACTER, the_Character_Validator);
        DoubleValidator the_Double_Validator = new DoubleValidator();
        validatorMap.put(VALIDATOR_TYPE_DOUBLE, the_Double_Validator);
        FloatValidator the_Float_Validator = new FloatValidator();
        validatorMap.put(VALIDATOR_TYPE_FLOAT, the_Float_Validator);
        IntegerValidator the_Integer_Validator = new IntegerValidator();
        validatorMap.put(VALIDATOR_TYPE_INTEGER, the_Integer_Validator);
        LongValidator the_Long_Validator = new LongValidator();
        validatorMap.put(VALIDATOR_TYPE_LONG, the_Long_Validator);
        ShortValidator the_Short_Validator = new ShortValidator();
        validatorMap.put(VALIDATOR_TYPE_SHORT, the_Short_Validator);
        DateValidator the_Date_Validator = new DateValidator();
        validatorMap.put(VALIDATOR_TYPE_DATE, the_Date_Validator);
        validatorMap.put(VALIDATOR_TYPE_TIME, the_Date_Validator);
        validatorMap.put(VALIDATOR_TYPE_DATETIME, the_Date_Validator);
        StringValidator the_String_Validator = new StringValidator();
        validatorMap.put(VALIDATOR_TYPE_STRING, the_String_Validator);
        _validatorFactory = new ValidatorFactory();
    }
}

