/*
 * Decompiled with CFR 0.152.
 */
package com.wm.validator;

import com.wm.validator.StringValidator;
import com.wm.validator.ValidationResults;
import java.text.ParseException;

public abstract class NumericStringValidator
extends StringValidator {
    public boolean isNumeric() {
        return true;
    }

    public abstract boolean checkMaxValue(String var1);

    public abstract Object makeActualValidType(String var1) throws ParseException;

    public ValidationResults validateString(String aValidatableString) {
        if (aValidatableString == null || aValidatableString.length() == 0) {
            return new ValidationResults(true, null, VALIDATION_ERROR_NONE);
        }
        boolean passedValidation = false;
        try {
            Number numberParsed = NumericStringValidator.parse(aValidatableString);
        }
        catch (ParseException pe) {
            passedValidation = false;
            return new ValidationResults(passedValidation, aValidatableString, VALIDATION_ERROR_DATA_NOT_A_NUMBER);
        }
        if (!this.checkMaxValue(aValidatableString)) {
            passedValidation = false;
            return new ValidationResults(passedValidation, aValidatableString, VALIDATION_ERROR_DATA_OVER_MAX_VALUE);
        }
        try {
            Object theNumber = this.makeActualValidType(aValidatableString);
            passedValidation = true;
            return new ValidationResults(passedValidation, theNumber, VALIDATION_ERROR_NONE);
        }
        catch (ParseException pe) {
            passedValidation = false;
            return new ValidationResults(passedValidation, aValidatableString, VALIDATION_ERROR_DATA_NOT_CORRECT_TYPE);
        }
    }
}

