/*
 * Decompiled with CFR 0.152.
 */
package com.wm.validator;

import com.wm.g11n.text.NumberUtils;
import com.wm.g11n.text.gParseException;
import com.wm.validator.AbstractValidator;
import com.wm.validator.Validatable;
import com.wm.validator.ValidationResults;
import java.text.ParseException;
import java.util.Locale;

public class FloatValidator
extends AbstractValidator {
    private float parseValue(String aString) throws gParseException {
        if (aString == null) {
            throw new gParseException(8, aString, 0);
        }
        try {
            Number n = NumberUtils.parse((String)aString, (Locale)Locale.getDefault(), (int)104, (boolean)false);
            if (n == null) {
                throw new gParseException(8, aString, 0);
            }
            return n.floatValue();
        }
        catch (gParseException p) {
            throw new gParseException(p.getErrorType(), aString, p.getErrorOffset());
        }
    }

    public boolean checkMaxValue(String aString) {
        if (aString == null || aString.length() == 0) {
            return true;
        }
        try {
            float x = this.parseValue(aString);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public Object makeActualValidType(String aString) throws ParseException {
        try {
            float x = this.parseValue(aString);
            return new Float(x);
        }
        catch (gParseException pe) {
            return null;
        }
    }

    public ValidationResults validate(Validatable aValidatable) {
        boolean passedValidation = false;
        Object resultsValue = aValidatable.getValueToValidate();
        return this.validate(resultsValue);
    }

    public ValidationResults validate(Object aValue) {
        if (aValue instanceof String) {
            String s = (String)aValue;
            if (s.length() == 0) {
                return new ValidationResults(true, null);
            }
            try {
                float b = this.parseValue(s);
                boolean passedValidation = true;
                return new ValidationResults(passedValidation, new Float(b));
            }
            catch (gParseException pe) {
                if (pe.getErrorType() == 8) {
                    return new ValidationResults(true, null, VALIDATION_ERROR_NONE);
                }
                return new ValidationResults(false, aValue, VALIDATION_ERROR_DATA_NOT_A_NUMBER);
            }
        }
        boolean passedValidation = false;
        return new ValidationResults(passedValidation, aValue, VALIDATION_ERROR_VALUE_CLASS_WRONG);
    }

    public boolean isNumeric() {
        return true;
    }
}

