/*
 * Decompiled with CFR 0.152.
 */
package com.wm.validator;

import com.wm.g11n.text.NumberUtils;
import com.wm.g11n.text.gParseException;
import com.wm.validator.AbstractValidator;
import com.wm.validator.Validatable;
import com.wm.validator.ValidationResults;
import java.text.ParseException;
import java.util.Locale;

public class DoubleValidator
extends AbstractValidator {
    public double parseValue(String aString) throws gParseException {
        if (aString == null) {
            throw new gParseException(8, aString, 0);
        }
        Number n = null;
        try {
            n = NumberUtils.parse((String)aString, (Locale)Locale.getDefault(), null, null, (int)103, (boolean)false);
            if (n == null) {
                throw new gParseException(8, aString, 0);
            }
            return n.doubleValue();
        }
        catch (gParseException gPE) {
            throw new gParseException(gPE.getErrorType(), aString, gPE.getErrorOffset());
        }
    }

    public boolean checkMaxValue(String aString) {
        if (aString == null || aString.length() == 0) {
            return true;
        }
        try {
            double x = this.parseValue(aString);
            return true;
        }
        catch (gParseException pe) {
            return pe.getErrorType() == 8;
        }
    }

    public Object makeActualValidType(String aString) throws ParseException {
        try {
            return new Double(this.parseValue(aString));
        }
        catch (gParseException pe) {
            return null;
        }
    }

    public ValidationResults validate(Validatable aValidatable) {
        boolean passedValidation = false;
        Object resultsValue = aValidatable.getValueToValidate();
        return this.validate(resultsValue);
    }

    public ValidationResults validate(Object aValue) {
        if (aValue == null) {
            return new ValidationResults(true, null);
        }
        if (aValue instanceof String) {
            String s = (String)aValue;
            try {
                double b = this.parseValue(s);
                return new ValidationResults(true, new Double(b));
            }
            catch (gParseException pe) {
                if (pe.getErrorType() == 8) {
                    return new ValidationResults(true, null);
                }
                return new ValidationResults(false, aValue, VALIDATION_ERROR_DATA_NOT_A_NUMBER);
            }
        }
        boolean passedValidation = false;
        return new ValidationResults(passedValidation, aValue, VALIDATION_ERROR_VALUE_CLASS_WRONG);
    }

    public boolean isNumeric() {
        return true;
    }
}

