/*
 * Decompiled with CFR 0.152.
 */
package com.wm.validator;

import com.wm.g11n.text.DateUtils;
import com.wm.validator.StringValidator;
import com.wm.validator.Validatable;
import com.wm.validator.ValidationResults;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class DateValidator
extends StringValidator {
    public ValidationResults validate(Validatable aValidatable) {
        boolean passedValidation = false;
        Object resultsValue = aValidatable.getValueToValidate();
        return this.validate(resultsValue);
    }

    public ValidationResults validate(Object aValue) {
        if (aValue instanceof String) {
            try {
                String aString = DateValidator.ascii2native((String)aValue);
                if (aString.length() == 0) {
                    return new ValidationResults(true, null);
                }
                try {
                    Date d = DateUtils.getDateTimeFromString((String)aString, (Locale)Locale.getDefault());
                    if (d != null) {
                        return new ValidationResults(true, d, VALIDATION_ERROR_NONE);
                    }
                    return new ValidationResults(false, aString, VALIDATION_ERROR_DATA_NOT_A_DATE);
                }
                catch (ParseException pe) {
                    return new ValidationResults(false, aString, VALIDATION_ERROR_DATA_NOT_A_DATE);
                }
            }
            catch (IOException ioe) {
                return new ValidationResults(false, aValue, VALIDATION_ERROR_ILLEGAL_CHARACTER_SEQUENCE);
            }
        }
        if (aValue instanceof Date) {
            return new ValidationResults(true, aValue, VALIDATION_ERROR_NONE);
        }
        boolean passedValidation = false;
        return new ValidationResults(passedValidation, aValue, VALIDATION_ERROR_VALUE_CLASS_WRONG);
    }

    public ValidationResults validateString(String aValidatableString) {
        boolean passedValidation = false;
        String resultsValue = aValidatableString;
        return this.validate(resultsValue);
    }
}

