/*
 * Decompiled with CFR 0.152.
 */
package com.wm.validator;

import com.wm.g11n.util.RangedNormalizer;
import com.wm.g11n.util.encodingUtils;
import com.wm.validator.StringValidator;
import com.wm.validator.ValidationResults;
import java.io.IOException;
import java.text.StringCharacterIterator;

public class CharacterValidator
extends StringValidator {
    public static String native2ascii(String input) {
        return encodingUtils.native2ascii((String)input);
    }

    public static String ascii2native(String input) throws IOException {
        String tmp;
        input = encodingUtils.ascii2native((String)input);
        RangedNormalizer rn = new RangedNormalizer();
        rn.setMode(1);
        try {
            tmp = rn.normalize(input);
        }
        catch (Exception e) {
            tmp = input;
        }
        return tmp;
    }

    private boolean validSurrogateString(String aString) {
        if (aString == null) {
            return true;
        }
        if (aString.length() < 2) {
            return true;
        }
        if (aString.length() > 2) {
            return false;
        }
        char x = aString.charAt(0);
        char y = aString.charAt(1);
        return x >= '\ud800' && x < '\udc00' && y >= '\udc00' && y < '\ue000';
    }

    public ValidationResults validateString(String aValidatableString) {
        boolean passedValidation = false;
        try {
            aValidatableString = CharacterValidator.ascii2native(aValidatableString);
        }
        catch (IOException ioe) {
            return new ValidationResults(false, aValidatableString, VALIDATION_ERROR_ILLEGAL_CHARACTER_SEQUENCE);
        }
        if (aValidatableString == null || aValidatableString.length() == 0) {
            return new ValidationResults(true, null, VALIDATION_ERROR_NONE);
        }
        if (aValidatableString.length() == 1) {
            StringCharacterIterator sci = new StringCharacterIterator(aValidatableString);
            char first = sci.first();
            Character aCharacter = first != '\uffff' ? new Character(first) : null;
            return new ValidationResults(true, aCharacter);
        }
        if (this.validSurrogateString(aValidatableString)) {
            StringCharacterIterator sci = new StringCharacterIterator(aValidatableString);
            char first = sci.first();
            Character aCharacter = first != '\uffff' ? new Character(first) : null;
            return new ValidationResults(true, aCharacter);
        }
        return new ValidationResults(false, aValidatableString, VALIDATION_ERROR_DATA_NOT_CORRECT_TYPE);
    }

    public ValidationResults validate(Object aValue) {
        if (aValue instanceof String) {
            return this.validateString((String)aValue);
        }
        if (aValue instanceof Character) {
            return new ValidationResults(true, aValue);
        }
        boolean passedValidation = false;
        return new ValidationResults(passedValidation, aValue, VALIDATION_ERROR_VALUE_CLASS_WRONG);
    }
}

