/*
 * Decompiled with CFR 0.152.
 */
package com.wm.validator;

import com.wm.validator.AbstractValidator;
import com.wm.validator.Validatable;
import com.wm.validator.ValidationResults;
import java.text.ParseException;
import java.util.Locale;

public class ByteValidator
extends AbstractValidator {
    private static final int HEX = 1;
    private static final int OCTAL = 2;
    private static final int DECIMAL = 3;

    public ByteValidator() {
        this(Locale.getDefault());
    }

    public ByteValidator(Locale aLocale) {
    }

    private byte parseValue(String aString) throws ParseException {
        int sign = 0;
        try {
            int pos = aString.indexOf(45);
            if (pos == 0) {
                sign = -1;
                aString = aString.substring(1);
            } else if (pos == aString.length() - 1) {
                aString = aString.substring(0, aString.length() - 1);
                sign = -1;
            } else {
                sign = 1;
            }
            Integer b = aString.indexOf(48) == 0 && aString.indexOf(120) == 1 ? Integer.valueOf(aString.substring(2), 16) : (aString.indexOf(47) == 0 || aString.indexOf(92) == 0 ? (aString.indexOf(120) == 1 ? Integer.valueOf(aString.substring(2), 16) : (aString.indexOf(111) == 1 ? Integer.valueOf(aString.substring(2), 8) : Integer.valueOf(aString.substring(1)))) : Integer.valueOf(aString, 16));
            int bv = b;
            if ((bv *= sign) >= -128 && bv < 128) {
                byte bx = (byte)bv;
                return bx;
            }
            throw new ParseException(aString, 3);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(aString, 2);
        }
    }

    public boolean checkMaxValue(String aString) {
        try {
            byte b = this.parseValue(aString);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public Object makeActualValidType(String aString) throws ParseException {
        try {
            if (aString != null || aString.length() != 0) {
                byte theNumberRequested = this.parseValue(aString);
                Byte returnNumber = new Byte(theNumberRequested);
                return returnNumber;
            }
            Object rn = null;
            return rn;
        }
        catch (ParseException pe) {
            throw new ParseException(aString, 2);
        }
    }

    public ValidationResults validate(Validatable aValidatable) {
        boolean passedValidation = false;
        Object resultsValue = aValidatable.getValueToValidate();
        return this.validate(resultsValue);
    }

    public ValidationResults validate(Object aValue) {
        if (aValue == null) {
            return new ValidationResults(true, null, VALIDATION_ERROR_NONE);
        }
        if (aValue instanceof String) {
            String s = (String)aValue;
            if (s.length() == 0) {
                return new ValidationResults(true, null);
            }
            try {
                byte b = this.parseValue(s);
                boolean passedValidation = true;
                return new ValidationResults(passedValidation, new Byte(b));
            }
            catch (ParseException pe) {
                return new ValidationResults(false, aValue, VALIDATION_ERROR_DATA_NOT_A_NUMBER);
            }
        }
        boolean passedValidation = false;
        return new ValidationResults(passedValidation, aValue, VALIDATION_ERROR_VALUE_CLASS_WRONG);
    }

    public boolean isNumeric() {
        return true;
    }
}

