/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.xform;

import com.wm.net.EncodeURL;
import com.wm.util.Values;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class StringDT {
    private static HashMap EntityHash = new HashMap(5);

    public static String toUpper(String inString, String language, String country, String variant) {
        if (inString == null) {
            return null;
        }
        if (language == null || country == null) {
            return inString.toUpperCase();
        }
        Locale mylocale = variant == null ? new Locale(language, country) : new Locale(language, country, variant);
        return inString.toUpperCase(mylocale);
    }

    public static String toLower(String inString, String language, String country, String variant) {
        if (inString == null) {
            return null;
        }
        if (language == null || country == null) {
            return inString.toLowerCase();
        }
        Locale mylocale = variant == null ? new Locale(language, country) : new Locale(language, country, variant);
        return inString.toLowerCase(mylocale);
    }

    public static String substring(String inString, String beginIndex, String endIndex) {
        if (inString == null) {
            return null;
        }
        int beginI = beginIndex == null || beginIndex.length() == 0 ? 0 : Integer.parseInt(beginIndex);
        if (endIndex == null || endIndex.length() == 0) {
            return inString.substring(beginI);
        }
        int endI = Integer.parseInt(endIndex);
        if (endI > inString.length()) {
            return inString.substring(beginI);
        }
        return inString.substring(beginI, endI);
    }

    public static String length(String inString) {
        if (inString == null) {
            return null;
        }
        return Integer.toString(inString.length());
    }

    public static String replace(String inString, String searchString, String replaceString, boolean useRegex) throws MalformedPatternException {
        if (inString == null) {
            return null;
        }
        if (searchString == null || searchString.length() == 0) {
            return inString;
        }
        if (replaceString == null) {
            replaceString = "";
        }
        if (useRegex) {
            Perl5Compiler compiler = new Perl5Compiler();
            Perl5Matcher matcher = new Perl5Matcher();
            Pattern pattern = compiler.compile(searchString);
            Perl5Substitution sst = new Perl5Substitution(replaceString);
            return Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)sst, (String)inString, (int)-1);
        }
        int oldlength = searchString.length();
        StringBuffer sb = new StringBuffer();
        int lastFound = 0;
        int index = 0;
        while ((lastFound = inString.indexOf(searchString, index)) >= 0) {
            sb.append(inString.substring(index, lastFound));
            sb.append(replaceString);
            index = lastFound + oldlength;
        }
        sb.append(inString.substring(index));
        return sb.toString();
    }

    public static String padLeft(String inString, String padString, String length) {
        if (inString == null) {
            return null;
        }
        if (padString == null || padString.length() == 0) {
            padString = " ";
        }
        int slength = inString.length();
        int padlength = padString.length();
        int targetlength = Integer.parseInt(length);
        int filllength = targetlength - slength;
        if (filllength > 0) {
            StringBuffer sb = new StringBuffer(targetlength);
            for (int i = 0; i < filllength / padlength; ++i) {
                sb.append(padString);
            }
            sb.append(padString.substring(0, filllength % padlength));
            sb.append(inString);
            return sb.toString();
        }
        if (filllength == 0) {
            return inString;
        }
        return inString.substring(slength - targetlength);
    }

    public static String padRight(String inString, String padString, String length) {
        if (inString == null) {
            return null;
        }
        if (padString == null || padString.length() == 0) {
            padString = " ";
        }
        int slength = inString.length();
        int padlength = padString.length();
        int targetlength = Integer.parseInt(length);
        int filllength = targetlength - slength;
        if (filllength > 0) {
            StringBuffer sb = new StringBuffer(targetlength);
            sb.append(inString);
            sb.append(padString.substring(padlength - filllength % padlength));
            for (int i = 0; i < filllength / padlength; ++i) {
                sb.append(padString);
            }
            return sb.toString();
        }
        if (filllength == 0) {
            return inString;
        }
        return inString.substring(0, targetlength);
    }

    public static String indexOf(String inString, String subString, String fromIndex) {
        if (inString == null || inString.length() == 0) {
            return null;
        }
        if (subString == null || subString.length() == 0) {
            return null;
        }
        int fromI = fromIndex == null || fromIndex.length() == 0 ? 0 : Integer.parseInt(fromIndex);
        return Integer.toString(inString.indexOf(subString, fromI));
    }

    public static String concat(String inString1, String inString2) {
        if (inString1 == null && inString2 == null) {
            return null;
        }
        if (inString2 == null) {
            return inString1;
        }
        if (inString1 == null) {
            return inString2;
        }
        return inString1 + inString2;
    }

    public static String trim(String inString) {
        if (inString == null) {
            return null;
        }
        return inString.trim();
    }

    public static String[] tokenize(String inString, String delim) {
        StringTokenizer st = delim == null || delim.length() == 0 ? new StringTokenizer(inString) : new StringTokenizer(inString, delim);
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    public static String makeString(String[] stringList, String separator) {
        if (stringList == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        StringBuffer sb = new StringBuffer();
        boolean started = false;
        for (int i = 0; i < stringList.length; ++i) {
            if (stringList[i] == null) continue;
            if (started) {
                sb.append(separator);
                sb.append(stringList[i]);
                continue;
            }
            sb.append(stringList[i]);
            started = true;
        }
        return sb.toString();
    }

    public static String messageFormat(String[] stringList, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return pattern;
        }
        return MessageFormat.format(pattern, stringList);
    }

    public static String numericFormat(String num, String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(Double.valueOf(num));
    }

    public static String HTMLEncode(String inString) {
        if (inString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int iLength = inString.length();
        for (int i = 0; i < iLength; ++i) {
            char c = inString.charAt(i);
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&#39;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String translateEntity(String inString) {
        String entity = (String)EntityHash.get(inString);
        if (entity != null) {
            return entity;
        }
        int len = inString.length();
        if (len <= 3 || inString.charAt(1) != '#') {
            return inString;
        }
        try {
            int asciival;
            if (inString.charAt(2) == 'x') {
                if (len <= 4) {
                    return inString;
                }
                asciival = Integer.parseInt(inString.substring(3, len - 1), 16);
            } else {
                asciival = Integer.parseInt(inString.substring(2, len - 1));
            }
            return new Character((char)asciival).toString();
        }
        catch (NumberFormatException e) {
            return inString;
        }
    }

    public static String HTMLDecode(String inString) {
        int nextend;
        int nextbegin;
        if (inString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while ((nextbegin = inString.indexOf(38, index)) >= 0 && (nextend = inString.indexOf(59, nextbegin)) > 0) {
            if (nextend - nextbegin > 7) {
                sb.append(inString.substring(index, nextbegin + 1));
                index = nextbegin + 1;
                continue;
            }
            sb.append(inString.substring(index, nextbegin));
            sb.append(StringDT.translateEntity(inString.substring(nextbegin, nextend + 1)));
            index = nextend + 1;
        }
        sb.append(inString.substring(index));
        return sb.toString();
    }

    public static String URLEncode(String inString) {
        if (inString == null) {
            return null;
        }
        return EncodeURL.encode(inString);
    }

    public static String URLDecode(String inString) {
        if (inString == null) {
            return null;
        }
        return EncodeURL.decode(inString);
    }

    public static String lookupTable(String[][] lookupTable, String keyColumnIndex, String valueColumnIndex, String key, boolean ignoreCase, boolean useRegex) throws MalformedPatternException {
        int valueCol;
        int keyCol;
        if (lookupTable == null || key == null) {
            return null;
        }
        try {
            keyCol = Integer.parseInt(keyColumnIndex);
        }
        catch (Exception e) {
            keyCol = 0;
        }
        try {
            valueCol = Integer.parseInt(valueColumnIndex);
        }
        catch (Exception e) {
            valueCol = 1;
        }
        if (useRegex) {
            Perl5Compiler compiler = new Perl5Compiler();
            Perl5Matcher matcher = new Perl5Matcher();
            if (ignoreCase) {
                for (int i = 0; i < lookupTable.length; ++i) {
                    Pattern pattern;
                    if (lookupTable[i][keyCol] == null || !matcher.contains(key, pattern = compiler.compile(lookupTable[i][keyCol], 1))) continue;
                    return lookupTable[i][valueCol];
                }
            } else {
                for (int i = 0; i < lookupTable.length; ++i) {
                    Pattern pattern;
                    if (lookupTable[i][keyCol] == null || !matcher.contains(key, pattern = compiler.compile(lookupTable[i][keyCol]))) continue;
                    return lookupTable[i][valueCol];
                }
            }
        } else if (ignoreCase) {
            for (int i = 0; i < lookupTable.length; ++i) {
                if (!key.equalsIgnoreCase(lookupTable[i][keyCol])) continue;
                return lookupTable[i][valueCol];
            }
        } else {
            for (int i = 0; i < lookupTable.length; ++i) {
                if (!key.equals(lookupTable[i][keyCol])) continue;
                return lookupTable[i][valueCol];
            }
        }
        return null;
    }

    public static String lookupDictionary(Hashtable hashtable, String key) {
        if (hashtable == null || key == null) {
            return null;
        }
        Object o = hashtable.get(key);
        return (String)o;
    }

    public static Values HTMLEncodeValues(Values output) {
        Enumeration e = output.keys();
        while (e.hasMoreElements()) {
            int j;
            int i;
            String key = (String)e.nextElement();
            Object obj = output.get(key);
            if (obj instanceof String) {
                output.put(key, StringDT.HTMLEncode((String)obj));
            }
            if (obj instanceof String[]) {
                String[] slist = (String[])obj;
                for (i = 0; i < slist.length; ++i) {
                    slist[i] = StringDT.HTMLEncode(slist[i]);
                }
                output.put(key, slist);
            }
            if (obj instanceof String[][]) {
                String[][] stable = (String[][])obj;
                for (i = 0; i < stable.length; ++i) {
                    for (j = 0; j < stable[i].length; ++j) {
                        stable[i][j] = StringDT.HTMLEncode(stable[i][j]);
                    }
                }
                output.put(key, stable);
            }
            if (obj instanceof Values) {
                output.put(key, StringDT.HTMLEncodeValues((Values)obj));
            }
            if (obj instanceof Values[]) {
                Values[] val = (Values[])obj;
                for (i = 0; i < val.length; ++i) {
                    val[i] = StringDT.HTMLEncodeValues(val[i]);
                }
                output.put(key, val);
            }
            if (!(obj instanceof Values[][])) continue;
            Values[][] valarray = (Values[][])obj;
            for (i = 0; i < valarray.length; ++i) {
                for (j = 0; j < valarray[i].length; ++j) {
                    valarray[i][j] = StringDT.HTMLEncodeValues(valarray[i][j]);
                }
            }
            output.put(key, valarray);
        }
        return output;
    }

    static {
        EntityHash.put("&gt;", ">");
        EntityHash.put("&lt;", "<");
        EntityHash.put("&amp;", "&");
        EntityHash.put("&quot;", "\"");
        EntityHash.put("&apos;", "'");
    }
}

