/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.xform;

import java.text.NumberFormat;
import java.util.regex.Pattern;

public class MathDT {
    public static final String NOT_A_NUM = "NaN";
    public static final String JAVA_INFINITE_NUM = "Infinity";
    public static final String JAVA_NEG_INF_NUM = "-Infinity";

    public static String addInts(String num1, String num2) throws NumberFormatException {
        return MathDT.addInts(num1, num2, null);
    }

    public static String addInts(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        long number1 = Long.parseLong(num1);
        long number2 = Long.parseLong(num2);
        long sum = number1 + number2;
        if (nf != null) {
            return nf.format(sum);
        }
        return Long.toString(sum);
    }

    public static String addIntList(String[] numList) throws NumberFormatException {
        return MathDT.addIntList(numList, null);
    }

    public static String addIntList(String[] numList, NumberFormat nf) throws NumberFormatException {
        long sum = 0L;
        for (int i = 0; i < numList.length; ++i) {
            if (numList[i] == null) continue;
            sum += Long.parseLong(numList[i]);
        }
        if (nf != null) {
            return nf.format(sum);
        }
        return Long.toString(sum);
    }

    public static String addFloats(String num1, String num2) throws NumberFormatException {
        return MathDT.addFloats(num1, num2, null);
    }

    public static String addFloats(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        double number1 = MathDT.strToFloat(num1);
        double number2 = MathDT.strToFloat(num2);
        double sum = number1 + number2;
        return MathDT.floatToStr(sum, nf);
    }

    public static int getDecimalPrecision(String num) {
        int index2;
        long precision = 0L;
        int index1 = num.indexOf(46);
        int n = index2 = num.indexOf(101) != -1 ? num.indexOf(101) : num.indexOf(69);
        if (index1 > -1) {
            if (index2 > -1) {
                if (Pattern.compile("[0]").split(num.substring(index1 + 1, index2)).length > 0) {
                    precision = index2 - (index1 + 1);
                }
            } else if (Pattern.compile("[0]").split(num.substring(index1 + 1, num.length())).length > 0) {
                precision = num.length() - (index1 + 1);
            }
        }
        if (index2 > -1) {
            String str = num.substring(index2 + 1, num.length());
            try {
                precision -= Long.parseLong(str);
            }
            catch (NumberFormatException nfe) {
                NumberFormatException newnfe = new NumberFormatException(num);
                newnfe.setStackTrace(nfe.getStackTrace());
                throw newnfe;
            }
        }
        return (int)(precision > 0L ? precision : 0L);
    }

    public static String addFloatList(String[] numList) throws NumberFormatException {
        return MathDT.addFloatList(numList, null);
    }

    public static String addFloatList(String[] numList, NumberFormat nf) throws NumberFormatException {
        double sum = 0.0;
        for (int i = 0; i < numList.length; ++i) {
            if (numList[i] == null) continue;
            sum += MathDT.strToFloat(numList[i]);
        }
        return MathDT.floatToStr(sum, nf);
    }

    public static String subtractInts(String num1, String num2) throws NumberFormatException {
        return MathDT.subtractInts(num1, num2, null);
    }

    public static String subtractInts(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        long number1 = Long.parseLong(num1);
        long number2 = Long.parseLong(num2);
        long diff = number1 - number2;
        if (nf != null) {
            return nf.format(diff);
        }
        return Long.toString(diff);
    }

    public static String subtractFloats(String num1, String num2) throws NumberFormatException {
        return MathDT.subtractFloats(num1, num2, null);
    }

    public static String subtractFloats(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        double number1 = MathDT.strToFloat(num1);
        double number2 = MathDT.strToFloat(num2);
        double diff = number1 - number2;
        return MathDT.floatToStr(diff, nf);
    }

    public static String multiplyInts(String num1, String num2) throws NumberFormatException {
        return MathDT.multiplyInts(num1, num2, null);
    }

    public static String multiplyInts(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        long number1 = Long.parseLong(num1);
        long number2 = Long.parseLong(num2);
        long product = number1 * number2;
        if (nf != null) {
            return nf.format(product);
        }
        return Long.toString(product);
    }

    public static String multiplyIntList(String[] numList) throws NumberFormatException {
        return MathDT.multiplyIntList(numList, null);
    }

    public static String multiplyIntList(String[] numList, NumberFormat nf) throws NumberFormatException {
        long product = 1L;
        for (int i = 0; i < numList.length; ++i) {
            if (numList[i] == null) continue;
            product *= Long.parseLong(numList[i]);
        }
        if (nf != null) {
            return nf.format(product);
        }
        return Long.toString(product);
    }

    public static String multiplyFloats(String num1, String num2) throws NumberFormatException {
        return MathDT.multiplyFloats(num1, num2, null);
    }

    public static String multiplyFloats(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        double number1 = MathDT.strToFloat(num1);
        double number2 = MathDT.strToFloat(num2);
        double product = number1 * number2;
        return MathDT.floatToStr(product, nf);
    }

    public static String multiplyFloatList(String[] numList) throws NumberFormatException {
        return MathDT.multiplyFloatList(numList, null);
    }

    public static String multiplyFloatList(String[] numList, NumberFormat nf) throws NumberFormatException {
        double product = 1.0;
        for (int i = 0; i < numList.length; ++i) {
            if (numList[i] == null) continue;
            product *= MathDT.strToFloat(numList[i]);
        }
        return MathDT.floatToStr(product, nf);
    }

    public static String divideInts(String num1, String num2) throws NumberFormatException {
        return MathDT.divideInts(num1, num2, null);
    }

    public static String divideInts(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        long number1 = Long.parseLong(num1);
        long number2 = Long.parseLong(num2);
        long qoutient = number1 / number2;
        if (nf != null) {
            return nf.format(qoutient);
        }
        return Long.toString(qoutient);
    }

    public static String divideFloats(String num1, String num2) throws NumberFormatException {
        return MathDT.divideFloats(num1, num2, null);
    }

    public static String divideFloats(String num1, String num2, NumberFormat nf) throws NumberFormatException {
        double number1 = MathDT.strToFloat(num1);
        double number2 = MathDT.strToFloat(num2);
        double qoutient = number1 / number2;
        return MathDT.floatToStr(qoutient, nf);
    }

    public static double strToFloat(String numStr) throws NumberFormatException {
        if (numStr.equals(JAVA_INFINITE_NUM)) {
            return Double.POSITIVE_INFINITY;
        }
        if (numStr.equals(JAVA_NEG_INF_NUM)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (numStr.equals(NOT_A_NUM)) {
            return Double.NaN;
        }
        return Double.valueOf(numStr);
    }

    public static String floatToStr(double num, NumberFormat nf) throws NumberFormatException {
        if (num == Double.POSITIVE_INFINITY) {
            return JAVA_INFINITE_NUM;
        }
        if (num == Double.NEGATIVE_INFINITY) {
            return JAVA_NEG_INF_NUM;
        }
        if (Double.isNaN(num)) {
            return NOT_A_NUM;
        }
        if (nf != null) {
            return nf.format(num);
        }
        return Double.toString(num);
    }

    public static boolean isSpecialNum(String numStr) {
        return numStr.equals(JAVA_INFINITE_NUM) || numStr.equals(JAVA_NEG_INF_NUM) || numStr.equals(NOT_A_NUM);
    }
}

