/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.xform;

import com.wm.util.Config;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeDT {
    public static String dateTimeFormat(String inString, String currentPattern, String newPattern) {
        return DateTimeDT.dateTimeFormat(inString, currentPattern, newPattern, Locale.getDefault());
    }

    public static String dateTimeFormat(String inString, String currentPattern, String newPattern, Locale loc) {
        return DateTimeDT.dateTimeFormat(inString, currentPattern, newPattern, loc, true);
    }

    public static String dateTimeFormat(String inString, String currentPattern, String newPattern, Locale loc, boolean lenient) {
        Date d;
        if (inString == null || inString.length() == 0) {
            return inString;
        }
        if (currentPattern == null || newPattern == null) {
            return null;
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        SimpleDateFormat currentForm = new SimpleDateFormat(currentPattern, loc);
        SimpleDateFormat newForm = new SimpleDateFormat(newPattern, loc);
        currentForm.setLenient(lenient);
        if (Config.getProperty("false", "watt.server.pubDateTimeFormat.javaSlidingWindow").equals("false")) {
            Calendar c = Calendar.getInstance();
            c.set(1, c.get(1) - 50);
            currentForm.set2DigitYearStart(c.getTime());
        }
        if ((d = currentForm.parse(inString, new ParsePosition(0))) == null) {
            return null;
        }
        return newForm.format(d);
    }

    public static String currentDate(String pattern, String timeZoneID) {
        return DateTimeDT.currentDate(pattern, timeZoneID, null);
    }

    public static String currentDate(String pattern, String timeZoneID, Locale loc) {
        return DateTimeDT.convertDate(new Date(), pattern, timeZoneID, loc);
    }

    public static String convertDate(Date dt, String pattern, String timeZoneID) {
        return DateTimeDT.convertDate(dt, pattern, timeZoneID, null);
    }

    public static String convertDate(Date dt, String pattern, String timeZoneID, Locale loc) {
        SimpleDateFormat sdf = loc == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, loc);
        TimeZone tz = null;
        if (timeZoneID != null) {
            tz = TimeZone.getTimeZone(timeZoneID);
        }
        if (tz == null) {
            sdf.setTimeZone(TimeZone.getDefault());
        } else {
            sdf.setTimeZone(tz);
        }
        return sdf.format(dt);
    }

    public static String dateBuild(String pattern, String year, String month, String dayofmonth, String timeZoneID) {
        return DateTimeDT.dateBuild(pattern, year, month, dayofmonth, timeZoneID, null);
    }

    public static String dateBuild(String pattern, String year, String month, String dayofmonth, String timeZoneID, Locale loc) {
        if (pattern == null) {
            return null;
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (year != null && year.length() != 0) {
            int iYear = Integer.parseInt(year);
            if (year.length() <= 2) {
                iYear = DateTimeDT.convertTwoDigitYear(iYear);
            }
            cal.set(1, iYear);
        }
        if (month != null && month.length() != 0) {
            cal.set(2, Integer.parseInt(month) - 1);
        }
        if (dayofmonth != null && dayofmonth.length() != 0) {
            cal.set(5, Integer.parseInt(dayofmonth));
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, loc);
        TimeZone tz = null;
        if (timeZoneID != null) {
            tz = TimeZone.getTimeZone(timeZoneID);
        }
        if (tz == null) {
            sdf.setTimeZone(TimeZone.getDefault());
        } else {
            sdf.setTimeZone(tz);
        }
        return sdf.format(cal.getTime());
    }

    public static String dateTimeBuild(String pattern, String year, String month, String dayofmonth, String hour, String minute, String second, String millis, String timeZoneID) {
        return DateTimeDT.dateTimeBuild(pattern, year, month, dayofmonth, hour, minute, second, millis, timeZoneID, null);
    }

    public static String dateTimeBuild(String pattern, String year, String month, String dayofmonth, String hour, String minute, String second, String millis, String timeZoneID, Locale loc) {
        if (pattern == null) {
            return null;
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        Calendar cal = Calendar.getInstance(loc);
        cal.setTime(new Date());
        if (year != null && year.length() != 0) {
            int iYear = Integer.parseInt(year);
            if (year.length() <= 2) {
                iYear = DateTimeDT.convertTwoDigitYear(iYear);
            }
            cal.set(1, iYear);
        }
        if (month != null && month.length() != 0) {
            cal.set(2, Integer.parseInt(month) - 1);
        }
        if (dayofmonth != null && dayofmonth.length() != 0) {
            cal.set(5, Integer.parseInt(dayofmonth));
        }
        if (hour != null && hour.length() != 0) {
            cal.set(11, Integer.parseInt(hour));
        } else {
            cal.set(11, 0);
        }
        if (minute != null && minute.length() != 0) {
            cal.set(12, Integer.parseInt(minute));
        } else {
            cal.set(12, 0);
        }
        if (second != null && second.length() != 0) {
            cal.set(13, Integer.parseInt(second));
        } else {
            cal.set(13, 0);
        }
        if (millis != null && millis.length() != 0) {
            cal.set(14, Integer.parseInt(millis));
        } else {
            cal.set(14, 0);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, loc);
        TimeZone tz = null;
        if (timeZoneID != null) {
            tz = TimeZone.getTimeZone(timeZoneID);
        }
        if (tz == null) {
            sdf.setTimeZone(TimeZone.getDefault());
        } else {
            sdf.setTimeZone(tz);
        }
        return sdf.format(cal.getTime());
    }

    public static String dateTimeFormat(long when, String format) {
        Date d = new Date(when);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static long dateTimeBuild(String dateTime, String format) {
        return DateTimeDT.dateTimeBuild(dateTime, format, true);
    }

    public static long dateTimeBuild(String dateTime, String format, boolean lenient) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getDefault());
        sdf.setLenient(lenient);
        Date d = sdf.parse(dateTime, new ParsePosition(0));
        return d != null ? d.getTime() : -1L;
    }

    private static int convertTwoDigitYear(int yy) {
        if (yy > 100) {
            return yy;
        }
        int thisCCYY = Calendar.getInstance().get(1);
        int thisCC = thisCCYY / 100;
        int CCYY = thisCC * 100 + yy;
        int delta = CCYY - thisCCYY;
        if (delta > 50) {
            CCYY -= 100;
        } else if (delta < -49) {
            CCYY += 100;
        }
        return CCYY;
    }
}

