/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tx;

import com.wm.app.repov4.IRepoDirectory;
import com.wm.app.repov4.IRepository;
import com.wm.data.IData;
import com.wm.util.Config;
import com.wm.util.Values;
import com.wm.util.tx.TXJob;
import com.wm.util.tx.TXJobException;
import com.wm.util.tx.TXJobId;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class TXJobStore {
    protected static final String SWEEPER_LOCK = "Sweeper";
    protected static final String JOB_KEY = "TXJob";
    protected static final String OWNER_KEY = "ownerId";
    protected static final String OWNER_INSTANCE = "ownerInstance";
    Vector<TXJob> waitList = new Vector();
    Object jobLock = new Object();
    private static final String FILE_EXTENSION = ".xtn";
    private static final String TMP_EXTENSION = ".xtt";
    private static final String BAK_EXTENSION = ".bak";
    private String storePath;
    private boolean inCluster;
    private boolean syncWrites;
    private long lockTimeout;
    private long lockBreakTime;
    private long jobPendingWait;
    protected String ownerHost;
    protected String ownerPort;
    protected String ownerInstance;
    protected Values ownerId;

    public TXJobStore() {
        String port;
        String host;
        try {
            host = Config.getLocalHost().getHostName();
            port = Config.getProperty("5555", "watt.server.port");
        }
        catch (Exception e) {
            host = "localhost";
            port = "5555";
        }
        this.ownerHost = host;
        this.ownerPort = port;
        this.ownerInstance = TXJobId.get();
        Object[][] o = new Object[][]{{OWNER_KEY, this.ownerHost + ":" + this.ownerPort}, {OWNER_INSTANCE, this.ownerInstance}};
        this.ownerId = new Values(o);
    }

    public abstract Hashtable loadJobs() throws TXJobException;

    public abstract void shutdown();

    public abstract boolean jobExists(String var1) throws TXJobException;

    public abstract boolean jobGone(String var1);

    public abstract Object viewJob(String var1);

    public abstract Object getJobNoWait(String var1) throws TXJobException;

    public abstract Object getJob(String var1) throws TXJobException;

    public abstract void purgeStaleLocks(Values var1);

    public abstract Object getJobIfMine(String var1) throws TXJobException;

    public abstract void releaseJob(String var1) throws TXJobException;

    public abstract boolean addJob(String var1, TXJob var2) throws TXJobException;

    public abstract IData getJobData(TXJob var1) throws TXJobException;

    public abstract void updateJob(TXJob var1, boolean var2) throws TXJobException;

    public abstract void updateJobForClean(TXJob var1, boolean var2) throws TXJobException;

    public abstract void removeJob(String var1) throws TXJobException;

    public abstract Enumeration jobKeys();

    public abstract boolean startSweep() throws TXJobException;

    public abstract void endSweep() throws TXJobException;

    public abstract void cleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait(TXJob job) throws TXJobException {
        block9: {
            try {
                if (!this.inCluster) {
                    Vector<TXJob> vector = this.waitList;
                    synchronized (vector) {
                        this.waitList.addElement(job);
                    }
                    job.wait();
                    break block9;
                }
                Object object = this.jobLock;
                synchronized (object) {
                    this.releaseJob(job.getTid());
                    this.jobLock.wait(this.jobPendingWait);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotify(TXJob job) throws TXJobException {
        if (!this.inCluster) {
            job.notify();
            Vector<TXJob> vector = this.waitList;
            synchronized (vector) {
                this.waitList.removeElement(job);
            }
            return;
        }
        Object object = this.jobLock;
        synchronized (object) {
            this.jobLock.notifyAll();
            this.releaseJob(job.getTid());
        }
    }

    public boolean jobHasData(TXJob job) throws TXJobException {
        return this.getJobData(job) != null;
    }

    public void updateJob(TXJob job) throws TXJobException {
        this.updateJob(job, false);
    }

    public String getOwner() {
        return this.ownerHost + ":" + this.ownerPort;
    }

    public String getOwnerHost() {
        return this.ownerHost;
    }

    public String getOwnerPort() {
        return this.ownerPort;
    }

    private void dumpStore(IRepository repoSession, IRepoDirectory store, String msg) {
        System.out.println("DUMPING STORE (" + msg + ") =====>");
        try {
            String[] keys = store.getAllEntryKeys();
            for (int i = 0; i < keys.length; ++i) {
                System.out.println("*********Key=" + keys[i]);
            }
        }
        catch (Exception ee) {
            System.out.println("DUMPING STORE failed =====> " + ee.getLocalizedMessage());
        }
    }
}

