/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tx;

import com.wm.data.IData;
import com.wm.data.IDataPortable;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import com.wm.util.coder.Codable;

public class TXJob
implements Codable,
IDataPortable {
    public static final int TRXJOB0001 = 1;
    public static final int TRXJOB0002 = 2;
    public static final int TRXJOB0003 = 3;
    public static final int TRXJOB0004 = 4;
    public static final int TRXJOB0005 = 5;
    private static String self = "TXJob";
    public static final int NEW = 0;
    public static final int PENDING = 1;
    public static final int DONE = 2;
    public static final int FAILED = 3;
    public static final String[] statusMsg = new String[]{"NEW", "PENDING", "DONE", "FAILED"};
    public static final int UNKNOWN = -1;
    public static final String UNKNOWN_STR = "UNKNOWN";
    protected String tid;
    protected long ttl;
    protected long timeCreated;
    protected int status;
    protected long timeUpdated;
    protected IData data;
    protected String owner;
    protected boolean fileMode;
    protected String gInvokedServer;
    protected String gInvokedPort;

    public TXJob() {
    }

    public TXJob(String tid, long ttl) {
        this.tid = tid;
        this.ttl = ttl;
        this.status = 0;
        this.timeUpdated = this.timeCreated = System.currentTimeMillis();
        JournalLogger.logDebugPlus(3, 1, 63, this.getStatusMsg());
    }

    public void setFileMode() {
        this.fileMode = true;
    }

    public String getTid() {
        return this.tid;
    }

    public int getStatusVal() {
        return this.status;
    }

    public String getStatus() {
        return statusMsg[this.status];
    }

    public String getStatusMsg() {
        StringBuffer b = new StringBuffer(" tid=").append(this.tid);
        b.append(" (").append(statusMsg[this.status]).append(")");
        return b.toString();
    }

    public long getTtl() {
        return this.ttl;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public IData getData() {
        return this.data;
    }

    public void resetData() {
        this.data = null;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeUpdated() {
        return this.timeUpdated;
    }

    public void setInvokedServer(String server) {
        this.gInvokedServer = server;
    }

    public String getInvokedServer() {
        return this.gInvokedServer;
    }

    public void setInvokedPort(String port) {
        this.gInvokedPort = port;
    }

    public String getInvokedPort() {
        return this.gInvokedPort;
    }

    public boolean isNew() {
        return this.isStatus(0);
    }

    public boolean isPending() {
        return this.isStatus(1);
    }

    public boolean isMine(String owner) {
        if (this.owner == null) {
            return false;
        }
        return this.owner.equals(owner);
    }

    public boolean isDone() {
        return this.isStatus(2);
    }

    public boolean isFailed() {
        return this.isStatus(3);
    }

    public boolean isComplete() {
        return this.status == 3 || this.status == 2;
    }

    private boolean isStatus(int match) {
        return this.status == match;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.timeCreated > this.ttl;
    }

    public void start() {
        this.start(null);
    }

    public void start(String owner) {
        this.status = 1;
        this.owner = owner;
        this.timeUpdated = System.currentTimeMillis();
        JournalLogger.logDebugPlus(3, 2, 63, this.getStatusMsg());
    }

    public void reset() {
        this.status = 0;
        this.owner = null;
        this.timeUpdated = this.timeCreated = System.currentTimeMillis();
        JournalLogger.logDebugPlus(3, 3, 63, this.getStatusMsg());
    }

    public void done(IData data) {
        this.data = data;
        this.status = 2;
        this.owner = null;
        this.timeUpdated = System.currentTimeMillis();
        JournalLogger.logDebugPlus(3, 4, 63, this.getStatusMsg());
    }

    public void fail() {
        this.status = 3;
        this.owner = null;
        this.timeUpdated = System.currentTimeMillis();
        JournalLogger.logDebugPlus(3, 5, 63, this.getStatusMsg());
    }

    public String toString() {
        StringBuffer s = new StringBuffer("{ TXJob ").append(this.getStatusMsg());
        s.append(" }");
        return s.toString();
    }

    public String[] getValueKeys() {
        String[] s = new String[]{"tid", "ttl", "status", "timeCreated", "timeUpdated", "data", "owner", "server", "port"};
        return s;
    }

    public Object getValue(String key) {
        if (key.equals("tid")) {
            return this.tid;
        }
        if (key.equals("ttl")) {
            return new Long(this.ttl);
        }
        if (key.equals("status")) {
            return this.getStatus();
        }
        if (key.equals("timeCreated")) {
            return new Long(this.timeCreated);
        }
        if (key.equals("timeUpdated")) {
            return new Long(this.timeUpdated);
        }
        if (key.equals("data") && this.fileMode) {
            return this.data;
        }
        if (key.equals("owner")) {
            return this.owner;
        }
        if (key.equals("server")) {
            return this.gInvokedServer;
        }
        if (key.equals("port")) {
            return this.gInvokedPort;
        }
        return null;
    }

    public void setValue(String key, Object value) {
        if (key.equals("tid")) {
            this.tid = (String)value;
        } else if (key.equals("status")) {
            this.status = 0;
            if (value != null) {
                for (int i = 0; i < statusMsg.length; ++i) {
                    if (!value.equals(statusMsg[i])) continue;
                    this.status = i;
                }
            }
        } else if (key.equals("ttl") && value != null) {
            this.ttl = (Long)value;
        } else if (key.equals("timeCreated") && value != null) {
            this.timeCreated = (Long)value;
        } else if (key.equals("timeUpdated") && value != null) {
            this.timeUpdated = (Long)value;
        } else if (key.equals("data")) {
            this.data = (IData)value;
            if (this.data != null) {
                this.fileMode = true;
            }
        } else if (key.equals("owner")) {
            this.owner = (String)value;
        } else if (key.equals("server")) {
            this.gInvokedServer = (String)value;
        } else if (key.equals("port")) {
            this.gInvokedPort = (String)value;
        }
    }

    public void setValues(Values values) {
        String[] keys = this.getValueKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.setValue(keys[i], values.get(keys[i]));
        }
    }

    public Values getValues() {
        Values val = new Values();
        String[] keys = this.getValueKeys();
        for (int i = 0; i < keys.length; ++i) {
            val.put(keys[i], this.getValue(keys[i]));
        }
        return val;
    }

    public IData getAsData() {
        return this.getValues().getIData();
    }

    public void setFromData(IData data) {
        this.setValues(Values.use(data));
    }
}

