/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tspace;

import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.data.ValuesEmulator;
import com.wm.util.coder.IDataCodable;
import com.wm.util.tspace.BaseReservation;
import com.wm.util.tspace.ReservationAgent;
import com.wm.util.tspace.ReservationInitException;
import com.wm.util.tspace.ReservationInputStream;
import com.wm.util.tspace.ReservationOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class Reservation_FileImpl
extends BaseReservation
implements IDataCodable {
    static final String FILENAME_PREFIX = "DocRes";
    static final String FILENAME_SUFFIX = ".dat";
    protected String filename;
    protected OutputStream ostream;

    protected Reservation_FileImpl(long size, Date expirationDate, int startingRefCount) throws ReservationInitException {
        super(size, expirationDate, startingRefCount);
        ReservationAgent.current();
        String stloc = ReservationAgent.storageLocation;
        this.filename = stloc + this.id + FILENAME_PREFIX + FILENAME_SUFFIX;
        try {
            File location = new File(this.filename);
            if (location.exists()) {
                throw new ReservationInitException("File already exists");
            }
            this.ostream = new FileOutputStream(location);
        }
        catch (IOException ioe) {
            throw new ReservationInitException(ioe);
        }
    }

    public InputStream getInputStream() throws IOException {
        return new ReservationInputStream((InputStream)new FileInputStream(this.filename), this);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.ostream == null) {
            File location = new File(this.filename);
            this.ostream = location.exists() ? new FileOutputStream(this.filename, true) : new FileOutputStream(location);
        }
        return new ReservationOutputStream(this.ostream, this);
    }

    public URL getLocation() throws UnsupportedOperationException {
        URL loc = null;
        File location = new File(this.filename);
        if (location.exists()) {
            try {
                loc = location.toURL();
            }
            catch (MalformedURLException mue) {
                throw new UnsupportedOperationException(mue.getLocalizedMessage());
            }
        }
        return loc;
    }

    protected boolean releaseResource() {
        if (this.ostream != null) {
            try {
                this.ostream.close();
                this.ostream = null;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            File location = new File(this.filename);
            if (location.exists()) {
                boolean deletion = location.delete();
                if (!deletion) {
                    System.gc();
                    boolean deletion1 = location.delete();
                    return deletion1;
                }
                return deletion;
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static void releaseAllResources() {
        String s = ReservationAgent.Singleton.getStorageLocation();
        if (s == null) {
            return;
        }
        try {
            File parent = new File(s);
            File[] list = parent.listFiles();
            if (list == null || list.length == 0) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                String name;
                if (!list[i].isFile() || !(name = list[i].getName()).contains(FILENAME_PREFIX) || !name.endsWith(FILENAME_SUFFIX)) continue;
                list[i].delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.id;
    }

    public void setIData(IData idata) {
        IData data = this.setIDataUtil(idata);
        this.filename = ValuesEmulator.getString(data, "filename");
    }

    public IData getIData() {
        IData data = IDataFactory.create();
        ValuesEmulator.put(data, "filename", (Object)this.filename);
        return this.getIDataUtil(data);
    }
}

