/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tspace;

import com.wm.util.resources.UtilExceptionBundle;
import com.wm.util.tspace.Reservation_FileImpl;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;

public class ReservationOutputStream
extends BufferedOutputStream {
    protected static final String BundleName = "com.wm.util.resources.UtilExceptionBundle";
    protected Reservation_FileImpl rev;

    public ReservationOutputStream(OutputStream os, Reservation_FileImpl rev) {
        super(os);
        this.rev = rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte b) throws IOException {
        Reservation_FileImpl reservation_FileImpl = this.rev;
        synchronized (reservation_FileImpl) {
            super.write(b);
            ++this.rev.inUse;
            if (this.rev.inUse > this.rev.reserved) {
                throw new IOException(ReservationOutputStream.getStringFromBundle(UtilExceptionBundle.RESV_DATAINUSE_GT_DATARESERVED));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Reservation_FileImpl reservation_FileImpl = this.rev;
        synchronized (reservation_FileImpl) {
            super.write(b);
            ++this.rev.inUse;
            if (this.rev.inUse > this.rev.reserved) {
                throw new IOException(ReservationOutputStream.getStringFromBundle(UtilExceptionBundle.RESV_DATAINUSE_GT_DATARESERVED));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int offset, int len) throws IOException {
        Reservation_FileImpl reservation_FileImpl = this.rev;
        synchronized (reservation_FileImpl) {
            super.write(b, offset, len);
            this.rev.inUse += (long)len;
            if (this.rev.inUse > this.rev.reserved) {
                throw new IOException(ReservationOutputStream.getStringFromBundle(UtilExceptionBundle.RESV_DATAINUSE_GT_DATARESERVED));
            }
        }
    }

    protected static String getStringFromBundle(String key) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(BundleName);
            return bundle.getString(key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

