/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tspace;

import com.wm.util.tspace.BaseReservation;
import com.wm.util.tspace.InsufficientSpaceException;
import com.wm.util.tspace.Reservation;
import com.wm.util.tspace.ReservationException;
import com.wm.util.tspace.Reservation_FileImpl;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReservationAgent {
    static final String STORAGE_MAX_PROP = "watt.server.tspace.max";
    static final String STORAGE_LOCATION_PROP = "watt.server.tspace.location";
    static final String STORAGE_TIMETOLIVE_PROP = "watt.server.tspace.timeToLive";
    static final long STORAGE_MAX_DEFAULT = 0x3200000L;
    protected long storageMax;
    protected long storageInUse;
    protected int timeToLive = 0;
    protected static String storageLocation;
    public Hashtable reservationById;
    protected Object reservationLock = new Object();
    protected int entryId = 1;
    protected static boolean initialized;
    protected static ReservationAgent Singleton;

    public static synchronized ReservationAgent current() {
        if (Singleton == null) {
            return null;
        }
        try {
            Singleton.init();
        }
        catch (ReservationException e) {
            Singleton = null;
            e.printStackTrace();
        }
        return Singleton;
    }

    protected static boolean register(ReservationAgent agent) {
        if (Singleton == null) {
            Singleton = agent;
            try {
                Singleton.init();
                return true;
            }
            catch (ReservationException e) {
                Singleton = null;
                e.printStackTrace();
            }
        }
        return false;
    }

    protected ReservationAgent() {
        this.reservationById = new Hashtable();
    }

    protected synchronized void init() throws ReservationException {
        Number num;
        if (initialized) {
            return;
        }
        storageLocation = System.getProperty(STORAGE_LOCATION_PROP);
        if (storageLocation == null || storageLocation.length() == 0) {
            storageLocation = System.getProperty("java.io.tmpdir");
        }
        storageLocation = storageLocation.replaceAll("\\\\:", ":");
        storageLocation = storageLocation.replace('\\', File.separatorChar);
        if (File.separatorChar != (storageLocation = storageLocation.replace('/', File.separatorChar)).charAt(storageLocation.length() - 1)) {
            storageLocation = storageLocation + File.separatorChar;
        }
        try {
            File parent = new File(storageLocation);
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        catch (Exception e) {
            throw new ReservationException(e);
        }
        String s = System.getProperty(STORAGE_MAX_PROP);
        if (s != null) {
            try {
                num = NumberFormat.getInstance().parse(s);
                this.storageMax = num.longValue();
            }
            catch (ParseException pe) {
                this.storageMax = 0x3200000L;
            }
        } else {
            this.storageMax = 0x3200000L;
        }
        Reservation_FileImpl.releaseAllResources();
        s = System.getProperty(STORAGE_TIMETOLIVE_PROP);
        if (s != null) {
            try {
                num = NumberFormat.getInstance().parse(s);
                this.timeToLive = num.intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        initialized = true;
    }

    public Reservation createReservation(long size) throws ReservationException {
        return this.createReservation(size, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Reservation createReservation(long size, int startingRefCount) throws ReservationException {
        Reservation_FileImpl reservation;
        Object object = this.reservationLock;
        synchronized (object) {
            this.removeObsolete();
            if (this.storageMax < this.storageInUse + size) {
                throw new InsufficientSpaceException();
            }
            reservation = new Reservation_FileImpl(size, new Date(new Date().getTime() + (long)this.timeToLive), startingRefCount);
            this.storageInUse += size;
            this.reservationById.put(reservation.id, reservation);
        }
        return reservation;
    }

    public Reservation getReservation(String reservationId) {
        return (Reservation)this.reservationById.get(reservationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeReservation(Reservation reservation, long size) throws ReservationException {
        if (reservation == null) {
            throw new NullPointerException("reservation");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("size");
        }
        Object object = this.reservationLock;
        synchronized (object) {
            long original = reservation.getReservationSize();
            long required = this.storageInUse - original + size;
            if (this.storageMax < required) {
                throw new InsufficientSpaceException();
            }
            ((BaseReservation)reservation).setReservationSize(size);
            this.storageInUse = this.storageInUse - original + size;
        }
    }

    public void addReference(String reservationId) {
        BaseReservation res = (BaseReservation)this.reservationById.get(reservationId);
        if (res != null) {
            res.addReference();
        }
    }

    public boolean removeReference(String reservationId) {
        BaseReservation res = (BaseReservation)this.reservationById.get(reservationId);
        if (res != null) {
            res.removeReference();
            boolean result = res.remove();
            if (result) {
                this.reservationById.remove(reservationId);
                this.storageInUse -= res.reserved;
                return true;
            }
        }
        return false;
    }

    public void removeObsolete() {
        Enumeration e = this.reservationById.elements();
        while (e.hasMoreElements()) {
            BaseReservation res = (BaseReservation)e.nextElement();
            if (!res.remove()) continue;
            this.reservationById.remove(res.id);
            this.storageInUse -= res.reserved;
        }
    }

    public long getStorageInUse() {
        return this.storageInUse;
    }

    public long getStorageMax() {
        return this.storageMax;
    }

    public String getStorageLocation() {
        return storageLocation;
    }

    public int getReservationCount() {
        return this.reservationById.size();
    }

    public boolean isInitialized() {
        return initialized;
    }

    protected int getEntryID() {
        return this.entryId++;
    }

    static {
        initialized = false;
        Singleton = null;
    }
}

