/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tspace;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.ValuesEmulator;
import com.wm.util.tspace.InsufficientSpaceException;
import com.wm.util.tspace.Reservation;
import com.wm.util.tspace.ReservationAgent;
import com.wm.util.tspace.ReservationException;
import com.wm.util.tspace.ReservationInitException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;

public abstract class BaseReservation
implements Reservation {
    protected String id;
    protected long reserved;
    protected long inUse;
    protected int refCount;
    protected Date expiration;

    protected BaseReservation(long size, Date expirationDate, int startingRefCount) throws ReservationInitException {
        this.refCount = startingRefCount;
        this.id = Integer.toString(ReservationAgent.current().getEntryID());
        this.reserved = size;
        this.expiration = expirationDate;
    }

    public String getSoftReference() {
        return this.id;
    }

    public long getReservationSize() {
        return this.reserved;
    }

    protected void setReservationSize(long size) throws ReservationException {
        this.reserved = size;
        if (this.inUse > this.reserved) {
            throw new InsufficientSpaceException();
        }
    }

    public long getUsed() {
        return this.inUse;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract URL getLocation() throws UnsupportedOperationException;

    protected void addReference() {
        ++this.refCount;
    }

    protected void removeReference() {
        --this.refCount;
    }

    protected boolean remove() {
        Date now = new Date();
        if (this.refCount < 1 && (this.expiration == null || this.expiration.before(now))) {
            boolean deleted = this.releaseResource();
            return deleted;
        }
        return false;
    }

    protected abstract boolean releaseResource() throws UnsupportedOperationException;

    protected IData setIDataUtil(IData idata) {
        IData data = (IData)ValuesEmulator.get(idata, "data");
        if (data == null) {
            return IDataFactory.create();
        }
        IDataCursor cursor = data.getCursor();
        if (cursor.first("inUse")) {
            this.inUse = Long.parseLong((String)cursor.getValue());
        }
        try {
            if (cursor.first("reserved")) {
                this.setReservationSize(Long.parseLong((String)cursor.getValue()));
            }
        }
        catch (ReservationException re) {
            throw new IllegalStateException(re.getLocalizedMessage());
        }
        this.id = Integer.toString(ReservationAgent.current().getEntryID());
        this.refCount = 0;
        cursor.destroy();
        return data;
    }

    protected IData getIDataUtil(IData data) {
        IData idata = IDataFactory.create(1);
        IDataCursor cursor = data.getCursor();
        cursor.insertAfter("inUse", Long.toString(this.inUse));
        cursor.insertAfter("reserved", Long.toString(this.reserved));
        ValuesEmulator.put(idata, "data", (Object)data);
        return idata;
    }
}

