/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.text;

import java.security.SecureRandom;

public class UUID {
    private static long node_id = 0L;
    private static short clock_seq = 0;
    private static final long TIMEOFFSET = 122192928000000000L;
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static ThreadLocal<SecureRandom> tlocal = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            SecureRandom sr = null;
            try {
                sr = SecureRandom.getInstance("FIPS186_2usingSHA1", "Entrust");
            }
            catch (Exception e) {
                sr = new SecureRandom();
            }
            return sr;
        }
    };
    private static byte[] nodeByteArray = new byte[6];

    public static String generate() {
        StringBuffer sb = new StringBuffer();
        long time = System.currentTimeMillis() * 10000L + 122192928000000000L;
        int time_low = (int)(time & 0xFFFFFFFFFFFFFFFFL);
        short time_mid = (short)(time >>> 32 & 0xFFFFL);
        short time_hi_and_version = (short)(time >> 48 & 0xFFFL | 0x1000L);
        short seq = UUID.nextSeq();
        node_id = 0L;
        UUID.getSecureRandom().nextBytes(nodeByteArray);
        for (int i = 0; i < nodeByteArray.length; ++i) {
            node_id |= ((long)nodeByteArray[i] & 0xFFL) << i * 8;
        }
        UUID.append(sb, time_low);
        UUID.append(sb, time_mid);
        UUID.append(sb, time_hi_and_version);
        UUID.append(sb, seq);
        UUID.append6(sb, node_id |= 0x800000000000L);
        return sb.toString();
    }

    public static String generateFormatted() {
        StringBuffer sb = new StringBuffer();
        long time = System.currentTimeMillis() * 10000L + 122192928000000000L;
        int time_low = (int)(time & 0xFFFFFFFFFFFFFFFFL);
        short time_mid = (short)(time >>> 32 & 0xFFFFL);
        short time_hi_and_version = (short)(time >> 48 & 0xFFFL | 0x1000L);
        short seq = UUID.nextSeq();
        UUID.append(sb, time_low);
        sb.append("-");
        UUID.append(sb, time_mid);
        sb.append("-");
        UUID.append(sb, time_hi_and_version);
        sb.append("-");
        UUID.append(sb, seq);
        sb.append("-");
        UUID.append6(sb, node_id);
        return sb.toString();
    }

    private static synchronized short nextSeq() {
        clock_seq = (short)(clock_seq + 1 & 0x3FFF | 0x8000);
        return clock_seq;
    }

    private static void append(StringBuffer sb, int n) {
        byte b = (byte)(n >> 24);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)(n >> 16);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)(n >> 8);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)n;
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
    }

    private static void append(StringBuffer sb, short n) {
        byte b = (byte)(n >> 8);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)n;
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
    }

    private static void append6(StringBuffer sb, long n) {
        byte b = (byte)(n >> 40);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)(n >> 32);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)(n >> 24);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)(n >> 16);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)(n >> 8);
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
        b = (byte)n;
        sb.append(hexChar[b >> 4 & 0xF]);
        sb.append(hexChar[b & 0xF]);
    }

    private static SecureRandom getSecureRandom() {
        return tlocal.get();
    }

    public static void main(String[] args) {
        int loops = 100000;
        System.out.println("sample1: " + UUID.generateFormatted());
        System.out.println("sample2: " + UUID.generateFormatted());
        System.out.println("sample3: " + UUID.generateFormatted());
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("sample4: " + UUID.generateFormatted());
        System.out.println("sample5: " + UUID.generateFormatted());
        System.out.println("sample6: " + UUID.generateFormatted());
        long time = System.currentTimeMillis();
        for (int i = 0; i < loops; ++i) {
            String s = UUID.generateFormatted();
        }
        time = System.currentTimeMillis() - time;
        System.out.println("generated " + loops + " uuid's in " + time + " ms");
    }

    static {
        byte[] b = new byte[2];
        UUID.getSecureRandom().nextBytes(b);
        for (int i = 0; i < b.length; ++i) {
            clock_seq = (short)((long)clock_seq | ((long)b[i] & 0xFFL) << i * 8);
        }
        clock_seq = (short)(clock_seq & 0x3FFF);
        clock_seq = (short)(clock_seq | 0x8000);
    }
}

