/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.text;

import com.wm.util.BasisException;
import com.wm.util.io.ByteOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Strings {
    static Hashtable encodingMap;
    private static boolean useColor;
    public static int CYAN;
    public static int PURPLE;
    public static int BLUE;
    public static int YELLOW;
    public static int GREEN;
    public static int RED;
    public static int BLACK;
    public static int WHITE;
    public static int BRIGHT;
    public static int NORMAL;

    public static String getJavaEncodingName(String name) {
        String ret;
        if (name == null || name.length() == 0 || name.equalsIgnoreCase("autodetect")) {
            ret = null;
        } else {
            ret = (String)encodingMap.get(name.toUpperCase());
            if (ret == null) {
                ret = name;
            }
        }
        return ret;
    }

    public static String pad(char pc, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(pc);
        }
        return sb.toString();
    }

    public static String pad(String s, char pc, int len) {
        return Strings.rpad(s, pc, len);
    }

    public static String lpad(String s, char pc, int len) {
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        StringBuffer sb = new StringBuffer();
        int diff = len - s.length();
        for (int i = 0; i < diff; ++i) {
            sb.append(pc);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String rpad(String s, char pc, int len) {
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        StringBuffer sb = new StringBuffer(s);
        int diff = len - s.length();
        for (int i = 0; i < diff; ++i) {
            sb.append(pc);
        }
        return sb.toString();
    }

    public static String cat(String s1, String s2) {
        int s1l = s1.length();
        int s2l = s2.length();
        char[] c = new char[s1l + s2l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        char[] c = new char[s1l + s2l + s3l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        char[] c = new char[s1l + s2l + s3l + s4l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4, String s5) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        int s5l = s5.length();
        char[] c = new char[s1l + s2l + s3l + s4l + s5l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        s5.getChars(0, s5l, c, s1l + s2l + s3l + s4l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4, String s5, String s6) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        int s5l = s5.length();
        int s6l = s6.length();
        char[] c = new char[s1l + s2l + s3l + s4l + s5l + s6l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        s5.getChars(0, s5l, c, s1l + s2l + s3l + s4l);
        s6.getChars(0, s6l, c, s1l + s2l + s3l + s4l + s5l);
        return new String(c);
    }

    public static String cat(String s1, String s2, String s3, String s4, String s5, String s6, String s7) {
        int s1l = s1.length();
        int s2l = s2.length();
        int s3l = s3.length();
        int s4l = s4.length();
        int s5l = s5.length();
        int s6l = s6.length();
        int s7l = s7.length();
        char[] c = new char[s1l + s2l + s3l + s4l + s5l + s6l + s7l];
        s1.getChars(0, s1l, c, 0);
        s2.getChars(0, s2l, c, s1l);
        s3.getChars(0, s3l, c, s1l + s2l);
        s4.getChars(0, s4l, c, s1l + s2l + s3l);
        s5.getChars(0, s5l, c, s1l + s2l + s3l + s4l);
        s6.getChars(0, s6l, c, s1l + s2l + s3l + s4l + s5l);
        s7.getChars(0, s7l, c, s1l + s2l + s3l + s4l + s5l + s6l);
        return new String(c);
    }

    public static String replace(String str, String match, String replace) {
        int last = 0;
        int idx = 0;
        int len = str.length();
        int mlen = match.length();
        StringBuffer sb = new StringBuffer(len);
        while (true) {
            if ((idx = str.indexOf(match, idx)) < 0) break;
            if (idx - last > 0) {
                sb.append(str.substring(last, idx));
            }
            sb.append(replace);
            last = idx += mlen;
        }
        sb.append(str.substring(last));
        return sb.toString();
    }

    public static String[] sort(String[] s) {
        Arrays.sort(s);
        return s;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String getErrorText(Throwable err, boolean compact) {
        if (err == null) {
            return "";
        }
        String lsep = System.getProperty("line.separator");
        ByteOutputBuffer b = new ByteOutputBuffer();
        PrintWriter ps = new PrintWriter(b);
        err.printStackTrace(ps);
        ps.flush();
        String msg = new String(b.toByteArray());
        if (!compact) {
            if (err instanceof BasisException && (err = ((BasisException)err).getWrappedException()) != null) {
                msg = msg + "(--- wrapped ---)" + lsep + Strings.getErrorText(err, compact);
            }
            return msg;
        }
        StringTokenizer st = new StringTokenizer(msg, "\n");
        st.nextToken();
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken().trim().substring(3) + System.getProperty("line.separator"));
        }
        if (err instanceof BasisException && (err = ((BasisException)err).getWrappedException()) != null) {
            sb.append(lsep);
            sb.append("(--- wrapped ---)");
            sb.append(lsep);
            sb.append(Strings.getErrorText(err, compact));
        }
        return sb.toString();
    }

    public static void writeLow(OutputStream os, String s) throws IOException {
        int sl = s.length();
        char[] c = new char[sl];
        s.getChars(0, sl, c, 0);
        byte[] b = new byte[sl];
        for (int i = 0; i < sl; ++i) {
            b[i] = (byte)(c[i] & 0xFF);
        }
        os.write(b);
    }

    public static String[] getCSL(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Vector<String> l = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String next = st.nextToken().trim();
            l.addElement(next);
        }
        Object[] arr = new String[l.size()];
        l.copyInto(arr);
        return arr;
    }

    public static byte[] getBytesUTF8(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getStringUTF8(byte[] b) {
        try {
            return new String(b, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static boolean supportsColor() {
        return useColor;
    }

    public static String color(Object s, int mode, int color) {
        return Strings.color(s, mode, color, false);
    }

    public static String color(Object s, int mode, int color, boolean nested) {
        if (!useColor) {
            return s.toString();
        }
        if (nested) {
            return "\u001b[" + mode + ";" + color + "m" + s;
        }
        return "\u001b[" + mode + ";" + color + "m" + s + "\u001b[0m";
    }

    public static String cyan(Object s) {
        return Strings.color(s, NORMAL, CYAN);
    }

    public static String purple(Object s) {
        return Strings.color(s, NORMAL, PURPLE);
    }

    public static String blue(Object s) {
        return Strings.color(s, NORMAL, BLUE);
    }

    public static String yellow(Object s) {
        return Strings.color(s, NORMAL, YELLOW);
    }

    public static String green(Object s) {
        return Strings.color(s, NORMAL, GREEN);
    }

    public static String red(Object s) {
        return Strings.color(s, NORMAL, RED);
    }

    public static String black(Object s) {
        return Strings.color(s, NORMAL, BLACK);
    }

    public static String white(Object s) {
        return Strings.color(s, NORMAL, WHITE);
    }

    public static String CYAN(Object s) {
        return Strings.color(s, BRIGHT, CYAN);
    }

    public static String PURPLE(Object s) {
        return Strings.color(s, BRIGHT, PURPLE);
    }

    public static String BLUE(Object s) {
        return Strings.color(s, BRIGHT, BLUE);
    }

    public static String YELLOW(Object s) {
        return Strings.color(s, BRIGHT, YELLOW);
    }

    public static String GREEN(Object s) {
        return Strings.color(s, BRIGHT, GREEN);
    }

    public static String RED(Object s) {
        return Strings.color(s, BRIGHT, RED);
    }

    public static String BLACK(Object s) {
        return Strings.color(s, BRIGHT, BLACK);
    }

    public static String WHITE(Object s) {
        return Strings.color(s, BRIGHT, WHITE);
    }

    public static String getShortClassName(Object o) {
        return Strings.getShortClassName(o.getClass());
    }

    public static String getShortClassName(Class c) {
        String nm = c.getName();
        return nm.substring(Math.max(nm.lastIndexOf("."), nm.lastIndexOf("$")) + 1);
    }

    static {
        String[] table = new String[]{"UTF-8", "UTF8", "UTF8", "UTF8", "ASCII", "ASCII", "ISO_8859-1", "8859_1", "ISO8859_1", "8859_1", "ISO_8859-2", "ISO8859_2", "ISO_8859-3", "ISO8859_3", "ISO_8859-4", "ISO8859_4", "ISO_8859-5", "ISO8859_5", "ISO_8859-6", "ISO8859_6", "ISO_8859-7", "ISO8859_7", "ISO_8859-8", "ISO8859_8", "ISO_8859-9", "ISO8859_9", "ISO-8859-1", "ISO8859_1", "ISO-8859-2", "ISO8859_2", "ISO-8859-3", "ISO8859_3", "ISO-8859-4", "ISO8859_4", "ISO-8859-5", "ISO8859_5", "ISO-8859-6", "ISO8859_6", "ISO-8859-7", "ISO8859_7", "ISO-8859-8", "ISO8859_8", "ISO-8859-9", "ISO8859_9", "CP1252", "Cp1252", "BIG5", "Big5", "BIG-5", "Big5", "GB2312", "GBK", "SHIFT-JIS", "SJIS", "EUC-JP", "EUC_JP", "EUC-TW", "EUC_TW", "ISO-2022-JP", "ISO2022JP", "ISO-2022-KR", "ISO2022KR", "ISO-2022-CN", "ISO2022CN", "GBK", "GBK", "EUC-KR", "EUC_KR", "EUC-CN", "EUC_CN", "JOHAB", "Johab", "IBM037", "Cp037"};
        encodingMap = new Hashtable(table.length / 2, 1.0f);
        for (int i = 0; i < table.length; i += 2) {
            encodingMap.put(table[i], table[i + 1]);
        }
        useColor = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
        CYAN = 36;
        PURPLE = 35;
        BLUE = 34;
        YELLOW = 33;
        GREEN = 32;
        RED = 31;
        BLACK = 30;
        WHITE = 29;
        BRIGHT = 1;
        NORMAL = 0;
    }
}

