/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IData;
import com.wm.data.ValuesEmulator;
import com.wm.lang.xml.token.EntityTable;
import com.wm.net.EncodeURL;
import com.wm.util.Base64;
import com.wm.util.Config;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.Trace;
import com.wm.util.coder.Codable;
import com.wm.util.template.EmptyToken;
import com.wm.util.template.Reporter;
import com.wm.util.xform.DateTimeDT;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class ValueToken
extends EmptyToken {
    public static final int NONE = 0;
    public static final int URL_ENCODE = 1;
    public static final int URL_DECODE = 2;
    public static final int BASE64_ENCODE = 3;
    public static final int BASE64_DECODE = 4;
    public static final int XML_ENCODE = 5;
    public static final int XML_ATTR_ENCODE = 8;
    public static final int XML_DECODE = 6;
    public static final int HTML_DECODE = 7;
    public static final int B64UTF8_ENCODE = 9;
    public static final int B64UTF8_DECODE = 10;
    public static final int UNICODE_ENCODE = 11;
    public static final int CODE_ENCODE = 12;
    public static final int LOCALIZE_ENCODE = 13;
    public static final int HTML_ATTR_ENCODE = 14;
    public static final int HTML_ENCODE = 15;
    public static final String[] ENCODING_NAME = new String[]{"none", "url", "url", "b64", "b64", "xml", "xmlattr", "xml", "html", "b64utf8", "b64utf8", "unicode", "code", "localize"};
    int index;
    String name;
    String nullval;
    String emptyval;
    int wmEncoding;
    int decShift;
    int decShow;

    public ValueToken(String args) {
        super(args);
    }

    public ValueToken(String name, int index, String nullval, String emptyval, int wmEncoding, int decShift, int decShow) {
        this.name = name;
        this.index = index;
        this.nullval = nullval;
        this.emptyval = emptyval;
        this.wmEncoding = wmEncoding;
        this.decShift = decShift;
        this.decShow = decShow;
    }

    public void init() {
        super.init();
        this.index = -1;
        this.nullval = null;
        this.emptyval = null;
        this.wmEncoding = -1;
    }

    public boolean processArg(String value, int idx) {
        if (super.processArg(value, this.index)) {
            return true;
        }
        if (value.equals("none")) {
            this.wmEncoding = 0;
        } else if (value.equals("-urlencode")) {
            this.wmEncoding = 1;
        } else if (value.equals("-u")) {
            this.wmEncoding = 11;
        } else if (value.equals("-code")) {
            this.wmEncoding = 12;
        } else if (value.equals("-localize")) {
            this.wmEncoding = 13;
        } else if (value.startsWith("encode(") && value.endsWith(")")) {
            String code = value.substring(7, value.length() - 1);
            if (code.equals("b64")) {
                this.wmEncoding = 3;
            } else if (code.equals("b64utf8")) {
                this.wmEncoding = 9;
            } else if (code.equals("url")) {
                this.wmEncoding = 1;
            } else if (code.equals("xmlattr")) {
                this.wmEncoding = 8;
            } else if (code.equals("htmlattr")) {
                this.wmEncoding = 14;
            } else if (code.equals("xml")) {
                this.wmEncoding = 5;
            } else if (code.equals("code")) {
                this.wmEncoding = 12;
            } else if (code.equals("html")) {
                this.wmEncoding = 15;
            }
        } else if (value.startsWith("decode(") && value.endsWith(")")) {
            String code = value.substring(7, value.length() - 1);
            if (code.equals("b64")) {
                this.wmEncoding = 4;
            } else if (code.equals("b64utf8")) {
                this.wmEncoding = 10;
            } else if (code.equals("url")) {
                this.wmEncoding = 2;
            } else if (code.equals("xml")) {
                this.wmEncoding = 6;
            } else if (code.equals("html")) {
                this.wmEncoding = 7;
            }
        } else if (value.startsWith("decimal(") && value.endsWith(")")) {
            String args = value.substring(8, value.length() - 1);
            StringTokenizer st = new StringTokenizer(args, ",");
            try {
                if (st.countTokens() == 2) {
                    this.decShift = Integer.parseInt(st.nextToken());
                    this.decShow = Integer.parseInt(st.nextToken());
                }
            }
            catch (Exception e) {}
        } else if (value.indexOf("null=") == 0 && value.length() > 5) {
            this.nullval = value.substring(5);
        } else if (value.indexOf("empty=") == 0 && value.length() > 6) {
            this.emptyval = value.substring(6);
            if (this.nullval == null) {
                this.nullval = this.emptyval;
            }
        } else if (value.indexOf("index=") == 0 && value.length() > 6) {
            this.index = Integer.parseInt(value.substring(6));
        } else {
            this.name = value;
        }
        return true;
    }

    public void eval(Reporter r) {
        this.eval(r, null);
    }

    public void eval(Reporter r, String encoding) {
        Object o = null;
        if (this.name == null) {
            if (JournalLogger.isLogEnabledDebugPlus(6, 11, 72)) {
                JournalLogger.logDebugPlus(6, 11, 72, r.key);
            }
            return;
        }
        o = r.get(this.name);
        if (o == null && r.currentCodable != null) {
            o = ValuesEmulator.get(r.currentCodable, this.name);
        }
        if (o == null) {
            if (this.name.equals("$date")) {
                r.appendDate();
            } else if (this.name.equals("$host")) {
                r.appendHost();
            } else if (this.name.equals("$lastmod")) {
                r.appendLastMod();
            } else if (this.nullval != null) {
                r.append(this.nullval);
            }
        } else {
            this.eval(r, o, encoding);
        }
    }

    public void eval(Reporter r, Object o, String encoding) {
        if (o instanceof String[]) {
            this.evalStringArray(r, (String[])o, encoding);
        } else if (o instanceof Object[]) {
            this.evalObjectArray(r, (Object[])o, encoding);
        } else {
            this.evalObject(r, o, encoding);
        }
    }

    public void evalObject(Reporter r, Object o, String encoding) {
        String out = "";
        String tempname = "";
        String tempobj = "";
        String enableSecuredUrlRedirection = Config.getProperty("true", "watt.core.template.enableSecureUrlRedirection");
        if (enableSecuredUrlRedirection.equalsIgnoreCase("true")) {
            if (this.name != null) {
                tempname = this.name.toLowerCase();
            }
            if (o != null) {
                tempobj = o.toString().toLowerCase();
            }
            if (tempname != null && (tempname.equalsIgnoreCase("url") || tempname.equalsIgnoreCase("returnurl"))) {
                if (tempobj != null && (tempobj.startsWith("http:") || tempobj.startsWith("//") || tempobj.startsWith("https:") || tempobj.startsWith("www.") || tempobj.startsWith("javascript"))) {
                    out = "error.dsp?data=" + (String)o;
                    o = out;
                } else if (o != null && o.toString().startsWith("ValidConstToken")) {
                    tempobj = o.toString().replaceFirst("ValidConstToken", "");
                    o = tempobj;
                }
            }
        }
        r.append(this.getEncoded(o, encoding));
    }

    public void evalString(Reporter r, String s, String encoding) {
        r.append(this.getEncoded(s, encoding));
    }

    public void evalStringArray(Reporter r, String[] ary, String encoding) {
        if (this.index >= 0 && this.index < ary.length) {
            this.evalString(r, ary[this.index], encoding);
        } else if (this.index == -1 && r.INDEX >= 0 && r.INDEX < ary.length) {
            this.evalString(r, ary[r.INDEX], encoding);
        }
    }

    public void evalObjectArray(Reporter r, Object[] ary, String encoding) {
        if (this.index >= 0 && this.index < ary.length && ary[this.index] != null) {
            this.evalString(r, ary[this.index].toString(), encoding);
        } else if (this.index == -1 && r.INDEX >= 0 && r.INDEX < ary.length && ary[r.INDEX] != null) {
            this.evalString(r, ary[r.INDEX].toString(), encoding);
        }
    }

    public String getEncoded(Object obj, String encoding) {
        return this.getEncoded(obj, encoding, null);
    }

    public String getEncoded(Object obj, String encoding, Locale locale) {
        String myVal;
        block31: {
            String val = null;
            if (obj != null) {
                val = obj instanceof String ? (String)obj : obj.toString();
            }
            myVal = "";
            if (val != null) {
                myVal = val;
            }
            if (this.emptyval != null && myVal.trim().length() == 0) {
                myVal = this.emptyval;
            } else if (this.nullval != null && val == null) {
                myVal = this.nullval;
            }
            switch (this.wmEncoding) {
                case 0: {
                    break;
                }
                case 1: {
                    myVal = EncodeURL.encode(myVal);
                    break;
                }
                case 2: {
                    myVal = EncodeURL.decode(myVal);
                    break;
                }
                case 3: {
                    myVal = Base64.encode(myVal);
                    break;
                }
                case 4: {
                    myVal = Base64.decode(myVal);
                    break;
                }
                case 9: {
                    myVal = Base64.encodeUTF8(myVal);
                    break;
                }
                case 10: {
                    myVal = Base64.decodeUTF8(myVal);
                    break;
                }
                case 5: {
                    myVal = EntityTable.getXmlString(myVal, false);
                    break;
                }
                case 8: {
                    myVal = EntityTable.getXmlString(myVal, true);
                    break;
                }
                case 14: {
                    myVal = EntityTable.getXmlString(myVal, true);
                }
                case 12: {
                    char[] buffer = myVal.toCharArray();
                    int len = buffer.length;
                    StringBuffer sb = new StringBuffer(len * 2);
                    for (int i = 0; i < len; ++i) {
                        switch (buffer[i]) {
                            case '\"': 
                            case '\'': 
                            case '\\': {
                                sb.append('\\');
                            }
                        }
                        sb.append(buffer[i]);
                    }
                    myVal = sb.toString();
                    break;
                }
                case 11: {
                    myVal = EncUtil.encodeUnicode(myVal);
                    break;
                }
                case 13: {
                    if (obj == null) break;
                    myVal = this.displayObject(obj, locale);
                    break;
                }
                case 15: {
                    myVal = EncUtil.filterHTML(myVal);
                    break;
                }
                default: {
                    String enableFilterHtmlByDefault = Config.getProperty("true", "watt.core.template.enableFilterHtml");
                    if (!enableFilterHtmlByDefault.equalsIgnoreCase("true")) break;
                    myVal = EncUtil.filterHTML(myVal);
                }
            }
            if (this.decShift != 0 || this.decShow != 0) {
                try {
                    Double d = new Double(myVal);
                    double dd = d;
                    if (this.decShift != 0) {
                        dd *= Math.pow(10.0, this.decShift);
                    }
                    myVal = Math.abs(dd) >= 9999999.5 ? Long.toString((long)dd) + ".0" : Double.toString(dd);
                    int idx = myVal.indexOf(46);
                    if (this.decShow != 0) {
                        idx += this.decShow > 0 ? this.decShow + 1 : this.decShow - 1;
                    }
                    if (idx >= 0) {
                        myVal = myVal.substring(0, idx);
                    }
                }
                catch (Exception e) {
                    if (!JournalLogger.isLogEnabledDebugPlus(5, 12, 72)) break block31;
                    JournalLogger.logDebugPlus(5, 12, 72, e);
                }
            }
        }
        return myVal;
    }

    public void evalLoopValue(Reporter r, String encoding, String loopVar, boolean struct) {
        Object v;
        if (this.name != null) {
            v = r.get(this.name);
            if (v == null && struct) {
                Object o2 = r.get(r.key);
                if (o2 instanceof Codable) {
                    v = ((Codable)o2).getValue(this.name);
                } else if (o2 instanceof IData) {
                    v = ValuesEmulator.get((IData)o2, this.name);
                }
            }
        } else {
            v = struct ? (r.keyCursor != null && r.keyCursor.getKey().equals(r.key) ? r.keyCursor.getValue() : r.get(r.key)) : r.get(loopVar);
        }
        if (v == null) {
            return;
        }
        if (v instanceof String) {
            r.append(this.getEncoded((String)v, encoding));
        } else if (v instanceof String[]) {
            if (r.INDEX < ((String[])v).length && r.INDEX > -1) {
                r.append(this.getEncoded(((String[])v)[r.INDEX], encoding));
            }
        } else if (v instanceof String[][] && r.INDEX > -1) {
            this.eval(r, ((String[][])v)[r.INDEX], encoding);
        } else if (v instanceof Integer) {
            r.append(String.valueOf(v));
        } else if (v instanceof Object[]) {
            Object q;
            if (r.INDEX < ((Object[])v).length && r.INDEX > -1 && (q = ((Object[])v)[r.INDEX]) != null) {
                r.append(this.getEncoded(q, encoding, r.locale));
            }
        } else {
            r.append(this.getEncoded(v, encoding, r.locale));
        }
    }

    protected String displayObject(Object o, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Date) {
            return DateTimeDT.convertDate((Date)o, Config.getProperty(Trace.DEFAULT_DATE_FORMAT, "watt.server.dateStampFmt"), null, locale);
        }
        return o.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getNullVal() {
        return this.nullval;
    }

    public String getEmptyVal() {
        return this.emptyval;
    }

    public int getEncoding() {
        return this.wmEncoding;
    }

    public int getDecShift() {
        return this.decShift;
    }

    public int getDecShow() {
        return this.decShow;
    }
}

