/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.util.template.CaseToken;
import com.wm.util.template.CommentToken;
import com.wm.util.template.EndToken;
import com.wm.util.template.IfVarElseToken;
import com.wm.util.template.IfVarToken;
import com.wm.util.template.IncludeToken;
import com.wm.util.template.InvokeToken;
import com.wm.util.template.LoopSepToken;
import com.wm.util.template.LoopToken;
import com.wm.util.template.NewlineToken;
import com.wm.util.template.OnErrorToken;
import com.wm.util.template.RenameToken;
import com.wm.util.template.ScopeToken;
import com.wm.util.template.SwitchToken;
import com.wm.util.template.SysvarToken;
import com.wm.util.template.TemplateToken;
import com.wm.util.template.ValidConstToken;
import com.wm.util.template.ValueToken;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;

public class TemplateTokenizer {
    int ptr = 0;
    String buffer;
    long lastmod;
    boolean done;
    boolean loopEol;
    TemplateToken lastToken;
    TemplateToken rootToken;

    private TemplateTokenizer(String buffer, long lastmod) {
        this.buffer = buffer;
        this.lastmod = lastmod;
        this.done = false;
        this.loopEol = false;
        this.lastToken = null;
        this.rootToken = null;
    }

    public static TemplateToken newRootToken(String buffer, long lastmod) {
        return new TemplateTokenizer(buffer, lastmod).getRootToken();
    }

    private Object collect(int ptr, int pos) {
        String o = this.buffer.substring(ptr, pos);
        this.ptr = pos;
        return o;
    }

    private boolean createToken(String name, String args) {
        if (name == null || name.length() > 15) {
            return false;
        }
        if (name.startsWith("end")) {
            return this.tokenAdded(new EndToken(name, args));
        }
        if (name.equals("value")) {
            return this.tokenAdded(new ValueToken(args));
        }
        if (name.equals("include")) {
            return this.tokenAdded(new IncludeToken(args));
        }
        if (name.equals("loop")) {
            return this.tokenAdded(new LoopToken(args));
        }
        if (name.equals("loopsep")) {
            return this.tokenAdded(new LoopSepToken(args));
        }
        if (name.equals("ifvar")) {
            return this.tokenAdded(new IfVarToken(args));
        }
        if (name.equals("else")) {
            return this.tokenAdded(new IfVarElseToken(args));
        }
        if (name.equals("nl")) {
            return this.tokenAdded(new NewlineToken(args));
        }
        if (name.equals("scope")) {
            return this.tokenAdded(new ScopeToken(args));
        }
        if (name.equals("invoke")) {
            return this.tokenAdded(new InvokeToken(args));
        }
        if (name.equals("switch")) {
            return this.tokenAdded(new SwitchToken(args));
        }
        if (name.equals("case")) {
            return this.tokenAdded(new CaseToken(args));
        }
        if (name.equals("rename")) {
            return this.tokenAdded(new RenameToken(args));
        }
        if (name.equals("onerror")) {
            return this.tokenAdded(new OnErrorToken(args));
        }
        if (name.equals("sysvar")) {
            return this.tokenAdded(new SysvarToken(args));
        }
        if (name.equals("comment")) {
            return this.tokenAdded(new CommentToken(args));
        }
        if (name.equals("validConst")) {
            return this.tokenAdded(new ValidConstToken(args));
        }
        return false;
    }

    private boolean tokenAdded(TemplateToken tt) {
        if (tt instanceof LoopToken && ((LoopToken)tt).eol) {
            this.loopEol = true;
        }
        this.lastToken = tt;
        return true;
    }

    public TemplateToken getRootToken() {
        this.rootToken = new TemplateToken(this, this.lastmod);
        return this.rootToken;
    }

    public boolean hasMoreTokens() {
        if (!this.done && this.ptr < this.buffer.length()) {
            return true;
        }
        this.done = true;
        this.buffer = null;
        return false;
    }

    public Object nextToken() {
        while (this.ptr < this.buffer.length()) {
            int pos = this.buffer.indexOf(37, this.ptr);
            if (this.lastToken != null && this.lastToken.skipNewline) {
                this.lastToken = null;
                if (this.buffer.charAt(this.ptr) == '\n') {
                    if (!this.loopEol) {
                        ++this.ptr;
                        continue;
                    }
                    this.loopEol = false;
                }
                if (this.buffer.charAt(this.ptr) == '\r' && this.buffer.charAt(this.ptr + 1) == '\n') {
                    if (!this.loopEol) {
                        this.ptr += 2;
                        continue;
                    }
                    this.loopEol = false;
                }
            }
            this.lastToken = null;
            if (pos < 0) {
                return this.collect(this.ptr, this.buffer.length());
            }
            if (pos > this.ptr) {
                return this.collect(this.ptr, pos);
            }
            int pos2 = this.buffer.indexOf(32, pos + 1);
            int pos3 = this.buffer.indexOf(37, pos + 1);
            if ((pos2 < 0 || pos2 > pos3) && pos3 > 0) {
                pos2 = pos3;
            }
            String name = null;
            if (pos3 > 0) {
                name = this.buffer.substring(pos + 1, pos2);
            }
            String body = "";
            if (pos3 > pos2) {
                body = this.buffer.substring(pos2 + 1, pos3);
            }
            if (this.createToken(name, body)) {
                this.ptr = pos3 + 1;
                return this.lastToken;
            }
            if (pos3 < 0) {
                return this.collect(this.ptr, this.buffer.length());
            }
            return this.collect(this.ptr, pos3);
        }
        this.done = true;
        this.buffer = null;
        return null;
    }

    public static void main(String[] args) throws Exception {
        File f = new File(args[0]);
        DataInputStream di = new DataInputStream(new FileInputStream(f));
        byte[] b = new byte[(int)f.length()];
        di.readFully(b);
        TemplateTokenizer tt = new TemplateTokenizer(new String(b), f.lastModified());
        int idx = 0;
        while (tt.hasMoreTokens()) {
            System.out.println(idx++ + " ** " + tt.nextToken() + " **");
        }
    }
}

