/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.data.ValuesEmulator;
import com.wm.util.Config;
import com.wm.util.StringParser;
import com.wm.util.Table;
import com.wm.util.coder.IDataCodable;
import com.wm.util.template.Reporter;
import com.wm.util.template.ScopeParams;
import com.wm.util.template.ScopeParser;
import com.wm.util.template.TemplateToken;
import java.util.StringTokenizer;

public class ScopeToken
extends TemplateToken {
    String name;
    IData myVals;
    IData pasVals;
    String options;
    boolean valid;
    boolean g601compatible;

    public ScopeToken(String args) {
        block4: {
            this.g601compatible = false;
            String cs = Config.getProperty("watt.core.template.compatibleScope");
            this.g601compatible = cs != null && new Boolean(cs) != false;
            this.init();
            if (args == null) break block4;
            if (this.g601compatible) {
                StringParser st = new StringParser(args, " ", "'", false);
                int index = 0;
                while (st.hasMoreTokens()) {
                    this.processArg(st.nextToken(), index++);
                }
            } else {
                StringTokenizer st = new StringTokenizer(args);
                int index = 0;
                while (st.hasMoreTokens()) {
                    this.processArg(st.nextToken(), index++);
                }
            }
        }
    }

    public ScopeToken(String name, String options) {
        super(options);
        this.g601compatible = false;
        this.name = name;
        this.options = options;
    }

    public boolean processArg(String value, int index) {
        if (super.processArg(value, index)) {
            return true;
        }
        this.processParams(value);
        return true;
    }

    public void processParams(String value) {
        if (value == null) {
            return;
        }
        if (this.g601compatible) {
            ScopeParams.GenericParam sparams = ScopeParams.create(value);
            if (sparams != null) {
                if (this.myVals == null) {
                    this.myVals = IDataFactory.create();
                }
                String nm = sparams.getName();
                Object o = sparams.getValue();
                if (nm.startsWith("#")) {
                    if (this.pasVals == null) {
                        this.pasVals = IDataFactory.create();
                    }
                    ValuesEmulator.put(this.pasVals, nm.substring(1), o);
                } else {
                    ValuesEmulator.put(this.myVals, nm, o);
                }
                this.options = this.options == null ? value : this.options + " " + value;
            } else {
                this.name = value;
            }
        } else {
            ScopeParser sp = new ScopeParser(value);
            sp.parse();
            String nm = sp.getName();
            Object o = sp.getValue();
            if (nm != null) {
                if (this.myVals == null) {
                    this.myVals = IDataFactory.create();
                }
                if (nm.startsWith("#")) {
                    if (this.pasVals == null) {
                        this.pasVals = IDataFactory.create();
                    }
                    ValuesEmulator.put(this.pasVals, nm.substring(1), o);
                } else {
                    ValuesEmulator.put(this.myVals, nm, o);
                }
                this.options = this.options == null ? value : this.options + " " + value;
            } else {
                this.name = value;
            }
        }
    }

    public void eval(Reporter r) {
        this.eval(r, null);
    }

    public void eval(Reporter r, String encoding) {
        Object o = r.current;
        IData c = null;
        if (this.name != null) {
            o = r.get(this.name);
        }
        if (!(o instanceof Table) && o instanceof IDataCodable) {
            c = ((IDataCodable)o).getIData();
        } else if (o instanceof IData) {
            c = (IData)o;
        }
        if (o instanceof IDataPortable) {
            c = ((IDataPortable)o).getAsData();
        }
        if (this.myVals != null) {
            if (c == null) {
                c = this.myVals;
                if (this.pasVals != null) {
                    IDataUtil.merge(this.pasVals, this.myVals);
                }
            } else {
                IData nv = IDataFactory.create();
                IDataUtil.append(c, nv);
                IDataUtil.merge(this.myVals, nv);
                if (this.pasVals != null) {
                    IDataCursor nvc = nv.getCursor();
                    IDataCursor pasc = this.pasVals.getCursor();
                    while (pasc.next()) {
                        String key = pasc.getKey();
                        if (nvc.first(key)) continue;
                        Reporter.mergeOutput(nvc, key, pasc.getValue());
                    }
                    pasc.destroy();
                }
                c = nv;
            }
        }
        boolean bl = this.valid = c != null;
        if (this.valid) {
            this.evalChildrenInScope(r, c, encoding);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOptions() {
        return this.options;
    }

    public boolean isValid() {
        return this.valid;
    }
}

