/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;

class ScopeParser {
    String name = null;
    Object value;
    private ArrayList stack = new ArrayList();
    StringTokenizer st;
    String nextToken;
    static final String ALL_DELIMS = " \t()[=',|;{}";

    private void push(Object o) {
        this.stack.add(o);
    }

    private Object peek() {
        if (!this.stack.isEmpty()) {
            return this.stack.get(this.stack.size() - 1);
        }
        return null;
    }

    private Object pop() {
        Object ret = null;
        if (!this.stack.isEmpty()) {
            ret = this.stack.get(this.stack.size() - 1);
            this.stack.remove(this.stack.size() - 1);
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public static void main(String[] args) {
        ScopeParser sp = new ScopeParser(args[0]);
        sp.parse();
        System.out.println(sp.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ScopeParser { name='").append(this.name).append("', value");
        if (this.value instanceof Object[]) {
            Object[] foo = (Object[])this.value;
            sb.append("[]={");
            for (int i = 0; i < foo.length; ++i) {
                sb.append(foo[i]).append(";");
            }
            sb.append("}");
        } else {
            sb.append("=").append(this.value);
        }
        sb.append(", stack=").append(this.stack).append(" }");
        return sb.toString();
    }

    public void parse() {
        this.scope_tail();
        this.value = this.pop();
        if (this.value == null) {
            return;
        }
        this.name = (String)this.pop();
    }

    public ScopeParser(String arg) {
        this.st = new StringTokenizer(arg, ALL_DELIMS, true);
    }

    private String peekToken() {
        if (this.nextToken != null) {
            return this.nextToken;
        }
        this.nextToken = this.nextToken();
        return this.nextToken;
    }

    private String nextToken() {
        if (this.nextToken != null) {
            String ret = this.nextToken;
            this.nextToken = null;
            return ret;
        }
        block9: while (this.st.hasMoreTokens()) {
            String s = this.st.nextToken(ALL_DELIMS);
            switch (s.charAt(0)) {
                case '\t': 
                case ' ': {
                    continue block9;
                }
                case '[': {
                    this.st.nextToken();
                    return "[]";
                }
                case '\'': {
                    StringBuffer sb = new StringBuffer();
                    block10: while (this.st.hasMoreTokens()) {
                        String q = this.st.nextToken("\\'");
                        switch (q.charAt(0)) {
                            case '\\': {
                                sb.append(this.st.nextToken());
                                continue block10;
                            }
                            case '\'': {
                                return sb.toString();
                            }
                        }
                        sb.append(q);
                    }
                    break;
                }
            }
            return s;
        }
        return null;
    }

    private void scope_tail() {
        String s = this.nextToken();
        if ("param".equals(s)) {
            this.param_tail();
        } else if ("rparam".equals(s)) {
            this.rparam_tail();
        }
    }

    private void param_tail() {
        this.nextToken();
        this.identifier();
        this.pvalue();
        this.nextToken();
    }

    private void identifier() {
        String id = this.nextToken();
        this.push(id);
    }

    private void pvalue() {
        String s = this.nextToken();
        if ("[]".equals(s)) {
            this.nextToken();
            this.string_list();
        } else if ("=".equals(s)) {
            this.string_literal();
        }
    }

    private void string_list() {
        String string_list_marker = new String();
        this.push(string_list_marker);
        this.string_literal();
        while (",".equals(this.peekToken())) {
            this.string_tail();
        }
        ArrayList<String> list = new ArrayList<String>();
        String s = (String)this.pop();
        while (s != string_list_marker) {
            list.add(s);
            s = (String)this.pop();
        }
        Collections.reverse(list);
        String[] ar = new String[list.size()];
        ar = list.toArray(ar);
        this.push(ar);
    }

    private void string_literal() {
        String lit = this.nextToken();
        this.push(lit);
    }

    private void string_tail() {
        this.nextToken();
        this.string_literal();
    }

    private void rparam_tail() {
        this.nextToken();
        this.identifier();
        this.rvalue();
        this.nextToken();
    }

    private void rvalue() {
        String s = this.nextToken();
        if ("[]".equals(s)) {
            this.nextToken();
            this.rec_list();
        } else if ("=".equals(s)) {
            this.record();
        }
    }

    private void rec_list() {
        IData record_list_marker = IDataFactory.create();
        this.push(record_list_marker);
        this.record();
        while ("|".equals(this.peekToken())) {
            this.rec_list_tail();
        }
        ArrayList<IData> list = new ArrayList<IData>();
        IData m = (IData)this.pop();
        while (m != record_list_marker) {
            list.add(m);
            m = (IData)this.pop();
        }
        Collections.reverse(list);
        IData[] ar = new IData[list.size()];
        ar = list.toArray(ar);
        this.push(ar);
    }

    private void rec_list_tail() {
        this.nextToken();
        this.record();
    }

    private void record() {
        this.nextToken();
        IData record = IDataFactory.create();
        IDataCursor rc = record.getCursor();
        Object record_marker = new Object();
        this.push(record_marker);
        this.identifier();
        this.pvalue();
        Object val = this.pop();
        String name = (String)this.pop();
        rc.insertAfter(name, val);
        while (";".equals(this.peekToken())) {
            this.record_tail();
            val = this.pop();
            if (val == record_marker) continue;
            name = (String)this.pop();
            rc.insertAfter(name, val);
        }
        rc.destroy();
        if (this.peek() == record_marker) {
            this.pop();
        }
        this.push(record);
        this.nextToken();
    }

    private void record_tail() {
        this.nextToken();
        if ("}".equals(this.peekToken())) {
            return;
        }
        this.identifier();
        this.pvalue();
    }
}

