/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.util.StringParser;
import com.wm.util.Strings;
import com.wm.util.Values;

public class ScopeParams {
    public static final int PARAM_STRING = 1;
    public static final int PARAM_RECORD = 2;

    public static GenericParam create(String arg) {
        int dim;
        int epos;
        int lpar;
        int rpar = arg.length() - 1;
        if (arg == null || arg.length() < 3 || (lpar = arg.indexOf(40)) < 0 || (epos = arg.indexOf(61, lpar)) < 0 || arg.charAt(rpar) != ')') {
            return null;
        }
        String typeS = arg.substring(0, lpar);
        String name = arg.substring(lpar + 1, epos);
        String args = arg.substring(epos + 1, rpar);
        if (name.endsWith("[]")) {
            dim = 1;
            name = name.substring(0, name.length() - 2);
        } else {
            dim = 0;
        }
        if (typeS.equals("param")) {
            return new StringParam(name, dim, args);
        }
        if (typeS.equals("rparam")) {
            return new RecordParam(name, dim, args);
        }
        return null;
    }

    static class RecordParam
    extends GenericParam {
        public RecordParam(String name, int dim, String args) {
            super(name, dim, args);
        }

        public int getType() {
            return 2;
        }

        public void parseArgs(String args) {
            StringParser st = new StringParser(args, "|", "'", true);
            int count = st.countTokens();
            if (count == 0) {
                return;
            }
            if (this.dim == 0) {
                this.setValue(this.parseValues(st.nextToken()));
            } else {
                Values[] v = new Values[count];
                for (int i = 0; i < v.length; ++i) {
                    v[i] = this.parseValues(st.nextToken());
                }
                this.setValue(v);
            }
        }

        private Values parseValues(String arg) {
            if (!arg.startsWith("{") || !arg.endsWith("}")) {
                return null;
            }
            StringParser st = new StringParser(arg = arg.substring(1, arg.length() - 1), ";", "'", true);
            int count = st.countTokens();
            if (count == 0) {
                return null;
            }
            Values nv = new Values();
            for (int i = 0; i < count; ++i) {
                GenericParam sp = ScopeParams.create(Strings.cat("param(", st.nextToken(), ")"));
                if (sp == null) continue;
                nv.put(sp.getName(), sp.getValue());
            }
            return nv;
        }
    }

    static class StringParam
    extends GenericParam {
        public StringParam(String name, int dim, String args) {
            super(name, dim, args);
        }

        public int getType() {
            return 1;
        }

        public void parseArgs(String args) {
            StringParser st = new StringParser(args, ',', '\'');
            int count = st.countTokens();
            if (count == 0) {
                return;
            }
            if (this.dim == 0) {
                this.setValue(st.nextToken());
            } else {
                String[] s = new String[count];
                for (int i = 0; i < s.length; ++i) {
                    s[i] = st.nextToken();
                }
                this.setValue(s);
            }
        }
    }

    public static abstract class GenericParam {
        int dim;
        String name;
        Object value;

        protected GenericParam(String name, int dim, String value) {
            this.name = name;
            this.dim = dim;
            this.parseArgs(value);
        }

        public abstract int getType();

        public abstract void parseArgs(String var1);

        public String getName() {
            return this.name;
        }

        public int getDimensions() {
            return this.dim;
        }

        public Object getValue() {
            return this.value;
        }

        protected void setValue(Object val) {
            this.value = val;
        }

        public String toString() {
            return "SP:(" + this.getName() + "=" + this.getValue() + ")";
        }
    }
}

