/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.ValuesEmulator;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.Namespace;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.Config;
import com.wm.util.Cron;
import com.wm.util.CronJob;
import com.wm.util.EncUtil;
import com.wm.util.EncodingNames;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.LocalizedException;
import com.wm.util.LocalizedRuntimeException;
import com.wm.util.Table;
import com.wm.util.Trace;
import com.wm.util.Values;
import com.wm.util.coder.Codable;
import com.wm.util.coder.Coder;
import com.wm.util.coder.IDataCodable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.template.ReportFlush;
import com.wm.util.template.TemplateToken;
import com.wm.util.template.TemplateTokenizer;
import com.wm.util.template.TokenCacheEntry;
import com.wm.util.template.resources.TemplateExceptionBundle;
import com.wm.util.xform.DateTimeDT;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Reporter
extends Coder {
    private static final String RESOURCEDIR = "lib";
    private boolean filter = false;
    String lsepStr = System.getProperty("line.separator");
    String outputEncoding = null;
    Date date;
    String host;
    IData inputs;
    File templateDir;
    File resourceDir;
    Locale locale;
    Namespace ns;
    OutputStream os;
    Writer writer;
    TemplateToken rootToken;
    String contentType;
    private ResourceBundle reportBundle;
    private List bundleStack = new List();
    private Vector tokenStore = new Vector();
    private boolean store = false;
    static Cron cron;
    static IData cache;
    static CronJob cacheFlush;
    List stack;
    Stack keys;
    String key;
    IDataCursor keyCursor;
    int INDEX;
    IData current;
    IData currentCodable;

    public Reporter(String templateFile, File templateDir) throws FileNotFoundException {
        this(templateFile, null, templateDir);
    }

    public Reporter(String templateFile, String tmplEncoding, File templateDir) throws FileNotFoundException {
        this(templateFile, tmplEncoding, templateDir, null);
    }

    public Reporter(String templateFile, String tmplEncoding, File templateDir, Locale locale) throws FileNotFoundException {
        this.setHost();
        if (locale != null) {
            this.locale = locale;
        }
        this.templateDir = templateDir;
        this.resourceDir = new File(templateDir.getParent(), RESOURCEDIR);
        this.rootToken = this.getTemplate(templateFile, false, tmplEncoding);
        this.outputEncoding = this.rootToken.dfltEncoding;
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, templateFile, this.rootToken.toString());
        }
    }

    public Reporter(String templateFile, File templateDir, String encoding) throws FileNotFoundException {
        this(templateFile, templateDir, encoding, null, false);
    }

    public Reporter(String templateFile, File templateDir, String encoding, Locale locale) throws FileNotFoundException {
        this(templateFile, templateDir, encoding, locale, false);
    }

    public Reporter(String templateFile, File templateDir, String encoding, boolean remove) throws FileNotFoundException {
        this(templateFile, templateDir, encoding, null, remove);
    }

    public Reporter(String templateFile, File templateDir, String encoding, Locale locale, boolean remove) throws FileNotFoundException {
        this.outputEncoding = EncodingNames.getJavaName(encoding);
        this.setHost();
        this.templateDir = templateDir;
        this.resourceDir = new File(templateDir.getParent(), RESOURCEDIR);
        this.locale = locale == null ? new Locale("en", "US") : locale;
        this.rootToken = this.getTemplate(templateFile, remove);
        if (this.outputEncoding == null) {
            this.outputEncoding = this.rootToken.dfltEncoding;
        }
    }

    public Reporter(String stringTemplate) {
        this.setHost();
        this.rootToken = Reporter.createTemplateFromString(stringTemplate, 0L);
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, stringTemplate, this.rootToken.toString());
        }
    }

    public Reporter(String stringTemplate, String encoding) {
        this.outputEncoding = EncodingNames.getJavaName(encoding);
        this.setHost();
        this.rootToken = Reporter.createTemplateFromString(stringTemplate, 0L);
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, stringTemplate, this.rootToken.toString());
        }
    }

    public Reporter(IData input) {
        this.setHost();
        this.rootToken = new TemplateToken();
        this.initStack(input);
    }

    public Reporter(String templateFile, String templateDir, Codable input) throws FileNotFoundException {
        this(templateFile, new File(templateFile), input);
    }

    public Reporter(String templateFile, File templateDir, Codable input) throws FileNotFoundException {
        this(templateFile, templateDir, input, true, null);
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, templateFile, templateDir != null ? templateDir.toString() : "null");
        }
    }

    public Reporter(String templateFile, File templateDir, Codable input, boolean tryCache) throws FileNotFoundException {
        this(templateFile, templateDir, input, tryCache, null);
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, templateFile, this.rootToken.toString());
        }
    }

    public Reporter(String templateFile, File templateDir, Codable input, boolean tryCache, String encoding) throws FileNotFoundException {
        this.outputEncoding = EncodingNames.getJavaName(encoding);
        this.setHost();
        this.templateDir = templateDir;
        this.resourceDir = new File(templateDir.getParent(), RESOURCEDIR);
        this.inputs = (IData)((Object)input);
        File tfile = templateDir != null ? new File(templateDir, templateFile) : new File(templateFile);
        this.rootToken = null;
        if (tryCache) {
            this.rootToken = Reporter.getCachedTemplate(tfile);
        }
        if (this.rootToken == null) {
            this.rootToken = Reporter.createTemplateFromFile(tfile);
        }
        if (this.outputEncoding == null) {
            this.outputEncoding = this.rootToken.dfltEncoding;
        }
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, templateFile, this.rootToken.toString());
        }
    }

    public Reporter(String templateFile, File templateDir, Codable input, String encoding) throws FileNotFoundException {
        this.outputEncoding = EncodingNames.getJavaName(encoding);
        this.setHost();
        this.templateDir = templateDir;
        this.resourceDir = new File(templateDir.getParent(), RESOURCEDIR);
        this.inputs = (IData)((Object)input);
        File tfile = templateDir != null ? new File(templateDir, templateFile) : new File(templateFile);
        this.rootToken = null;
        if (this.rootToken == null) {
            this.rootToken = Reporter.createTemplateFromFile(tfile);
        }
        if (this.outputEncoding == null) {
            this.outputEncoding = this.rootToken.dfltEncoding;
        }
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, templateFile, templateDir != null ? templateDir.toString() : "null");
        }
    }

    public Reporter(String templateFile, File templateDir, String encoding, IData input) throws FileNotFoundException {
        this(templateFile, templateDir, encoding, input, null);
    }

    public Reporter(String templateFile, File templateDir, String encoding, IData input, Locale locale) throws FileNotFoundException {
        this.outputEncoding = EncodingNames.getJavaName(encoding);
        this.setHost();
        if (templateDir == null) {
            templateDir = new File(".");
        }
        this.templateDir = templateDir;
        this.resourceDir = new File(templateDir.getParent(), RESOURCEDIR);
        this.inputs = input;
        this.locale = locale;
        File tfile = null;
        tfile = this.getLocalizedFile(templateFile, templateDir.toString());
        if (tfile == null) {
            tfile = templateDir != null ? new File(templateDir, templateFile) : new File(templateFile);
        }
        this.rootToken = null;
        if (this.rootToken == null) {
            this.rootToken = Reporter.createTemplateFromFile(tfile);
        }
        if (this.outputEncoding == null) {
            this.outputEncoding = this.rootToken.dfltEncoding;
        }
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, templateFile, templateDir != null ? templateDir.toString() : "null");
        }
    }

    public Reporter(String stringTemplate, Codable input) {
        this(stringTemplate, input, null);
    }

    public Reporter(String stringTemplate, Codable input, String encoding) {
        this.outputEncoding = EncodingNames.getJavaName(encoding);
        this.setHost();
        this.inputs = (IData)((Object)input);
        this.rootToken = Reporter.createTemplateFromString(stringTemplate, 0L);
        if (this.outputEncoding == null) {
            this.outputEncoding = this.rootToken.dfltEncoding;
        }
        if (JournalLogger.isLogEnabledDebugPlus(6, 1, 72)) {
            JournalLogger.logDebugPlus(6, 1, 72, stringTemplate, this.rootToken.toString());
        }
    }

    void setHost() {
        try {
            this.host = Config.getLocalHost().getHostName();
        }
        catch (Throwable e) {
            this.host = "localhost";
        }
    }

    public IData getCurrent() {
        return this.current;
    }

    private void initStack(IData input) {
        this.date = new Date();
        this.stack = new List();
        this.keys = new Stack();
        if (JournalLogger.isLogEnabledDebugPlus(6, 8, 72)) {
            JournalLogger.logDebugPlus(6, 8, 72, input != null ? input.toString() : "null");
        }
        this.pushVal(input);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    private ResourceBundle loadBundle(File f) {
        PropertyResourceBundle rb = null;
        if (f.exists()) {
            try {
                FileInputStream fis = new FileInputStream(f);
                rb = new PropertyResourceBundle(fis);
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rb;
    }

    private ResourceBundle findBundle(String bundleName) throws MissingResourceException {
        ResourceBundle rb = null;
        if (this.locale == null) {
            this.locale = new Locale("en", "US");
        }
        String bundleNamePath = bundleName.replace('.', File.separatorChar);
        if (rb == null) {
            try {
                File full = new File(this.resourceDir, bundleNamePath + "_" + this.locale.getLanguage() + "_" + this.locale.getCountry() + ".properties");
                rb = this.loadBundle(full);
                if (rb == null) {
                    File lang = new File(this.resourceDir, bundleNamePath + "_" + this.locale.getLanguage() + ".properties");
                    rb = this.loadBundle(lang);
                }
                if (rb == null) {
                    File none = new File(this.resourceDir, bundleNamePath + ".properties");
                    rb = this.loadBundle(none);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (rb == null) {
            rb = ResourceBundle.getBundle(bundleName);
        }
        return rb;
    }

    void pushBundle() {
        if (this.reportBundle != null) {
            this.bundleStack.addElement(this.reportBundle);
        }
    }

    void popBundle() {
        int len = this.bundleStack.size();
        if (len > 0) {
            this.reportBundle = (ResourceBundle)this.bundleStack.lastElement();
            this.bundleStack.removeElementAt(len - 1);
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setBundle(String bundleName) {
        try {
            this.reportBundle = this.findBundle(bundleName);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void appendBundleString(String token) {
        if (this.reportBundle != null) {
            String temp = this.getBundleString(token);
            if (temp != null) {
                this.append(temp);
            } else {
                this.append(token);
            }
        } else {
            this.append(token);
        }
    }

    public String getBundleString(String token) {
        return this.reportBundle.getString(token);
    }

    public Values decode(InputStream is) throws IOException {
        return null;
    }

    public void encode(OutputStream os, Values val) throws IOException {
        this.reportToOutput(os, val);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String cType) {
        this.contentType = cType;
    }

    public void storeTokens() {
        this.store = true;
    }

    public void releaseTokens(String message) {
        Object[] tokens = new Object[this.tokenStore.size()];
        this.tokenStore.copyInto(tokens);
        String local = MessageFormat.format(message, tokens);
        this.store = false;
        this.append(local);
        this.tokenStore = new Vector();
    }

    void append(String s) {
        if (s == null) {
            return;
        }
        if (this.store) {
            if (s.trim().length() == 0) {
                return;
            }
            this.tokenStore.addElement(s);
        } else {
            try {
                if (this.os != null) {
                    if (this.outputEncoding != null) {
                        if (this.outputEncoding.equals("Unicode") || this.outputEncoding.equals("UnicodeBig")) {
                            this.os.write(this.toUnicode(s));
                        } else if (this.outputEncoding.equals("UnicodeLittle")) {
                            this.os.write(this.toUnicodeLittle(s));
                        } else {
                            this.os.write(s.getBytes(this.outputEncoding));
                        }
                    } else {
                        this.os.write(s.getBytes(EncUtil.getNetEncoding()));
                    }
                } else {
                    this.writer.write(s);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    byte[] toUnicode(String s) {
        int len = s.length();
        byte[] ret = new byte[len << 1];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int i1 = i << 1;
            ret[i1] = (byte)(c >> 8 & 0xFF);
            ret[i1 + 1] = (byte)(c & 0xFF);
        }
        return ret;
    }

    byte[] toUnicodeLittle(String s) {
        int len = s.length();
        byte[] ret = new byte[len << 1];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            int i1 = i << 1;
            ret[i1] = (byte)(c & 0xFF);
            ret[i1 + 1] = (byte)(c >> 8 & 0xFF);
        }
        return ret;
    }

    void appendDate() {
        String dateString = DateTimeDT.convertDate(this.date, Config.getProperty(Trace.DEFAULT_DATE_FORMAT, "watt.server.dateStampFmt"), null, this.getLocale());
        this.append(dateString);
    }

    void appendHost() {
        this.append(this.host);
    }

    void appendLastMod() {
        if (this.rootToken.lastmod > 0L) {
            Date d = new Date(this.rootToken.lastmod);
            String lastmodstring = DateTimeDT.convertDate(d, Config.getProperty(Trace.DEFAULT_DATE_FORMAT, "watt.server.dateStampFmt"), null, this.getLocale());
            this.append(lastmodstring);
        }
    }

    void newline() {
        this.append(this.lsepStr);
    }

    public static void setupTemplateCache(Cron aCron, int cacheSize, int period) {
        cron = aCron;
        cache = IDataFactory.create(cacheSize);
        cacheFlush = new CronJob("Template Cache Sweeper", new ReportFlush(period), 0L, period / 4 * 1000);
        cron.scheduleTask(cacheFlush);
        if (JournalLogger.isLogEnabledDebugPlus(5, 2, 72)) {
            JournalLogger.logDebugPlus(5, 2, 72, new Integer(cacheSize).toString(), new Integer(period).toString());
        }
    }

    private static synchronized TemplateToken getCachedTemplate(File file, boolean remove) throws FileNotFoundException {
        return Reporter.getCachedTemplate(file, remove, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized TemplateToken getCachedTemplate(File file, boolean remove, String encoding) throws FileNotFoundException {
        if (JournalLogger.isLogEnabledDebugPlus(5, 3, 72)) {
            JournalLogger.logDebugPlus(5, 3, 72, file.toString());
        }
        if (cache == null) {
            return null;
        }
        TokenCacheEntry entry = (TokenCacheEntry)Reporter.getTemplateFromCache(file.toString(), remove);
        if (entry == null || entry.fileMod != file.lastModified() || encoding == null && entry.encoding != null || encoding != null && entry.encoding == null || encoding != null && entry.encoding != null && !encoding.equalsIgnoreCase(entry.encoding)) {
            if (!file.exists()) {
                Reporter.getTemplateFromCache(file.toString(), true);
                throw new FileNotFoundException(file.toString());
            }
            try {
                TemplateToken root = Reporter.createTemplateFromFile(file, encoding);
                entry = new TokenCacheEntry(file, root, encoding);
                if (remove) return entry.root;
                Reporter.addTemplateToCache(file.toString(), entry);
                return entry.root;
            }
            catch (IOException e) {
                return null;
            }
        } else {
            entry.fileMod = file.lastModified();
            entry.lastUse = System.currentTimeMillis();
        }
        return entry.root;
    }

    static TemplateToken getCachedTemplate(File file) throws FileNotFoundException {
        return Reporter.getCachedTemplate(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTemplateToCache(String file, Object entry) {
        IData iData = cache;
        synchronized (iData) {
            IDataCursor idc = cache.getCursor();
            idc.last();
            idc.insertAfter(file, entry);
            idc.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootTokenToCache(File file) {
        IData iData = cache;
        synchronized (iData) {
            TokenCacheEntry tce = new TokenCacheEntry(file, this.rootToken);
            IDataCursor idc = cache.getCursor();
            idc.last();
            idc.insertAfter(file.toString(), tce);
            idc.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getTemplateFromCache(String file, boolean remove) {
        Object ret = null;
        IData iData = cache;
        synchronized (iData) {
            IDataCursor idc = cache.getCursor();
            if (idc.first(file)) {
                ret = idc.getValue();
                if (remove) {
                    idc.delete();
                }
            }
            idc.destroy();
        }
        return ret;
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public IData invoke(NSName service, IData input) throws Exception {
        if (this.ns == null) {
            return null;
        }
        NSNode svc = this.ns.getNode(service);
        if (svc == null || !svc.getNodeTypeObj().equals(NSService.TYPE)) {
            throw new LocalizedException(TemplateExceptionBundle.class, TemplateExceptionBundle.REPORTER_1, "", service.toString());
        }
        if (JournalLogger.isLogEnabledDebugPlus(6, 4, 72)) {
            JournalLogger.logDebugPlus(6, 4, 72, svc.toString(), input != null ? input.toString() : "null");
        }
        Values ret = this.ns.invoke((NSService)svc, Values.use(input));
        if (JournalLogger.isLogEnabledDebugPlus(6, 5, 72)) {
            JournalLogger.logDebugPlus(6, 5, 72, ((Object)ret).toString());
        }
        return ret;
    }

    TemplateToken getTemplate(String url, boolean remove) throws FileNotFoundException {
        return this.getTemplate(url, remove, null);
    }

    TemplateToken getTemplate(String url, boolean remove, String encoding) throws FileNotFoundException {
        File locale_dir;
        if (JournalLogger.isLogEnabledDebugPlus(6, 6, 72)) {
            JournalLogger.logDebugPlus(6, 6, 72, url);
        }
        File file = null;
        if (this.locale != null) {
            locale_dir = new File(this.templateDir + File.separator + this.locale.toString());
            if (!locale_dir.exists()) {
                locale_dir = new File(this.templateDir + File.separator + this.locale.getLanguage());
            }
            if (locale_dir.exists() && !(file = new File(locale_dir, url)).exists()) {
                file = null;
            }
        }
        if (!(file != null || this.locale != null && this.locale.getLanguage().equalsIgnoreCase("en") || (file = new File(locale_dir = new File(this.templateDir, Locale.getDefault().toString()), url)).exists() || (file = new File(locale_dir = new File(this.templateDir, Locale.getDefault().getLanguage()), url)).exists())) {
            file = null;
        }
        if (file == null) {
            file = this.templateDir == null ? new File(url) : new File(this.templateDir, url);
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (cache != null) {
            return Reporter.getCachedTemplate(file, remove, encoding);
        }
        return Reporter.createTemplateFromFile(file, encoding);
    }

    public static TemplateToken createTemplateFromString(String tmplString, long modTime) {
        return TemplateTokenizer.newRootToken(tmplString, modTime);
    }

    public static TemplateToken createTemplateFromFile(File tmplFile) throws FileNotFoundException {
        return Reporter.createTemplateFromFile(tmplFile, null);
    }

    public static TemplateToken createTemplateFromFile(File tmplFile, String encoding) throws FileNotFoundException {
        if (JournalLogger.isLogEnabledDebugPlus(5, 7, 72)) {
            JournalLogger.logDebugPlus(5, 7, 72, tmplFile != null ? tmplFile.toString() : "null");
        }
        TemplateToken ret = null;
        if (!tmplFile.exists()) {
            throw new FileNotFoundException(tmplFile.toString());
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(tmplFile));
            byte[] b = new byte[(int)tmplFile.length()];
            for (int total = b.length; total > 0; total -= ((InputStream)is).read(b, b.length - total, total)) {
            }
            ((InputStream)is).close();
            if (encoding != null) {
                String s = new String(b, encoding);
                ret = Reporter.createTemplateFromString(s, tmplFile.lastModified());
            } else if ((b[0] & 0xFF) == 254 && (b[1] & 0xFF) == 255 || (b[0] & 0xFF) == 255 && (b[1] & 0xFF) == 254) {
                String s = new String(b, "Unicode");
                ret = Reporter.createTemplateFromString(s, tmplFile.lastModified());
                ret.dfltEncoding = "Unicode";
            } else if (EncUtil.isUTF8(b)) {
                String s = new String(b, "UTF8");
                ret = Reporter.createTemplateFromString(s, tmplFile.lastModified());
                ret.dfltEncoding = "UTF8";
            } else {
                String s = new String(b, EncUtil.getFileEncoding());
                ret = Reporter.createTemplateFromString(s, tmplFile.lastModified());
            }
            return ret;
        }
        catch (FileNotFoundException fe) {
            throw fe;
        }
        catch (IOException ie) {
            throw new LocalizedRuntimeException(TemplateExceptionBundle.class, TemplateExceptionBundle.REPORTER_2, "", ie.toString());
        }
    }

    public byte[] report() {
        return this.reportIData(this.inputs);
    }

    public byte[] report(Codable input) {
        if (JournalLogger.isLogEnabledDebugPlus(6, 8, 72)) {
            JournalLogger.logDebugPlus(6, 8, 72, input != null ? input.toString() : "null");
        }
        ByteOutputBuffer bob = new ByteOutputBuffer();
        try {
            this.reportToOutput(bob, (IData)((Object)input));
        }
        catch (IOException e) {
            return null;
        }
        return bob.toByteArray();
    }

    public byte[] reportIData(IData input) {
        if (JournalLogger.isLogEnabledDebugPlus(6, 8, 72)) {
            JournalLogger.logDebugPlus(6, 8, 72, input != null ? input.toString() : "null");
        }
        ByteOutputBuffer bob = new ByteOutputBuffer();
        try {
            this.reportToOutput(bob, input);
        }
        catch (IOException e) {
            return null;
        }
        return bob.toByteArray();
    }

    public void reportToFile(Codable input, File target) throws IOException {
        if (JournalLogger.isLogEnabledDebugPlus(6, 9, 72)) {
            JournalLogger.logDebugPlus(6, 9, 72, input != null ? input.toString() : "null", target != null ? target.toString() : "null");
        }
        FileOutputStream fo = new FileOutputStream(target);
        this.reportToOutput(fo, (IData)((Object)input));
        fo.flush();
        fo.close();
    }

    public void reportToFile(File target, IData input) throws IOException {
        if (JournalLogger.isLogEnabledDebugPlus(6, 9, 72)) {
            JournalLogger.logDebugPlus(6, 9, 72, input != null ? input.toString() : "null", target != null ? target.toString() : "null");
        }
        FileOutputStream fo = new FileOutputStream(target);
        this.reportToOutput(fo, input);
        fo.flush();
        fo.close();
    }

    public void reportToOutput(Codable input, OutputStream os) throws IOException {
        this.os = os;
        if (this.outputEncoding != null && (this.outputEncoding.equals("Unicode") || this.outputEncoding.equals("UnicodeBig") || this.outputEncoding.equals("UnicodeLittle"))) {
            this.append("\ufeff");
        }
        this.date = new Date();
        this.stack = new List();
        this.keys = new Stack();
        if (JournalLogger.isLogEnabledDebugPlus(6, 8, 72)) {
            JournalLogger.logDebugPlus(6, 8, 72, input != null ? input.toString() : "null");
        }
        this.pushVal((IData)((Object)input));
        this.reportNoReset();
    }

    public void reportToOutput(OutputStream os, IData input) throws IOException {
        this.os = os;
        if (this.outputEncoding != null && (this.outputEncoding.equals("Unicode") || this.outputEncoding.equals("UnicodeBig") || this.outputEncoding.equals("UnicodeLittle"))) {
            this.append("\ufeff");
        }
        this.date = new Date();
        this.stack = new List();
        this.keys = new Stack();
        if (JournalLogger.isLogEnabledDebugPlus(6, 8, 72)) {
            JournalLogger.logDebugPlus(6, 8, 72, input != null ? input.toString() : "null");
        }
        this.pushVal(input);
        this.reportNoReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reportNoReset() {
        TemplateToken templateToken = this.rootToken;
        synchronized (templateToken) {
            this.rootToken.eval(this, this.outputEncoding);
        }
    }

    public String debug() {
        return "CURRENT [" + this.current + "] INDEX [" + this.INDEX + "] DEPTH [" + this.stack.size() + "] KEY [" + this.key + "] KEYSIZE [" + this.keys.size() + "]";
    }

    public void pushVal(IData o) {
        this.stack.addElement(o);
        this.current = o;
        this.keys.push(this.key);
    }

    public IData popVal() {
        int len = this.stack.size();
        this.stack.removeElementAt(len - 1);
        this.current = (IData)this.stack.lastElement();
        this.key = (String)this.keys.pop();
        return this.current;
    }

    IData peekVal(int index) {
        int len = this.stack.size();
        if (index >= len || index < 0) {
            return null;
        }
        return (IData)this.stack.elementAt(index);
    }

    public static void mergeOutput(IDataCursor id, String key, Object value) {
        if (id.first(key)) {
            id.setValue(value);
        } else {
            id.last();
            id.insertAfter(key, value);
        }
    }

    Object get(String name) {
        return this.get(name, this.current);
    }

    Object get(String name, IData nextVal) {
        if (name == null || name.length() == 0 || nextVal == null) {
            return null;
        }
        if (name.charAt(0) == '/') {
            nextVal = this.peekVal(0);
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        Object next = null;
        int stackPos = this.stack.size() - 1;
        while (st.hasMoreTokens()) {
            block40: {
                int iePos;
                int index = -1;
                int sibling = -1;
                String t = st.nextToken();
                if (t.equals("..")) {
                    if ((nextVal = this.peekVal(--stackPos)) != null) continue;
                    return null;
                }
                String keyName = t;
                int iPos = t.indexOf(40);
                if (iPos > 0) {
                    iePos = t.indexOf(41, iPos);
                    try {
                        sibling = Integer.parseInt(t.substring(iPos + 1, iePos));
                    }
                    catch (NumberFormatException e) {
                        sibling = 0;
                    }
                    keyName = t.substring(0, iPos);
                }
                if ((iPos = t.indexOf(91)) > 0) {
                    iePos = t.indexOf(93, iPos);
                    try {
                        index = Integer.parseInt(t.substring(iPos + 1, iePos));
                    }
                    catch (NumberFormatException e) {
                        index = 0;
                    }
                    if (sibling == -1) {
                        keyName = t.substring(0, iPos);
                    }
                }
                if (keyName.equals("$key")) {
                    return this.key;
                }
                if (keyName.equals("$index")) {
                    return Integer.toString(this.INDEX);
                }
                if (this.key != null && keyName.equals("#$key")) {
                    keyName = this.key;
                }
                if (sibling > 0) {
                    IData id = null;
                    if (nextVal instanceof IData) {
                        id = nextVal;
                    } else if (nextVal instanceof IDataCodable) {
                        id = ((IDataCodable)((Object)nextVal)).getIData();
                    } else if (nextVal instanceof IDataPortable) {
                        id = ((IDataPortable)((Object)nextVal)).getAsData();
                    }
                    if (id == null) {
                        next = ValuesEmulator.get(nextVal, keyName);
                    } else {
                        IDataCursor idhc = id.getCursor();
                        for (int i = 0; i <= sibling; ++i) {
                            next = idhc.next(keyName) ? idhc.getValue() : null;
                        }
                        idhc.destroy();
                    }
                } else {
                    next = ValuesEmulator.get(nextVal, keyName);
                }
                if (next == null) {
                    return null;
                }
                if (index > -1) {
                    try {
                        if (next instanceof Object[]) {
                            next = ((Object[])next)[index];
                        } else if (next instanceof Vector) {
                            next = ((Vector)next).elementAt(index);
                        } else if (next instanceof Table) {
                            next = ((Table)next).getRow(index);
                        }
                    }
                    catch (Exception e) {
                        if (!JournalLogger.isLogEnabledDebugPlus(5, 10, 72)) break block40;
                        JournalLogger.logDebugPlus(5, 10, 72, new Integer(index).toString(), t);
                    }
                }
            }
            if (!(next instanceof Table)) {
                if (next instanceof IDataCodable) {
                    next = ((IDataCodable)next).getIData();
                } else if (!(next instanceof IData) && next instanceof ValuesCodable) {
                    next = ((ValuesCodable)next).getValues();
                } else if (next instanceof IDataPortable) {
                    next = ((IDataPortable)next).getAsData();
                }
            }
            if (!(next instanceof IData)) {
                return next;
            }
            nextVal = (IData)next;
        }
        return next;
    }

    File getLocalizedFile(String child, String parent) {
        File tmpFile = new File(parent, child);
        String filename = tmpFile.getName();
        String dir = tmpFile.getParent();
        File file = null;
        if (this.locale != null) {
            File locale_dir = dir != null ? new File(dir + File.separator + this.locale.toString()) : new File(this.locale.toString());
            if (!locale_dir.exists()) {
                locale_dir = dir != null ? new File(dir + File.separator + this.locale.getLanguage()) : new File(this.locale.getLanguage().toString());
            }
            if (locale_dir.exists() && !(file = new File(locale_dir, filename)).exists()) {
                file = null;
            }
        }
        return file;
    }

    IDataCursor getCursor(String name, IData nextVal) {
        if (name == null || name.length() == 0 || nextVal == null) {
            return null;
        }
        if (name.charAt(0) == '/') {
            nextVal = this.peekVal(0);
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        Object next = null;
        IDataCursor idhc = null;
        int stackPos = this.stack.size() - 1;
        while (st.hasMoreTokens()) {
            block40: {
                int iePos;
                String t;
                int index = -1;
                int sibling = -1;
                String keyName = t = st.nextToken();
                if (t.equals("..")) {
                    if ((nextVal = this.peekVal(--stackPos)) != null) continue;
                    return null;
                }
                int iPos = t.indexOf(40);
                if (iPos > 0) {
                    iePos = t.indexOf(41, iPos);
                    try {
                        sibling = Integer.parseInt(t.substring(iPos + 1, iePos));
                    }
                    catch (NumberFormatException e) {
                        sibling = 0;
                    }
                    keyName = t.substring(0, iPos);
                }
                if ((iPos = t.indexOf(91)) > 0) {
                    iePos = t.indexOf(93, iPos);
                    try {
                        index = Integer.parseInt(t.substring(iPos + 1, iePos));
                    }
                    catch (NumberFormatException e) {
                        index = 0;
                    }
                    if (sibling == -1) {
                        keyName = t.substring(0, iPos);
                    }
                }
                if (keyName.equals("$key")) {
                    return this.keyCursor;
                }
                if (this.key != null && keyName.equals("#$key")) {
                    keyName = this.key;
                }
                IData id = null;
                if (nextVal instanceof IData) {
                    id = nextVal;
                } else if (nextVal instanceof IDataCodable) {
                    id = ((IDataCodable)((Object)nextVal)).getIData();
                } else if (nextVal instanceof IDataPortable) {
                    id = ((IDataPortable)((Object)nextVal)).getAsData();
                }
                if (id == null) {
                    next = ValuesEmulator.get(nextVal, keyName);
                } else {
                    idhc = id.getCursor();
                    if (idhc.first(keyName)) {
                        // empty if block
                    }
                    next = idhc.getValue();
                    if (sibling > 0) {
                        for (int i = 0; i < sibling; ++i) {
                            next = idhc.next(keyName) ? idhc.getValue() : null;
                        }
                    }
                }
                if (next == null) {
                    return null;
                }
                if (index > -1) {
                    try {
                        idhc = null;
                        if (next instanceof Object[]) {
                            next = ((Object[])next)[index];
                        } else if (next instanceof Vector) {
                            next = ((Vector)next).elementAt(index);
                        } else if (next instanceof Table) {
                            next = ((Table)next).getRow(index);
                        }
                    }
                    catch (Exception e) {
                        if (!JournalLogger.isLogEnabledDebugPlus(5, 10, 72)) break block40;
                        JournalLogger.logDebugPlus(5, 10, 72, new Integer(index).toString(), t);
                    }
                }
            }
            if (!(next instanceof Table)) {
                if (next instanceof IDataCodable) {
                    next = ((IDataCodable)next).getIData();
                } else if (!(next instanceof IData) && next instanceof ValuesCodable) {
                    next = ((ValuesCodable)next).getValues();
                } else if (next instanceof IDataPortable) {
                    next = ((IDataPortable)next).getAsData();
                }
            }
            if (!(next instanceof IData)) {
                if (st.hasMoreTokens()) {
                    return null;
                }
                return idhc;
            }
            nextVal = (IData)next;
        }
        return idhc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushTemplateCache(long period) {
        if (cache == null) {
            return;
        }
        IData iData = cache;
        synchronized (iData) {
            long now = System.currentTimeMillis();
            IDataCursor idc = cache.getCursor();
            while (idc.next()) {
                TokenCacheEntry tke = (TokenCacheEntry)idc.getValue();
                if (now - tke.lastUse <= period) continue;
                idc.delete();
            }
            idc.destroy();
        }
    }

    public void setFilter() {
        this.filter = true;
    }
}

