/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IDataCursor;
import com.wm.util.template.EmptyToken;
import com.wm.util.template.Reporter;

public class RenameToken
extends EmptyToken {
    String name;
    String newname;
    boolean copy;

    public RenameToken(String args) {
        super(args);
    }

    public RenameToken(String source, String target, boolean copy) {
        this.name = source;
        this.newname = target;
        this.copy = copy;
    }

    public void init() {
        this.copy = false;
    }

    public boolean processArg(String value, int index) {
        if (super.processArg(value, index)) {
            return true;
        }
        if (value.equals("-copy")) {
            this.copy = true;
        } else if (this.name == null) {
            this.name = value;
        } else {
            this.newname = value;
        }
        return true;
    }

    public void eval(Reporter r) {
        this.eval(r, null);
    }

    public void eval(Reporter r, String encoding) {
        IDataCursor idhc;
        Object value;
        if (this.name == null) {
            return;
        }
        if (this.name.equals(this.newname)) {
            return;
        }
        if (this.name.equals("$key")) {
            String key = this.newname;
            value = r.key;
            idhc = r.keyCursor;
            this.copy = true;
        } else {
            String key = this.name;
            idhc = r.getCursor(this.name, r.current);
            if (idhc == null) {
                return;
            }
            value = idhc.getValue();
        }
        IDataCursor id = r.current.getCursor();
        if (id.first(this.newname)) {
            id.setValue(value);
            if (!this.copy) {
                idhc.setValue("");
            }
        } else if (this.copy || this.name.equals("$key")) {
            id.last();
            id.insertAfter(this.newname, value);
        } else {
            idhc.setKey(this.newname);
        }
    }

    public String getSourceVar() {
        return this.name;
    }

    public String getTargetVar() {
        return this.newname;
    }

    public boolean isCopy() {
        return this.copy;
    }
}

