/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.util.JournalLogger;
import com.wm.util.Table;
import com.wm.util.Values;
import com.wm.util.coder.IDataCodable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.template.EndToken;
import com.wm.util.template.LoopSepToken;
import com.wm.util.template.Reporter;
import com.wm.util.template.TemplateToken;
import com.wm.util.template.ValueToken;
import java.util.Vector;

public class LoopToken
extends TemplateToken {
    String name;
    boolean eol;
    String eolTok;
    String eolRem;
    boolean struct;
    boolean xpriv;
    boolean step;
    int index;
    boolean last;
    int len;
    Object target;
    IDataCursor cursor;

    public LoopToken(String args) {
        super(args);
    }

    public LoopToken(String name, boolean struct, boolean xpriv) {
        this.name = name;
        this.struct = struct;
        this.xpriv = xpriv;
        this.step = true;
    }

    public boolean processArg(String value, int index) {
        if (super.processArg(value, index)) {
            return true;
        }
        if (value.charAt(0) == '-') {
            if (value.equals("-eol")) {
                this.eol = true;
                return true;
            }
            if (value.equals("-struct")) {
                this.struct = true;
                return true;
            }
            if (value.equals("-excludeprivate")) {
                this.xpriv = true;
                return true;
            }
        } else {
            this.name = value;
        }
        if (this.name == null) {
            this.struct = true;
        }
        return true;
    }

    public boolean isEndToken(Object o) {
        int idx;
        if (o instanceof EndToken) {
            return true;
        }
        if (o instanceof String && this.eol && (idx = ((String)o).indexOf(10)) >= 0) {
            this.eolTok = ((String)o).substring(0, idx + 1);
            this.eolRem = ((String)o).substring(idx + 1);
            return true;
        }
        return false;
    }

    public void eval(Reporter r) {
        this.eval(r, null);
    }

    public void eval(Reporter r, String encoding) {
        Object scope;
        Object object = scope = this.struct && this.name == null ? r.current : r.get(this.name);
        if (!(scope instanceof Table)) {
            if (scope instanceof IDataCodable) {
                scope = ((IDataCodable)scope).getIData();
            } else if (!(scope instanceof IData) && scope instanceof ValuesCodable) {
                scope = ((ValuesCodable)scope).getValues();
            } else if (scope instanceof IDataPortable) {
                scope = ((IDataPortable)scope).getAsData();
            } else if (this.struct && !(scope instanceof IData)) {
                return;
            }
        }
        this.last = false;
        if (scope instanceof String) {
            super.eval(r, encoding);
            return;
        }
        if (scope instanceof Object[]) {
            Object[] ary = (Object[])scope;
            this.evalArray(r, ary, encoding);
        } else if (scope instanceof Vector) {
            Vector v = (Vector)scope;
            this.evalVector(r, v, encoding);
        } else if (scope instanceof Table) {
            Table t = (Table)scope;
            this.evalTable(r, t, encoding);
        } else if (scope instanceof IData) {
            IData c = (IData)scope;
            this.evalCodable(r, c, encoding);
        } else if (JournalLogger.isLogEnabledDebugPlus(6, 13, 72)) {
            JournalLogger.logDebugPlus(6, 13, 72, scope != null ? scope.toString() : "null");
        }
        if (this.eolRem != null) {
            r.append(this.eolRem);
        }
        if (!this.step) {
            LoopToken parentLoop = this.getParentLoop();
            r.INDEX = parentLoop == null ? -1 : parentLoop.getIndex();
        }
    }

    public LoopToken getParentLoop() {
        for (TemplateToken parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof LoopToken)) continue;
            return (LoopToken)parent;
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    private void evalArray(Reporter r, Object[] ary, String encoding) {
        this.len = ary.length;
        if (!this.step) {
            this.index = 0;
            while (this.index < this.len) {
                this.stepArray(r, ary, encoding);
                ++this.index;
            }
        } else {
            if (this.target == null) {
                this.target = ary;
                this.index = -1;
            }
            ++this.index;
            if (this.index < this.len) {
                this.stepArray(r, ary, encoding);
            } else {
                this.target = null;
            }
        }
    }

    public boolean hasMoreElements() {
        return this.index < this.len - 1;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public void step(Reporter r) {
        this.step(r, null);
    }

    public void step(Reporter r, String encoding) {
        if (this.target instanceof Object[]) {
            this.evalArray(r, (Object[])this.target, encoding);
        } else if (this.target instanceof IData) {
            this.evalCodable(r, (IData)this.target, encoding);
        } else if (this.target instanceof Table) {
            this.evalTable(r, (Table)this.target, encoding);
        }
    }

    private void stepArray(Reporter r, Object[] ary, String encoding) {
        if (this.index == this.len - 1) {
            this.last = true;
        }
        r.INDEX = this.index;
        if (ary instanceof String[][]) {
            super.eval(r, encoding);
        } else if (ary instanceof String[]) {
            super.eval(r, encoding);
        } else if (ary instanceof IData[]) {
            IData c = ((IData[])ary)[this.index];
            this.evalChildrenInScope(r, c, encoding);
        } else if (ary instanceof ValuesCodable[]) {
            Values c = ((ValuesCodable[])ary)[this.index].getValues();
            this.evalChildrenInScope(r, c, encoding);
        } else if (ary instanceof IDataCodable[]) {
            IData c = ((IDataCodable[])ary)[this.index].getIData();
            this.evalChildrenInScope(r, Values.use(c), encoding);
        } else if (ary instanceof IDataPortable[]) {
            IData c = ((IDataPortable[])ary)[this.index].getAsData();
            this.evalChildrenInScope(r, Values.use(c), encoding);
        } else {
            super.eval(r, encoding);
        }
        if (this.eolTok != null) {
            r.append(this.eolTok);
        }
    }

    private void evalVector(Reporter r, Vector v, String encoding) {
        int len = v.size();
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                this.last = true;
            }
            r.INDEX = i;
            Object o = v.elementAt(i);
            IData c = null;
            if (o instanceof Table) {
                c = ((ValuesCodable)o).getValues();
            } else if (o instanceof IData) {
                c = (IData)o;
            } else if (o instanceof IDataCodable) {
                c = ((IDataCodable)o).getIData();
            } else if (o instanceof ValuesCodable) {
                c = ((ValuesCodable)o).getValues();
            } else if (o instanceof IDataPortable) {
                c = ((IDataPortable)o).getAsData();
            }
            if (c == null) continue;
            this.evalChildrenInScope(r, c, encoding);
            if (this.eolTok == null) continue;
            r.append(this.eolTok);
        }
    }

    private void evalTable(Reporter r, Table t, String encoding) {
        this.len = t.getRowCount();
        if (!this.step) {
            this.index = 0;
            while (this.index < this.len) {
                this.stepTable(r, t, encoding);
                ++this.index;
            }
        } else {
            if (this.target == null) {
                this.target = t;
                this.index = -1;
            }
            ++this.index;
            if (this.index < this.len) {
                this.stepTable(r, t, encoding);
            } else {
                this.target = null;
            }
        }
    }

    private void stepTable(Reporter r, Table t, String encoding) {
        if (this.index == this.len - 1) {
            this.last = true;
        }
        r.INDEX = this.index;
        this.evalChildrenInScope(r, t.getRow(this.index), encoding);
        if (this.eolTok != null) {
            r.append(this.eolTok);
        }
    }

    private void evalCodable(Reporter r, IData c, String encoding) {
        block9: {
            block8: {
                block7: {
                    if (!this.struct) break block8;
                    if (!this.step || this.step && this.target == null) {
                        r.pushVal(c);
                        this.len = 0;
                        IDataCursor id = c.getCursor();
                        while (id.next()) {
                            ++this.len;
                        }
                        this.cursor = c.getCursor();
                        if (this.step) {
                            this.target = c;
                            this.index = -1;
                        }
                    }
                    if (!this.step) {
                        this.index = 0;
                        while (this.index++ < this.len) {
                            this.stepCodable(r, c, encoding);
                        }
                        r.popVal();
                    } else {
                        do {
                            ++this.index;
                            if (this.index >= this.len) break block7;
                        } while (!this.stepCodable(r, c, encoding));
                    }
                    break block9;
                }
                r.popVal();
                this.target = null;
                break block9;
            }
            this.len = 1;
            this.evalChildrenInScope(r, c, encoding);
        }
    }

    private boolean stepCodable(Reporter r, IData c, String encoding) {
        this.cursor.next();
        if (!this.cursor.hasMoreData() || this.index == this.len) {
            this.last = true;
        }
        r.key = this.cursor.getKey();
        r.keyCursor = this.cursor;
        if (this.xpriv && r.key.startsWith("$")) {
            return false;
        }
        Object o = this.cursor.getValue();
        IData save = r.currentCodable;
        if (o instanceof IData) {
            r.currentCodable = (IData)o;
        }
        super.eval(r, encoding);
        r.currentCodable = save;
        return true;
    }

    public void evalChild(Reporter r, Object o, String encoding) {
        if (o instanceof LoopSepToken) {
            if (!this.last) {
                ((LoopSepToken)o).eval(r, encoding);
            }
            return;
        }
        if (o instanceof ValueToken) {
            ValueToken vt = (ValueToken)o;
            vt.evalLoopValue(r, encoding, this.name, this.struct);
            return;
        }
        super.evalChild(r, o, encoding);
    }

    public String getName() {
        return this.name;
    }

    public boolean getStruct() {
        return this.struct;
    }

    public boolean getExcludePrivate() {
        return this.xpriv;
    }
}

