/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.ValuesEmulator;
import com.wm.lang.ns.NSName;
import com.wm.util.LocalizedException;
import com.wm.util.template.OnErrorToken;
import com.wm.util.template.Reporter;
import com.wm.util.template.TemplateToken;

public class InvokeToken
extends TemplateToken {
    NSName service;
    boolean gotError;
    boolean succeed;

    public InvokeToken(String args) {
        super(args);
    }

    public InvokeToken(NSName service) {
        this.service = service;
    }

    public boolean processArg(String value, int index) {
        if (super.processArg(value, index)) {
            return true;
        }
        this.service = NSName.create(value);
        return true;
    }

    public void eval(Reporter r) {
        this.eval(r, null);
    }

    public void eval(Reporter r, String encoding) {
        if (this.service == null) {
            return;
        }
        this.gotError = false;
        this.succeed = false;
        IData ret = null;
        IData input = this.getValuesForInput(r);
        try {
            ret = r.invoke(this.service, input);
            IDataCursor idret = ret.getCursor();
            if (!idret.first("$error")) {
                this.succeed = true;
            } else {
                String type = ValuesEmulator.getString(ret, "$errorType");
                String msg = ValuesEmulator.getString(ret, "$error");
                String localizedMsg = ValuesEmulator.getString(ret, "$localizedError");
                ret = this.getErrorValues(type, msg, localizedMsg, input, ret);
                this.succeed = false;
            }
            idret.destroy();
        }
        catch (LocalizedException le) {
            ret = this.getErrorValues(le.getClass().toString(), le.getMessage(), le.getLocalizedMessage(r.getLocale()), input, null);
            this.succeed = false;
        }
        catch (Exception e) {
            ret = this.getErrorValues(e.getClass().toString(), e.getMessage(), e.getLocalizedMessage(), input, null);
            this.succeed = false;
        }
        this.evalChildrenInScope(r, ret, encoding);
    }

    public void evalChild(Reporter r, Object o, String encoding) {
        if (o instanceof OnErrorToken) {
            this.gotError = true;
            return;
        }
        if (this.succeed && !this.gotError || !this.succeed && this.gotError) {
            super.evalChild(r, o, encoding);
        }
    }

    private IData getValuesForInput(Reporter r) {
        return r.current;
    }

    private IData getErrorValues(String errorClass, String errorMessage, String localMessage, IData inputs, IData outputs) {
        Object[][] o = new Object[][]{{"error", errorClass}, {"errorMessage", errorMessage}, {"localizedMessage", localMessage}, {"errorInputs", inputs}, {"errorOutputs", outputs}, {"errorService", this.service.toString()}};
        return IDataFactory.create(o);
    }

    public NSName getService() {
        return this.service;
    }

    public boolean hasError() {
        return !this.succeed;
    }
}

