/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.template;

import com.wm.data.IData;
import com.wm.util.JournalLogger;
import com.wm.util.template.Reporter;
import com.wm.util.template.TemplateToken;
import com.wm.util.template.TemplateTokenizer;
import java.util.StringTokenizer;

public class IncludeToken
extends TemplateToken {
    String url;
    String vals;
    boolean isVarName;

    public IncludeToken(String args) {
        super(args);
        StringTokenizer st = new StringTokenizer(args, " ");
        if (st.hasMoreTokens()) {
            this.url = st.nextToken();
        }
        if (this.url != null && this.url.equals("-var")) {
            this.isVarName = true;
            if (st.hasMoreTokens()) {
                this.url = st.nextToken();
            }
        }
        if (st.hasMoreTokens()) {
            this.vals = st.nextToken();
        }
    }

    public void parse(TemplateTokenizer tt) {
    }

    public void eval(Reporter r) {
        this.eval(r, null);
    }

    public void eval(Reporter r, String encoding) {
        if (this.url == null) {
            return;
        }
        IData send = r.current;
        if (this.vals != null) {
            Object o = r.get(this.vals);
            if (!(o instanceof IData)) {
                if (JournalLogger.isLogEnabledDebugPlus(6, 15, 72)) {
                    JournalLogger.logDebugPlus(6, 15, 72, o != null ? o.toString() : "");
                }
                return;
            }
            send = (IData)o;
        }
        try {
            Reporter r2 = new Reporter(this.url, r.templateDir, encoding, send, r.locale);
            r2.stack = r.stack;
            r2.current = r.current;
            r2.keys = r.keys;
            r2.key = r.key;
            r2.os = r.os;
            r2.ns = r.ns;
            r2.locale = r.locale;
            r2.reportNoReset();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (JournalLogger.isLogEnabledDebugPlus(6, 16, 72)) {
                JournalLogger.logDebugPlus(6, 16, 72, e);
            }
            return;
        }
    }

    public String getUrl() {
        return this.url;
    }
}

