/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tar;

import com.wm.util.ByteOutputBuffer;
import com.wm.util.LocalizedIOException;
import com.wm.util.tar.TarEntry;
import com.wm.util.tar.resources.TarExceptionBundle;
import java.io.IOException;
import java.io.OutputStream;

public class TarOutputStream
extends OutputStream {
    OutputStream os;
    ByteOutputBuffer bo;
    TarEntry next;
    long btotal = 0L;

    public TarOutputStream(OutputStream os) {
        this.os = os;
    }

    public void putNextEntry(TarEntry te) throws IOException {
        if (this.next != null && (long)this.bo.size() < this.next.getSize()) {
            Object[] subs = new String[]{Long.toString(this.next.getSize()), Long.toString(this.bo.size())};
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.OUTPUT_1, "", subs);
        }
        this.next = te;
        this.bo = new ByteOutputBuffer();
    }

    public void closeEntry() throws IOException {
        if (this.next.getSize() == -1L) {
            this.next.setSize(this.bo.size());
        }
        if ((long)this.bo.size() < this.next.getSize()) {
            Object[] subs = new String[]{Long.toString(this.next.getSize()), Long.toString(this.bo.size())};
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.OUTPUT_1, "", subs);
        }
        this.next.write(this.os);
        ++this.btotal;
        if (this.next.notDirType()) {
            this.bo.writeToStream(this.os);
            this.btotal += (long)(this.bo.size() / 512);
            int lo = 512 - this.bo.size() % 512;
            if (lo != 512) {
                ++this.btotal;
                for (int i = 0; i < lo; ++i) {
                    this.os.write(0);
                }
            }
        }
    }

    public void write(int ch) throws IOException {
        if (this.next == null) {
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.OUTPUT_2, "");
        }
        if ((long)this.bo.size() > this.next.getSize()) {
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.OUTPUT_3, "", Long.toString(this.next.getSize()));
        }
        this.bo.write(ch);
    }

    public void close() throws IOException {
        int i = 0;
        while ((long)i < 20L - this.btotal % 20L) {
            for (int j = 0; j < 512; ++j) {
                this.os.write(0);
            }
            ++i;
        }
        this.os.flush();
        this.os.close();
    }
}

