/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tar;

import com.wm.util.tar.TarBlock;
import com.wm.util.tar.TarEntry;
import java.io.IOException;
import java.io.InputStream;

public class TarInputStream
extends InputStream {
    TarEntry current;
    TarBlock cblock;
    InputStream is;
    long bread = 0L;
    long blimit = 0L;
    long pos = 0L;

    public TarInputStream(InputStream is) {
        this.is = is;
    }

    TarEntry nextEntry() throws IOException {
        if (this.current != null && this.pos < this.current.getSize()) {
            while (this.bread < this.blimit) {
                this.nextBlock();
            }
        }
        this.current = new TarEntry(this.is);
        if (this.current.isNull()) {
            return null;
        }
        this.bread = 0L;
        this.blimit = this.current.getBlocks();
        this.cblock = null;
        this.nextBlock();
        return this.current;
    }

    public int read() throws IOException {
        if (this.current.getSize() == 0L || this.pos >= this.current.getSize() || this.current.getTypeFlag() == 53) {
            return -1;
        }
        this.checkPos();
        return this.cblock.nextByte();
    }

    private void checkPos() throws IOException {
        if (this.cblock.hasMoreData()) {
            return;
        }
        if (this.bread < this.blimit) {
            this.nextBlock();
        }
    }

    private void nextBlock() throws IOException {
        long diff;
        this.cblock = this.cblock == null ? (this.current.getSize() > 0L ? new TarBlock(this.is, this.current.getSize()) : new TarBlock()) : new TarBlock(this.is);
        ++this.bread;
        if (this.bread == this.blimit && (diff = this.current.getSize() % 512L) > 0L) {
            this.cblock.setLimit((int)diff);
        }
    }
}

