/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tar;

import com.wm.util.ByteOutputBuffer;
import com.wm.util.LocalizedIOException;
import com.wm.util.tar.TarBlock;
import com.wm.util.tar.resources.TarExceptionBundle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarEntry
extends TarBlock {
    public static final int REGTYPE = 48;
    public static final int AREGTYPE = 0;
    public static final int LNKTYPE = 49;
    public static final int SYMTYPE = 50;
    public static final int CHRTYPE = 51;
    public static final int BLKTYPE = 52;
    public static final int DIRTYPE = 53;
    public static final int FIFOTYPE = 54;
    public static final int CONTTYPE = 55;
    String name;
    int mode;
    int uid;
    int gid;
    long size;
    long mtime;
    int chksum;
    byte typeflag;
    String linkname;
    String magic;
    String version;
    String uname;
    String gname;
    int devmajor;
    int devminor;
    String prefix;
    long blocks;

    TarEntry() {
        this.mode = 488;
        this.size = -1L;
        this.uid = 0;
        this.gid = 0;
        this.uname = "root";
        this.gname = "root";
        this.devmajor = -1;
        this.devminor = -1;
        this.typeflag = (byte)48;
        this.magic = "ustar ";
        this.version = " ";
        this.mtime = 0L;
    }

    TarEntry(String name) {
        this();
        this.name = name;
    }

    TarEntry(File f) {
        this();
        if (f.isDirectory()) {
            this.typeflag = (byte)53;
        }
        this.size = f.length();
        this.name = f.getName();
        this.prefix = f.getParent();
    }

    TarEntry(InputStream is) throws IOException {
        super(is);
        if (this.data[0] == 0) {
            return;
        }
        this.name = this.NSrange(0, 100);
        this.mode = this.NIrange(100, 108);
        this.uid = this.NIrange(108, 116);
        this.gid = this.NIrange(116, 124);
        this.size = this.NLrange(124, 136);
        this.mtime = this.NLrange(136, 148);
        this.chksum = this.NIrange(148, 156);
        this.typeflag = this.data[156];
        this.linkname = this.NSrange(157, 257);
        this.magic = this.NSrange(257, 263);
        this.version = this.NSrange(263, 265);
        this.uname = this.NSrange(265, 297);
        this.gname = this.NSrange(297, 329);
        this.devmajor = this.NIrange(329, 337);
        this.devminor = this.NIrange(337, 345);
        this.prefix = this.NSrange(345, 500);
        this.blocks = this.size / 512L;
        if (this.size % 512L != 0L) {
            ++this.blocks;
        }
    }

    boolean isNull() {
        return this.name == null;
    }

    String getName() {
        return this.name;
    }

    int getMode() {
        return this.mode;
    }

    int getUID() {
        return this.uid;
    }

    int getGID() {
        return this.gid;
    }

    long getSize() {
        return this.size;
    }

    long getMtime() {
        return this.mtime;
    }

    int getCheckSum() {
        return this.chksum;
    }

    byte getTypeFlag() {
        return this.typeflag;
    }

    String getLinkName() {
        return this.linkname;
    }

    String getMagic() {
        return this.magic;
    }

    String getVersion() {
        return this.version;
    }

    String getUName() {
        return this.uname;
    }

    String getGName() {
        return this.gname;
    }

    int getDevMajor() {
        return this.devmajor;
    }

    int getDevMinor() {
        return this.devminor;
    }

    String getPrefix() {
        return this.prefix;
    }

    long getBlocks() {
        return this.blocks;
    }

    String getFullName() {
        String p = this.getPrefix();
        if (p == null) {
            return this.getName();
        }
        return p + "/" + this.getName();
    }

    void setSize(long sz) {
        this.size = sz;
    }

    void setMTime(long mt) {
        this.mtime = mt / 1000L;
    }

    void setCheckSum(int ck) {
        this.chksum = ck;
    }

    void setPrefix(String pf) {
        this.prefix = pf;
    }

    void setTypeFlag(int tf) {
        this.typeflag = (byte)tf;
    }

    boolean notDirType() {
        return this.typeflag != 53 && this.typeflag != 49 && this.typeflag != 50;
    }

    void write(OutputStream os) throws IOException {
        ByteOutputBuffer bo = new ByteOutputBuffer();
        bo.write(this.pad(this.name, 100, 0));
        bo.write(this.pad(this.mode, 8, 0));
        bo.write(this.pad(this.uid, 8, 0));
        bo.write(this.pad(this.gid, 8, 0));
        bo.write(this.pad(this.size, 12, 0));
        bo.write(this.pad(this.mtime, 12, 0));
        bo.write("        ".getBytes());
        bo.write(this.typeflag);
        bo.write(this.pad(this.linkname, 100, 0));
        bo.write(this.pad(this.magic, 6, 0));
        bo.write(this.pad(this.version, 2, 0));
        bo.write(this.pad(this.uname, 32, 0));
        bo.write(this.pad(this.gname, 32, 0));
        if (this.devmajor >= 0) {
            bo.write(this.pad(this.devmajor, 8, 0));
        } else {
            bo.write(this.pad("", 8, 0));
        }
        if (this.devminor >= 0) {
            bo.write(this.pad(this.devminor, 8, 0));
        } else {
            bo.write(this.pad("", 8, 0));
        }
        bo.write(this.pad(this.prefix, 155, 0));
        bo.write("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes());
        this.data = bo.toByteArray();
        this.chksum = 0;
        for (int i = 0; i < this.data.length; ++i) {
            this.chksum += this.data[i];
        }
        this.replace(this.data, 148, this.pad(this.chksum, 7, 0));
        super.write(os);
    }

    static String getOctal(long target, int len) {
        StringBuffer sb = new StringBuffer();
        long div = (long)Math.pow(8.0, len);
        long num = target;
        for (int i = 0; i < len; ++i) {
            long d = num / div;
            if (sb.length() > 0 || d > 0L) {
                sb.append(d);
            }
            num -= d * div;
            div /= 8L;
        }
        sb.append(num);
        if (sb.length() < len - 1) {
            int add = len - sb.length() - 1;
            for (int i = 0; i < add; ++i) {
                sb.insert(0, " ");
            }
        }
        return sb.toString();
    }

    byte[] pad(long s, int len, int pchar) throws IOException {
        return this.pad(TarEntry.getOctal(s, len), len, pchar);
    }

    byte[] pad(int s, int len, int pchar) throws IOException {
        return this.pad(TarEntry.getOctal(s, len), len, pchar);
    }

    byte[] pad(String s, int len, int pchar) throws IOException {
        if (s == null) {
            return this.pad("", len, pchar);
        }
        return this.pad(s.getBytes(), len, pchar);
    }

    byte[] pad(byte[] d, int len, int pchar) throws IOException {
        byte[] rd = new byte[len];
        if (d.length > len) {
            Object[] subs = new String[]{Integer.toString(d.length), Integer.toString(len), new String(d)};
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.TARENTRY, "", subs);
        }
        int pad = len - d.length;
        System.arraycopy(d, 0, rd, 0, d.length);
        for (int i = d.length; i < len; ++i) {
            rd[i] = (byte)pchar;
        }
        return rd;
    }

    long NLrange(int start, int end) {
        String s = new String(this.range(start, this.nullIndex(start, end)));
        return TarEntry.octalVal(s);
    }

    int NIrange(int start, int end) {
        String s = new String(this.range(start, this.nullIndex(start, end)));
        return (int)TarEntry.octalVal(s);
    }

    public static void main(String[] args) {
        System.out.println(TarEntry.getOctal(Long.parseLong(args[0]), 12));
    }

    static long octalVal(String val) {
        String s = val.trim();
        if (s.length() == 0) {
            return -1L;
        }
        long ret = 0L;
        long mult = 1L;
        for (int i = s.length(); i > 0; --i) {
            ret += mult * (long)(s.charAt(i - 1) - 48);
            mult *= 8L;
        }
        return ret;
    }

    String NSrange(int start, int end) {
        return new String(this.range(start, this.nullIndex(start, end)));
    }

    void replace(byte[] data, int start, byte[] d) {
        for (int i = 0; i < d.length; ++i) {
            data[i + start] = d[i];
        }
    }

    byte[] range(int start, int end) {
        byte[] b = new byte[end - start];
        System.arraycopy(this.data, start, b, 0, end - start);
        return b;
    }

    int nullIndex(int offset, int max) {
        return this.indexOf(0, offset, max);
    }

    int indexOf(int ch, int offset, int max) {
        int z;
        for (z = offset; z < this.data.length && z < max; ++z) {
            if (this.data[z] != ch) continue;
            return z;
        }
        if (z == max) {
            return z;
        }
        return -1;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        return "name = " + this.getName() + nl + "mode = " + this.getMode() + nl + "uid = " + this.getUID() + nl + "gid = " + this.getGID() + nl + "size = " + this.getSize() + nl + "mtime = " + this.getMtime() + nl + "checksum = " + this.getCheckSum() + nl + "typeflag = " + this.getTypeFlag() + nl + "linkname = " + this.getLinkName() + nl + "magic = " + this.getMagic() + nl + "version = " + this.getVersion() + nl + "uname = " + this.getUName() + nl + "gname = " + this.getGName() + nl + "devmajor = " + this.getDevMajor() + nl + "devminor = " + this.getDevMinor() + nl + "prefix = " + this.getPrefix() + nl + "blocks = " + this.getBlocks() + nl + "---------------------" + nl + super.toString();
    }
}

