/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarBlock {
    static final int size = 512;
    byte[] data;
    long total;
    int pos;

    TarBlock() {
        this.pos = 0;
        this.total = 0L;
    }

    TarBlock(InputStream is) throws IOException {
        this(is, 512L);
    }

    TarBlock(InputStream is, long limit) throws IOException {
        this.total = Math.min(limit, 512L);
        this.read(is);
    }

    void setLimit(long limit) {
        this.total = limit;
    }

    void read(InputStream is) throws IOException {
        if (this.total == 0L) {
            return;
        }
        this.data = new byte[512];
        for (int toRead = 512; toRead > 0; toRead -= is.read(this.data, this.data.length - toRead, toRead)) {
        }
    }

    boolean hasMoreData() {
        return (long)this.pos < this.total;
    }

    int nextByte() {
        if ((long)this.pos < this.total) {
            return this.data[this.pos++];
        }
        return -1;
    }

    void write(OutputStream os) throws IOException {
        os.write(this.data);
    }

    public static String hexDump(byte[] d) {
        if (d == null) {
            return "<null block>";
        }
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        int il = Math.max(1, d.length / 16);
        for (int i = 0; i < il; ++i) {
            StringBuffer sb1 = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            for (int j = 0; j < 16; ++j) {
                if (i * 16 + j < d.length) {
                    byte ch = d[i * 16 + j];
                    sb1.append(TarBlock.hex(ch));
                    sb2.append(TarBlock.safechar(ch) + " ");
                    continue;
                }
                sb1.append(".. ");
                sb2.append(". ");
            }
            sb.append(sb1.toString() + " " + sb2.toString() + nl);
        }
        return sb.toString();
    }

    public String toString() {
        return TarBlock.hexDump(this.data);
    }

    static String hex(int val) {
        char ch1 = Character.forDigit(val >> 4 & 0xF, 16);
        char ch2 = Character.forDigit(val & 0xF, 16);
        return ch1 + "" + ch2 + " ";
    }

    static char safechar(int val) {
        if (Character.isISOControl((char)val)) {
            return '.';
        }
        return (char)val;
    }
}

