/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.tar;

import com.wm.util.LocalizedIOException;
import com.wm.util.tar.TarEntry;
import com.wm.util.tar.TarInputStream;
import com.wm.util.tar.TarOutputStream;
import com.wm.util.tar.resources.TarExceptionBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Tar {
    static String sep = File.separator;
    static final char CREATE = 'c';
    static final char EXTRACT = 'x';
    static final char TEST = 't';

    public static void main(String[] args) throws IOException {
        int mode = 99;
        String dir = ".";
        String tar = "default.tar";
        String prefix = null;
        boolean compress = false;
        boolean verbose = false;
        int index = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-x")) {
                mode = 120;
                continue;
            }
            if (args[i].equals("-c")) {
                mode = 99;
                continue;
            }
            if (args[i].equals("-t")) {
                mode = 116;
                continue;
            }
            if (args[i].equals("-p") && i < args.length - 2) {
                prefix = args[++i];
                continue;
            }
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-z")) {
                compress = true;
                continue;
            }
            if (index == 0) {
                tar = args[i];
            } else {
                dir = args[i];
            }
            ++index;
        }
        switch (mode) {
            case 99: {
                Tar.create(tar, dir, prefix, verbose, compress);
                break;
            }
            case 120: {
                Tar.extract(tar, dir, verbose, compress, true);
                break;
            }
            default: {
                Tar.extract(tar, dir, verbose, compress, false);
            }
        }
    }

    public static void create(String tar, String dir, String prefix, boolean verbose, boolean compress) throws IOException {
        File d = new File(dir);
        if (!d.exists()) {
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.TARGET_1, "");
        }
        if (!d.isDirectory()) {
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.TARGET_2, "");
        }
        TarOutputStream to = compress ? new TarOutputStream(new GZIPOutputStream(new FileOutputStream(tar))) : new TarOutputStream(new FileOutputStream(tar));
        String[] list = d.list();
        for (int i = 0; i < list.length; ++i) {
            Tar.addFile(new File(d.getAbsolutePath(), list[i]), prefix, to, verbose);
        }
        to.close();
    }

    private static void addFile(File f, String base, TarOutputStream to, boolean verbose) throws IOException {
        String bname;
        String name = f.getName().replace('\\', '/');
        String string = bname = base != null ? base + "/" + name : name;
        if (verbose) {
            System.out.println(bname);
        }
        if (f.isDirectory()) {
            String[] list = f.list();
            TarEntry te = new TarEntry(bname + "/");
            te.setTypeFlag(53);
            te.setMTime(f.lastModified());
            to.putNextEntry(te);
            to.closeEntry();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    File nf = new File(f.getAbsolutePath(), list[i]);
                    Tar.addFile(nf, bname, to, verbose);
                }
            }
        } else {
            int toRead;
            TarEntry te = new TarEntry(bname);
            te.setSize(f.length());
            te.setMTime(f.lastModified());
            FileInputStream fi = new FileInputStream(f);
            byte[] data = new byte[toRead];
            for (toRead = (int)f.length(); toRead > 0; toRead -= fi.read(data, data.length - toRead, toRead)) {
            }
            fi.close();
            to.putNextEntry(te);
            to.write(data);
            to.closeEntry();
        }
    }

    public static void extract(String tar, String target, boolean verbose, boolean decompress, boolean extract) throws IOException {
        TarEntry te;
        File d = new File(target);
        if (!d.exists()) {
            d.mkdirs();
        }
        if (!d.isDirectory()) {
            throw new LocalizedIOException(TarExceptionBundle.class, TarExceptionBundle.TARGET_3, "");
        }
        TarInputStream ti = decompress ? new TarInputStream(new GZIPInputStream(new FileInputStream(tar))) : new TarInputStream(new FileInputStream(tar));
        while ((te = ti.nextEntry()) != null) {
            int ch;
            if (verbose) {
                System.out.println(te.getFullName());
            }
            if (!extract) continue;
            String p = te.getPrefix();
            File f = p != null && p.length() > 0 ? new File(target + sep + p + sep + te.getName()) : new File(target, te.getName());
            if (te.getTypeFlag() == 53) {
                f.mkdirs();
                continue;
            }
            FileOutputStream fo = new FileOutputStream(f);
            while ((ch = ti.read()) != -1) {
                fo.write(ch);
            }
            fo.close();
        }
        ti.close();
    }
}

