/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.synch;

import com.wm.util.LocalizedIllegalMonitorStateException;
import com.wm.util.synch.resources.SynchExceptionBundle;

public class RecursiveMutex {
    private Thread owner;
    private int count;

    public synchronized void lock() {
        while (this.owner != null && !this.owner.equals(Thread.currentThread())) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.owner = Thread.currentThread();
        ++this.count;
    }

    public synchronized void unlock() {
        if (!this.owner.equals(Thread.currentThread())) {
            throw new LocalizedIllegalMonitorStateException(SynchExceptionBundle.class, SynchExceptionBundle.MUTEX, "");
        }
        if (this.count == 0) {
            this.owner = null;
            this.notify();
        }
    }
}

