/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.synch;

import com.wm.util.JournalLogger;
import com.wm.util.synch.ConditionVariable;
import com.wm.util.synch.Mutex;

public class ReadWriteLock {
    private Thread writer;
    private int activeReaders;
    private int waitingReaders;
    private int waitingWriters;
    private Mutex resource = new Mutex();
    private ConditionVariable canRead = new ConditionVariable();
    private ConditionVariable canWrite = new ConditionVariable();

    public void getForRead() {
        this.resource.lock();
        ++this.waitingReaders;
        while (this.writer != null || this.waitingWriters > 0) {
            this.canRead.condWait(this.resource);
        }
        --this.waitingReaders;
        ++this.activeReaders;
        this.resource.unlock();
    }

    public void getForWrite() {
        this.resource.lock();
        ++this.waitingWriters;
        while (this.writer != null || this.activeReaders > 0) {
            this.canWrite.condWait(this.resource);
        }
        --this.waitingWriters;
        this.writer = Thread.currentThread();
        this.resource.unlock();
    }

    public synchronized void release() {
        this.resource.lock();
        if (this.writer != null) {
            this.writer = null;
        } else if (this.activeReaders > 0) {
            --this.activeReaders;
        } else {
            JournalLogger.logError(9999, 18, "Release read lock when lock not held!");
        }
        if (this.waitingWriters > 0 && this.activeReaders == 0) {
            this.canWrite.condNotify();
        } else if (this.waitingWriters == 0 && this.waitingReaders > 0) {
            this.canRead.condNotifyAll();
        }
        this.resource.unlock();
    }
}

