/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.synch;

import com.wm.util.LocalizedIllegalMonitorStateException;
import com.wm.util.synch.resources.SynchExceptionBundle;

public class Mutex {
    private Thread owner;

    public synchronized void lock() {
        while (this.owner != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.owner = Thread.currentThread();
    }

    public synchronized void unlock() {
        if (!this.owner.equals(Thread.currentThread())) {
            throw new LocalizedIllegalMonitorStateException(SynchExceptionBundle.class, SynchExceptionBundle.MUTEX, "");
        }
        this.owner = null;
        this.notify();
    }

    public synchronized boolean attempt(long msecs) {
        if (this.owner == null) {
            this.owner = Thread.currentThread();
            return true;
        }
        if (msecs <= 0L) {
            return false;
        }
        long waitTime = msecs;
        long start = System.currentTimeMillis();
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.owner != null) continue;
            this.owner = Thread.currentThread();
            return true;
        } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }
}

