/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.synch;

public class LatchedSemaphore {
    int _waiters = 0;
    boolean _signaled = false;

    public LatchedSemaphore(boolean state) {
        this._signaled = state;
    }

    public LatchedSemaphore() {
    }

    public synchronized void semWait() throws InterruptedException {
        this.semWait(0);
    }

    public synchronized void semWait(int time) throws InterruptedException {
        ++this._waiters;
        while (!this._signaled) {
            if (time == 0) {
                this.wait();
                continue;
            }
            this.wait(time);
            if (this._signaled) continue;
        }
        --this._waiters;
        if (this._signaled && this._waiters > 0) {
            this.notify();
        }
    }

    public synchronized void semPost() {
        this._signaled = true;
        if (this._waiters > 0) {
            this.notify();
        }
    }

    public synchronized boolean isSignaled() {
        return this._signaled;
    }

    public synchronized void semReset() {
        this._signaled = false;
    }

    public synchronized void semWaitReset() throws InterruptedException {
        this.semWait(0);
        this.semReset();
    }

    public synchronized void semWaitReset(int time) throws InterruptedException {
        this.semWait(time);
        this.semReset();
    }
}

