/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.sync;

import com.wm.util.BasisRuntimeException;

public class WmMutex {
    private static final String COREBUNDLE = "com.wm.resources.CoreExcpMsgs";
    private Thread _owner = null;
    private int _waiters = 0;
    private int _count = 0;

    public synchronized void lock() {
        if (this._owner != null && this._owner.equals(Thread.currentThread())) {
            ++this._count;
        } else {
            ++this._waiters;
            while (this._waiters > 1) {
                try {
                    this.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            this._count = 1;
            this._owner = Thread.currentThread();
        }
    }

    public synchronized void unlock() {
        if (this._owner == null || !this._owner.equals(Thread.currentThread())) {
            throw new BasisRuntimeException("BAC.0008.0030", COREBUNDLE, new String[]{"thread"});
        }
        --this._count;
        if (this._count > 0) {
            return;
        }
        if (this._waiters > 0) {
            this.notify();
        }
        this._owner = null;
        this._count = 0;
        --this._waiters;
    }

    public synchronized boolean isAcquired() {
        return this._owner != null && this._owner.equals(Thread.currentThread()) && this._waiters != 0;
    }

    public synchronized boolean isOwned() {
        return this._owner != null;
    }
}

