/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.sync;

import com.wm.txn.ITransaction;
import com.wm.util.BasisRuntimeException;

public class TxnMutex {
    private ITransaction _owner = null;
    private int _waiters = 0;
    private int _count = 0;
    private boolean debug = false;
    private static final String COREBUNDLE = "com.wm.resources.CoreExcpMsgs";

    boolean DebugOn() {
        return this.debug;
    }

    void log(String msg) {
        System.out.println(Thread.currentThread().getName() + "(" + this.hashCode() + "): " + msg);
    }

    public synchronized boolean attempt(ITransaction txn, long msecs) {
        if (!this.isOwned() && this._waiters == 0) {
            this.lock(txn);
            return true;
        }
        if (msecs <= 0L) {
            return false;
        }
        long waitTime = msecs;
        long start = System.currentTimeMillis();
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.isOwned() || this._waiters != 0) continue;
            this.lock(txn);
            return true;
        } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }

    public synchronized void lock(ITransaction txn) {
        if (this._owner != null && this._owner == txn) {
            ++this._count;
        } else {
            ++this._waiters;
            while (this._waiters > 1) {
                try {
                    if (this.DebugOn()) {
                        this.log("mutex: [c=" + this._count + " w=" + this._waiters + "] lock for txn=" + txn + ", waiting for owning txn=" + this._owner + " to release lock");
                    }
                    this.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            this._count = 1;
            this._owner = txn;
        }
        if (this.DebugOn()) {
            this.log("mutex: [c=" + this._count + "] lock granted to txn=" + txn);
        }
    }

    public synchronized void unlock(ITransaction txn) {
        if (this._owner == null || this._owner != txn) {
            throw new BasisRuntimeException("BAC.0008.0030", COREBUNDLE, new String[]{"transaction"});
        }
        --this._count;
        if (this._count > 0) {
            return;
        }
        if (this._waiters > 0) {
            this.notify();
        }
        if (this.DebugOn()) {
            this.log("mutex: [c=" + this._count + " w=" + this._waiters + "] unlock releasing lock held by txn=" + this._owner);
        }
        this._owner = null;
        this._count = 0;
        --this._waiters;
    }

    public synchronized boolean isAcquired(ITransaction txn) {
        return this._owner != null && this._owner == txn && this._waiters != 0;
    }

    public synchronized boolean isOwned() {
        return this._owner != null;
    }

    public synchronized ITransaction getOwner() {
        return this._owner;
    }
}

